/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceRelative;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.nbt.LittleNBTCompressionTools;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleActionPlaceAbsolute
extends LittleAction {
    public List<LittleTilePreview> previews;
    public boolean forced;
    public boolean placeAll;
    public LittleStructure structure;
    public boolean toVanilla;
    public List<LittleTileBox> boxes;
    public List<LittleTile> placedTiles;

    public LittleActionPlaceAbsolute(List<LittleTilePreview> previews, LittleStructure structure, boolean forced, boolean placeAll, boolean toVanilla) {
        this.previews = previews;
        this.forced = forced;
        this.placeAll = placeAll;
        this.structure = structure;
        this.toVanilla = toVanilla;
    }

    public LittleActionPlaceAbsolute(List<LittleTilePreview> previews, boolean forced) {
        this(previews, null, forced, false, false);
    }

    public LittleActionPlaceAbsolute() {
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        return new LittleActionDestroyBoxes(this.boxes);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        if (LittleActionPlaceAbsolute.drainPreviews(player, this.previews)) {
            BlockPos pos = this.previews.get((int)0).box.getMinVec().getBlockPos();
            LittleTileVec offset = new LittleTileVec((Vec3i)pos);
            LittleTileVec zero = new LittleTileVec(0, 0, 0);
            ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
            this.boxes = new ArrayList<LittleTileBox>();
            for (LittleTilePreview littleTilePreview : this.previews) {
                LittleTilePreview littleTilePreview2 = littleTilePreview.copy();
                littleTilePreview2.box.subOffset(offset);
                placePreviews.add(littleTilePreview2.getPlaceableTile(null, true, offset));
            }
            ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
            this.placedTiles = LittleActionPlaceRelative.placeTiles(player.field_70170_p, player, placePreviews, this.structure, this.placeAll, pos, null, unplaceableTiles, this.forced, EnumFacing.EAST);
            if (this.placedTiles != null) {
                for (LittleTile tile : this.placedTiles) {
                    LittleTileBox box = tile.box.copy();
                    box.addOffset((Vec3i)tile.te.func_174877_v());
                    this.boxes.add(box);
                }
                if (this.toVanilla) {
                    Object var7_10 = null;
                    for (LittleTile tile : this.placedTiles) {
                        void var7_11;
                        if (tile.te.func_174877_v() == var7_11) continue;
                        BlockPos blockPos = tile.te.func_174877_v();
                        tile.te.convertBlockToVanilla();
                    }
                }
            }
            LittleActionPlaceAbsolute.addTilesToInventory(player, unplaceableTiles);
            return this.placedTiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("list", (NBTBase)LittleNBTCompressionTools.writePreviews(this.previews));
        LittleActionPlaceAbsolute.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
        buf.writeBoolean(this.forced);
        buf.writeBoolean(this.placeAll);
        buf.writeBoolean(this.toVanilla);
        if (this.structure == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            NBTTagCompound structureNBT = new NBTTagCompound();
            this.structure.setTiles(null);
            this.structure.writeToNBT(structureNBT);
            this.structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
            LittleActionPlaceAbsolute.writeNBT((ByteBuf)buf, (NBTTagCompound)structureNBT);
        }
    }

    public void readBytes(ByteBuf buf) {
        this.previews = LittleNBTCompressionTools.readPreviews(LittleActionPlaceAbsolute.readNBT((ByteBuf)buf).func_150295_c("list", 10));
        this.forced = buf.readBoolean();
        this.placeAll = buf.readBoolean();
        this.toVanilla = buf.readBoolean();
        if (buf.readBoolean()) {
            this.structure = LittleStructure.createAndLoadStructure(LittleActionPlaceAbsolute.readNBT((ByteBuf)buf), null);
            this.structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        }
    }
}

