/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionPlaceRelative
extends LittleAction {
    public PlacementHelper.PositionResult position;
    public boolean centered;
    public boolean fixed;
    public boolean forced;
    public List<LittleTileBox> boxes;

    public LittleActionPlaceRelative(PlacementHelper.PositionResult position, boolean centered, boolean fixed, boolean forced) {
        this.position = position;
        this.centered = centered;
        this.fixed = fixed;
        this.forced = forced;
    }

    public LittleActionPlaceRelative() {
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        ItemStack stack = player.func_184614_ca();
        if (!LittleActionPlaceRelative.isAllowedToInteract(player, this.position.pos, true, EnumFacing.EAST)) {
            IBlockState state = player.field_70170_p.func_180495_p(this.position.pos);
            player.field_70170_p.func_184138_a(this.position.pos, state, state, 3);
            return false;
        }
        if (PlacementHelper.isLittleBlock(stack)) {
            List<LittleTile> tiles = this.placeTile(player, stack, player.field_70170_p, this.position, this.centered, this.fixed, this.forced);
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
            }
            return tiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        this.position.writeToBytes(buf);
        buf.writeBoolean(this.centered);
        buf.writeBoolean(this.fixed);
        buf.writeBoolean(this.forced);
    }

    public void readBytes(ByteBuf buf) {
        this.position = PlacementHelper.PositionResult.readFromBytes(buf);
        this.centered = buf.readBoolean();
        this.fixed = buf.readBoolean();
        this.forced = buf.readBoolean();
    }

    public List<LittleTile> placeTile(EntityPlayer player, ItemStack stack, World world, PlacementHelper.PositionResult position, boolean centered, boolean fixed, boolean forced) throws LittleActionException {
        List<LittleTile> placedTiles;
        LittleStructure structure = null;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        structure = iTile.getLittleStructure(stack);
        if (structure != null) {
            structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
            forced = false;
        }
        PlacementHelper.PreviewResult result = PlacementHelper.getPreviews(world, stack, position, centered, fixed, false, false);
        ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
        ItemStack toPlace = stack.func_77946_l();
        if (LittleActionPlaceRelative.needIngredients(player)) {
            if (iTile.containsIngredients(stack)) {
                stack.func_190918_g(1);
            } else {
                LittleActionPlaceRelative.drainPreviews(player, result.previews);
            }
        }
        if ((placedTiles = LittleActionPlaceRelative.placeTiles(world, player, result.placePreviews, structure, false, position.pos, toPlace, unplaceableTiles, forced, position.facing)) != null) {
            if (!world.field_72995_K) {
                for (int j = 0; j < unplaceableTiles.size(); ++j) {
                    LittleActionPlaceRelative.addTileToInventory(player, unplaceableTiles.get(j));
                }
            }
            this.boxes = new ArrayList<LittleTileBox>();
            for (LittleTile tile : placedTiles) {
                LittleTileBox box = tile.box.copy();
                box.addOffset((Vec3i)tile.te.func_174877_v());
                this.boxes.add(box);
            }
            return placedTiles;
        }
        return placedTiles;
    }

    public static List<LittleTile> placeTiles(World world, EntityPlayer player, List<PlacePreviewTile> previews, LittleStructure structure, boolean placeAll, BlockPos pos, ItemStack stack, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing) {
        HashMapList<BlockPos, PlacePreviewTile> splitted = LittleActionPlaceRelative.getSplittedTiles(previews, pos);
        if (splitted == null) {
            return null;
        }
        ArrayList<BlockPos> coordsToCheck = new ArrayList<BlockPos>();
        if (structure != null || placeAll) {
            coordsToCheck.addAll(splitted.getKeys());
        } else if (forced) {
            coordsToCheck.addAll(splitted.getKeys());
        } else {
            coordsToCheck.add(pos);
        }
        if (LittleActionPlaceRelative.canPlaceTiles(player, world, splitted, coordsToCheck, forced)) {
            ArrayList<LittleTile> placed = new ArrayList<LittleTile>();
            ArrayList<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
            ArrayList<LastPlacedTile> lastPlacedTiles = new ArrayList<LastPlacedTile>();
            for (Object coord : splitted.getKeys()) {
                TileEntityLittleTiles te;
                ArrayList placeTiles = splitted.getValues(coord);
                boolean hascollideBlock = false;
                int i = 0;
                while (i < placeTiles.size()) {
                    if (((PlacePreviewTile)placeTiles.get(i)).needsCollisionTest()) {
                        hascollideBlock = true;
                        ++i;
                        continue;
                    }
                    lastPlacedTiles.add(new LastPlacedTile((PlacePreviewTile)placeTiles.get(i), (BlockPos)coord));
                    placeTiles.remove(i);
                }
                if (!hascollideBlock) continue;
                boolean requiresCollisionTest = true;
                if (!(world.func_180495_p((BlockPos)coord).func_177230_c() instanceof BlockTile) && world.func_180495_p((BlockPos)coord).func_185904_a().func_76222_j()) {
                    requiresCollisionTest = false;
                    world.func_175656_a((BlockPos)coord, LittleTiles.blockTile.func_176223_P());
                }
                if ((te = LittleActionPlaceRelative.loadTe(world, (BlockPos)coord, false)) == null) continue;
                te.preventUpdate = true;
                for (int j = 0; j < placeTiles.size(); ++j) {
                    for (LittleTile LT : ((PlacePreviewTile)placeTiles.get(j)).placeTile(player, stack, (BlockPos)coord, te, structure, unplaceableTiles, forced, facing, requiresCollisionTest)) {
                        if (LT == null || structure != null && !structure.shouldPlaceTile(LT)) continue;
                        if (!soundsToBePlayed.contains(LT.getSound())) {
                            soundsToBePlayed.add(LT.getSound());
                        }
                        if (structure != null) {
                            if (!structure.hasMainTile()) {
                                structure.setMainTile(LT);
                            } else {
                                LT.coord = structure.getMainTileCoord(LT);
                            }
                        }
                        LT.isAllowedToSearchForStructure = false;
                        placed.add(LT);
                    }
                }
                te.preventUpdate = false;
                te.updateTiles();
            }
            for (int j = 0; j < lastPlacedTiles.size(); ++j) {
                for (LittleTile tile : ((LastPlacedTile)lastPlacedTiles.get((int)j)).tile.placeTile(player, stack, ((LastPlacedTile)lastPlacedTiles.get((int)j)).pos, null, structure, unplaceableTiles, forced, facing, true)) {
                    if (tile == null) continue;
                    placed.add(tile);
                }
            }
            if (structure != null) {
                structure.setMainTile(structure.getMainTile());
                Iterator<LittleTile> iterator = structure.getTiles();
                while (iterator.hasNext()) {
                    LittleTile tile = iterator.next();
                    tile.isAllowedToSearchForStructure = true;
                }
                structure.combineTiles();
            }
            for (int i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_184133_a((EntityPlayer)null, pos, ((SoundType)soundsToBePlayed.get(i)).func_185841_e(), SoundCategory.BLOCKS, (((SoundType)soundsToBePlayed.get(i)).func_185843_a() + 1.0f) / 2.0f, ((SoundType)soundsToBePlayed.get(i)).func_185847_b() * 0.8f);
            }
            return placed;
        }
        return null;
    }

    public static HashMapList<BlockPos, PlacePreviewTile> getSplittedTiles(List<PlacePreviewTile> tiles, BlockPos pos) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split((HashMapList<BlockPos, PlacePreviewTile>)splitted, pos)) continue;
            return null;
        }
        return splitted;
    }

    public static boolean canPlaceTiles(EntityPlayer player, World world, HashMapList<BlockPos, PlacePreviewTile> splitted, ArrayList<BlockPos> coordsToCheck, boolean forced) {
        for (BlockPos pos : coordsToCheck) {
            ArrayList tiles = splitted.getValues((Object)pos);
            boolean needsCollisionCheck = false;
            if (tiles != null) {
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                    needsCollisionCheck = true;
                    break;
                }
            }
            if (!needsCollisionCheck) continue;
            if (!LittleActionPlaceRelative.isAllowedToInteract(player, pos, true, EnumFacing.EAST)) {
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                player.field_70170_p.func_184138_a(pos, state, state, 3);
                return false;
            }
            TileEntityLittleTiles mainTile = LittleActionPlaceRelative.loadTe(world, pos, false);
            if (mainTile != null) {
                if (forced) {
                    return true;
                }
                if (tiles == null) continue;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest() || mainTile.isSpaceForLittleTile(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                    return false;
                }
                continue;
            }
            IBlockState state = world.func_180495_p(pos);
            if (forced) {
                if (!(state.func_177230_c() instanceof BlockTile) && !state.func_185904_a().func_76222_j()) continue;
                return true;
            }
            if (state.func_177230_c() instanceof BlockTile || state.func_185904_a().func_76222_j()) continue;
            return false;
        }
        return !forced;
    }

    public static class LastPlacedTile {
        public final PlacePreviewTile tile;
        public final BlockPos pos;

        public LastPlacedTile(PlacePreviewTile tile, BlockPos pos) {
            this.tile = tile;
            this.pos = pos;
        }
    }
}

