/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceRelative;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionReplace
extends LittleActionInteract {
    public LittleTilePreview toReplace;
    public List<LittleTilePreview> replacedTiles;
    public List<LittleTileBox> boxes;

    public LittleActionReplace(BlockPos blockPos, EntityPlayer player, LittleTilePreview toReplace) {
        super(blockPos, player);
        this.toReplace = toReplace;
    }

    public LittleActionReplace() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        this.toReplace.writeToNBT(nbt);
        LittleActionReplace.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toReplace = LittleTilePreview.loadPreviewFromNBT(LittleActionReplace.readNBT((ByteBuf)buf));
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (tile.isStructureBlock) {
            return false;
        }
        this.replacedTiles = new ArrayList<LittleTilePreview>();
        this.boxes = new ArrayList<LittleTileBox>();
        if (BlockTile.selectEntireBlock(player, secondMode)) {
            ArrayList<LittleTile> toRemove = new ArrayList<LittleTile>();
            for (LittleTile littleTile : te.getTiles()) {
                if (littleTile.isStructureBlock || !tile.canBeCombined(littleTile) || !littleTile.canBeCombined(tile)) continue;
                LittleTilePreview littleTilePreview = littleTile.getPreviewTile();
                littleTilePreview.box.addOffset((Vec3i)littleTile.te.func_174877_v());
                this.replacedTiles.add(littleTilePreview);
                this.boxes.add(littleTilePreview.box);
                toRemove.add(littleTile);
            }
            if (toRemove.isEmpty()) {
                return false;
            }
            LittleActionReplace.addPreviewToInventory(player, this.replacedTiles);
            ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
            for (LittleTile littleTile : toRemove) {
                littleTile.destroy();
                LittleTilePreview preview = this.toReplace.copy();
                preview.box = littleTile.box;
                previews.add(preview.getPlaceableTile(null, true, null));
            }
            ArrayList<LittleTile> arrayList = new ArrayList<LittleTile>();
            LittleActionPlaceRelative.placeTiles(world, player, previews, null, true, pos, stack, arrayList, false, EnumFacing.EAST);
            LittleActionReplace.addTilesToInventory(player, arrayList);
        } else {
            LittleTilePreview preview = tile.getPreviewTile();
            preview.box.addOffset((Vec3i)tile.te.func_174877_v());
            this.replacedTiles.add(preview);
            this.boxes.add(preview.box);
            LittleActionReplace.addPreviewToInventory(player, this.replacedTiles);
            tile.destroy();
            ArrayList<LittleTilePreview> toBePlaced = new ArrayList<LittleTilePreview>();
            this.toReplace.box = tile.box;
            toBePlaced.add(this.toReplace);
            LittleActionReplace.drainPreviews(player, toBePlaced);
            ArrayList<PlacePreviewTile> arrayList = new ArrayList<PlacePreviewTile>();
            arrayList.add(this.toReplace.getPlaceableTile(null, true, null));
            ArrayList<LittleTile> arrayList2 = new ArrayList<LittleTile>();
            LittleActionPlaceRelative.placeTiles(world, player, arrayList, null, true, pos, stack, arrayList2, false, EnumFacing.EAST);
            LittleActionReplace.addTilesToInventory(player, arrayList2);
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() throws LittleActionException {
        return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.replacedTiles, false));
    }
}

