/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.tool;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileAbsoluteCoord;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class LittleActionSaw
extends LittleActionInteract {
    public boolean toLimit;
    public LittleTileBox oldBox = null;
    public LittleTileBox newBox = null;
    public LittleTileAbsoluteCoord coord = null;
    public EnumFacing facing;

    public LittleActionSaw(BlockPos blockPos, EntityPlayer player, boolean toLimit) {
        super(blockPos, player);
        this.toLimit = toLimit;
    }

    public LittleActionSaw() {
    }

    @Override
    protected boolean isRightClick() {
        return true;
    }

    @Override
    public RayTraceResult rayTrace(TileEntityLittleTiles te, LittleTile tile) {
        RayTraceResult result = new LittleTileBox(tile.box).calculateIntercept(te.func_174877_v(), this.pos, this.look);
        if (result != null) {
            return result;
        }
        return super.rayTrace(te, tile);
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        this.facing = moving.field_178784_b;
        if (tile.canSawResizeTile(this.facing, player)) {
            LittleTileBox box;
            this.oldBox = tile.box.copy();
            EnumFacing.Axis axis = this.facing.func_176740_k();
            boolean outside = false;
            if (secondMode) {
                box = tile.box.shrink(this.facing, this.toLimit);
            } else {
                box = tile.box.grow(this.facing);
                if (tile.box.isFaceAtEdge(this.facing)) {
                    BlockPos newPos = te.func_174877_v().func_177972_a(this.facing);
                    te = LittleActionSaw.loadTe(world, newPos, true);
                    box = box.createOutsideBlockBox(this.facing);
                    outside = true;
                    if (te == null) {
                        return false;
                    }
                }
                if (this.toLimit) {
                    LittleTileBox before = null;
                    while (!box.isFaceAtEdge(this.facing) && te.isSpaceForLittleTile(box, tile)) {
                        before = box;
                        box = box.grow(this.facing);
                    }
                    if (!te.isSpaceForLittleTile(box, tile)) {
                        box = before;
                    }
                } else if (!te.isSpaceForLittleTile(box, tile)) {
                    box = null;
                }
            }
            if (box != null) {
                double amount = Math.abs(box.getPercentVolume() - tile.box.getPercentVolume());
                BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
                LittleTilePreview preview = tile.getPreviewTile();
                BlockIngredient ingredient = preview.getBlockIngredient();
                ingredient.value = amount;
                ingredients.addIngredient(ingredient);
                ColorUnit unit = null;
                if (preview.hasColor()) {
                    unit = ColorUnit.getRequiredColors(preview.getColor());
                    unit.BLACK = (int)((double)unit.BLACK * amount);
                    unit.RED = (int)((double)unit.RED * amount);
                    unit.GREEN = (int)((double)unit.GREEN * amount);
                    unit.BLUE = (int)((double)unit.BLUE * amount);
                }
                if (secondMode) {
                    LittleActionSaw.addIngredients(player, ingredients, unit);
                } else {
                    LittleActionSaw.drainIngredients(player, ingredients, unit);
                }
                if (outside) {
                    LittleTile newTile = tile.copy();
                    newTile.box = box;
                    newTile.te = te;
                    newTile.place();
                    te.updateBlock();
                    this.coord = new LittleTileAbsoluteCoord(newTile);
                    this.newBox = box.copy();
                    this.newBox.addOffset((Vec3i)te.func_174877_v());
                    return true;
                }
                tile.box = box;
                te.updateBlock();
                this.coord = new LittleTileAbsoluteCoord(tile);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        if (this.newBox != null) {
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            boxes.add(this.newBox);
            return new LittleActionDestroyBoxes(boxes);
        }
        return new LittleActionSawRevert(this.coord, this.oldBox, this.facing);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        buf.writeBoolean(this.toLimit);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toLimit = buf.readBoolean();
    }

    public static class LittleActionSawRevert
    extends LittleAction {
        public LittleTileBox oldBox;
        public LittleTileBox replacedBox;
        public LittleTileAbsoluteCoord coord;
        public LittleTileAbsoluteCoord newCoord;
        public EnumFacing facing;

        public LittleActionSawRevert(LittleTileAbsoluteCoord coord, LittleTileBox oldBox, EnumFacing facing) {
            this.coord = coord;
            this.oldBox = oldBox;
            this.facing = facing;
        }

        public LittleActionSawRevert() {
        }

        @Override
        public boolean canBeReverted() {
            return true;
        }

        @Override
        public LittleAction revert() throws LittleActionException {
            return new LittleActionSawRevert(this.newCoord, this.replacedBox, this.facing.func_176734_d());
        }

        @Override
        protected boolean action(EntityPlayer player) throws LittleActionException {
            LittleTile tile = LittleActionSawRevert.getTile(player.field_70170_p, this.coord);
            if (tile.canSawResizeTile(this.facing, player)) {
                double amount = Math.abs(this.oldBox.getPercentVolume() - tile.box.getPercentVolume());
                BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
                LittleTilePreview preview = tile.getPreviewTile();
                BlockIngredient ingredient = preview.getBlockIngredient();
                ingredient.value = amount;
                ingredients.addIngredient(ingredient);
                ColorUnit unit = null;
                if (preview.hasColor()) {
                    unit = ColorUnit.getRequiredColors(preview.getColor());
                    unit.BLACK = (int)((double)unit.BLACK * amount);
                    unit.RED = (int)((double)unit.RED * amount);
                    unit.GREEN = (int)((double)unit.GREEN * amount);
                    unit.BLUE = (int)((double)unit.BLUE * amount);
                }
                if (this.oldBox.getVolume() < tile.box.getVolume()) {
                    LittleActionSawRevert.addIngredients(player, ingredients, unit);
                } else {
                    LittleActionSawRevert.drainIngredients(player, ingredients, unit);
                }
                this.replacedBox = tile.box.copy();
                tile.box = this.oldBox;
                tile.te.updateBlock();
                this.newCoord = new LittleTileAbsoluteCoord(tile);
                return true;
            }
            return false;
        }

        public void writeBytes(ByteBuf buf) {
            LittleActionSawRevert.writeAbsoluteCoord(this.coord, buf);
            LittleActionSawRevert.writeLittleBox(this.oldBox, buf);
            LittleActionSawRevert.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
        }

        public void readBytes(ByteBuf buf) {
            this.coord = LittleActionSawRevert.readAbsoluteCoord(buf);
            this.oldBox = LittleActionSawRevert.readLittleBox(buf);
            this.facing = LittleActionSawRevert.readFacing((ByteBuf)buf);
        }
    }
}

