/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ILittleTile {
    public static final LittleTileVec rotationCenter = new LittleTileVec(LittleTile.halfGridSize * 2, LittleTile.halfGridSize * 2, LittleTile.halfGridSize * 2);

    public boolean hasLittlePreview(ItemStack var1);

    public List<LittleTilePreview> getLittlePreview(ItemStack var1);

    default public List<LittleTilePreview> getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        return this.getLittlePreview(stack);
    }

    public void saveLittlePreview(ItemStack var1, List<LittleTilePreview> var2);

    default public void rotateLittlePreview(ItemStack stack, Rotation rotation) {
        List<LittleTilePreview> previews = this.getLittlePreview(stack, false, false);
        for (int i = 0; i < previews.size(); ++i) {
            LittleTilePreview preview = previews.get(i);
            preview.rotatePreview(rotation, rotationCenter);
        }
        this.saveLittlePreview(stack, previews);
    }

    default public void flipLittlePreview(ItemStack stack, EnumFacing.Axis axis) {
        List<LittleTilePreview> previews = this.getLittlePreview(stack, false, false);
        for (int i = 0; i < previews.size(); ++i) {
            LittleTilePreview preview = previews.get(i);
            preview.flipPreview(axis, rotationCenter);
        }
        this.saveLittlePreview(stack, previews);
    }

    public LittleStructure getLittleStructure(ItemStack var1);

    @SideOnly(value=Side.CLIENT)
    default public boolean onRightClick(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void onDeselect(EntityPlayer player, ItemStack stack) {
    }

    default public boolean arePreviewsAbsolute() {
        return false;
    }

    default public boolean containsIngredients(ItemStack stack) {
        return !this.arePreviewsAbsolute();
    }

    @SideOnly(value=Side.CLIENT)
    default public void onClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    default public float getPreviewAlphaFactor() {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    default public boolean shouldCache() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public void tickPreview(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
    }

    default public PlacementMode getMode(EntityPlayer player, ItemStack stack) {
        if (stack.func_77942_o()) {
            return PlacementMode.getModeOrDefault(stack.func_77978_p().func_74779_i("mode"));
        }
        return PlacementMode.getDefault();
    }
}

