/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.blocks;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.RenderCubeLayerCache;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.action.block.LittleActionDestroy;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.items.ItemLittleSaw;
import com.creativemd.littletiles.common.items.ItemRubberMallet;
import com.creativemd.littletiles.common.packet.LittleNeighborUpdatePacket;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTile
extends BlockContainer
implements ICreativeRendered {
    public static final SoundType SILENT = new SoundType(-1.0f, 1.0f, SoundEvents.field_187835_fT, SoundEvents.field_187902_gb, SoundEvents.field_187845_fY, SoundEvents.field_187843_fX, SoundEvents.field_187841_fW);
    @SideOnly(value=Side.CLIENT)
    public static Minecraft mc;
    public static boolean cancelNext;
    public boolean first = true;
    private static boolean loadingTileEntityFromWorld;

    public static TileEntityLittleTiles loadTe(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        loadingTileEntityFromWorld = true;
        TileEntity tileEntity = null;
        try {
            tileEntity = world.func_175625_s(pos);
        }
        catch (Exception e) {
            return null;
        }
        loadingTileEntityFromWorld = false;
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    public static TEResult loadTeAndTile(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return new TEResult(te, te.getFocusedTile(player));
        }
        return new TEResult(null, null);
    }

    public static boolean selectEntireBlock(EntityPlayer player, boolean secondMode) {
        return secondMode && !(player.func_184614_ca().func_77973_b() instanceof ItemLittleSaw) && !(player.func_184614_ca().func_77973_b() instanceof ItemColorTube);
    }

    public BlockTile(Material material) {
        super(material);
        this.func_149647_a(LittleTiles.littleTab);
        this.func_149752_b(3.0f);
        this.func_149672_a(SILENT);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            LittleStructure bed = null;
            try {
                bed = (LittleStructure)LittleBed.littleBed.get(player);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            for (LittleTile tile : te.getTiles()) {
                if (tile.structure != bed) continue;
                return true;
            }
        }
        return false;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return EnumFacing.SOUTH;
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        int tries = 0;
        EnumFacing enumfacing = EnumFacing.EAST;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockTile.hasRoomForPlayer(world, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            AxisAlignedBB bb = entity.func_174813_aQ().func_186662_g(0.001);
            for (LittleTile tile : te.getTiles()) {
                if (!tile.isLadder()) continue;
                List<LittleTileBox> collision = tile.getCollisionBoxes();
                for (int j = 0; j < collision.size(); ++j) {
                    LittleTileBox box = collision.get(j).copy();
                    if (!bb.func_72326_a(box.getBox(te.func_174877_v()))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0.1f;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        return super.func_180647_a(state, player, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock((EntityPlayer)BlockTile.mc.field_71439_g, LittleAction.isUsingSecondMode((EntityPlayer)BlockTile.mc.field_71439_g))) {
                return result.te.getSelectionBox();
            }
            return result.tile.getSelectedBox(pos);
        }
        return new AxisAlignedBB(pos);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                List<LittleTileBox> boxes = tile.getCollisionBoxes();
                for (int i = 0; i < boxes.size(); ++i) {
                    boxes.get(i).addCollisionBoxes(entityBox, collidingBoxes, pos);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null && te.getTiles().size() == 0) {
            super.func_180663_b(world, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                tile.randomDisplayTick(stateIn, worldIn, pos, rand);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemRubberMallet) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return this.onBlockActivatedClient(worldIn, pos, state, playerIn, hand, heldItem, facing, hitX, hitY, hitZ);
        }
        if (cancelNext) {
            cancelNext = false;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onBlockActivatedClient(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            return new LittleActionActivated(pos, playerIn).execute();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int light = 0;
        if (!this.first) {
            return 0;
        }
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                this.first = false;
                int tempLight = tile.getLightValue(state, world, pos);
                this.first = true;
                if (tempLight <= light) continue;
                light = tempLight;
            }
        }
        return light;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            LittleTileBox box = null;
            switch (side) {
                case EAST: {
                    box = new LittleTileBox(LittleTile.gridSize - 1, 0, 0, LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize);
                    break;
                }
                case WEST: {
                    box = new LittleTileBox(0, 0, 0, 1, LittleTile.gridSize, LittleTile.gridSize);
                    break;
                }
                case UP: {
                    box = new LittleTileBox(0, LittleTile.gridSize - 1, 0, LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize);
                    break;
                }
                case DOWN: {
                    box = new LittleTileBox(0, 0, 0, LittleTile.gridSize, 1, LittleTile.gridSize);
                    break;
                }
                case SOUTH: {
                    box = new LittleTileBox(0, 0, LittleTile.gridSize - 1, LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize);
                    break;
                }
                case NORTH: {
                    box = new LittleTileBox(0, 0, 0, LittleTile.gridSize, LittleTile.gridSize, 1);
                    break;
                }
            }
            return te.isBoxFilled(box);
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return this.removedByPlayerClient(state, world, pos, player, willHarvest);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean removedByPlayerClient(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
        if (result.isComplete()) {
            return new LittleActionDestroy(pos, player).execute();
        }
        return false;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return te.getTiles().size() == 0;
        }
        return true;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        return stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            if (BlockTile.selectEntireBlock((EntityPlayer)BlockTile.mc.field_71439_g, LittleAction.isUsingSecondMode(player))) {
                ItemStack drop = new ItemStack(LittleTiles.multiTiles);
                LittleTilePreview.saveTiles(world, result.te.getTiles(), drop);
                return drop;
            }
            ArrayList<ItemStack> drops = result.tile.getDrops();
            if (drops.size() > 0 && drops.get(0) != null) {
                return drops.get(0);
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (LittleTile tile : te.getTiles()) {
                List<LittleTileBox> collision = tile.getCollisionBoxes();
                for (int i = 0; i < collision.size(); ++i) {
                    if (collision.get((int)i).maxY <= heighest) continue;
                    heighest = collision.get((int)i).maxY;
                    heighestTile = tile;
                }
            }
            if (heighestTile != null && heighestTile instanceof LittleTileBlock) {
                world.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f, new int[]{Block.func_176210_f((IBlockState)((LittleTileBlock)heighestTile).getBlockState())});
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState oldstate, World worldObj, RayTraceResult target, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldObj, target.func_178782_a(), (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete() && result.tile instanceof LittleTileBlock) {
            IBlockState state = ((LittleTileBlock)result.tile).getBlockState();
            BlockPos pos = target.func_178782_a();
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = result.tile.getSelectedBox(BlockPos.field_177992_a);
            double d0 = (double)i + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            EnumFacing side = target.field_178784_b;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete() && result.tile instanceof LittleTileBlock) {
            IBlockState state = ((LittleTileBlock)result.tile).getBlockState();
            int i = 4;
            for (int j = 0; j < 1; ++j) {
                for (int k = 0; k < 1; ++k) {
                    for (int l = 0; l < 1; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public SoundType getSoundTypeClient(IBlockState state, World world, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result != null && result.tile != null) {
            return result.tile.getSound();
        }
        return null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntityLittleTiles te;
        if (entity == null) {
            return SILENT;
        }
        SoundType sound = null;
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            sound = this.getSoundTypeClient(state, world, pos);
        }
        if (sound == null && (te = BlockTile.loadTe((IBlockAccess)world, pos)) != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (LittleTile tile : te.getTiles()) {
                List<LittleTileBox> collision = tile.getCollisionBoxes();
                for (int i = 0; i < collision.size(); ++i) {
                    if (collision.get((int)i).maxY <= heighest) continue;
                    heighest = collision.get((int)i).maxY;
                    heighestTile = tile;
                }
            }
            if (heighestTile != null) {
                return heighestTile.getSound();
            }
        }
        if (sound == null) {
            sound = SoundType.field_185851_d;
        }
        return sound;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        float bonus = 0.0f;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                bonus = (float)((double)bonus + (double)tile.getEnchantPowerBonus(world, pos) * tile.getPercentVolume());
            }
        }
        return bonus;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            if (worldIn.field_72995_K) {
                te.onNeighBorChangedClient();
            } else {
                PacketHandler.sendPacketToNearPlayers((World)worldIn, (CreativeCorePacket)new LittleNeighborUpdatePacket(pos, fromPos), (int)100, (BlockPos)pos);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (loadingTileEntityFromWorld) {
            return;
        }
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null && te.func_145831_w().field_72995_K) {
            te.onNeighBorChangedClient();
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult moving;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null && (moving = te.rayTrace(start, end)) != null) {
            return new RayTraceResult(moving.field_72307_f, moving.field_178784_b, pos);
        }
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null && te.shouldCheckForCollision()) {
            for (LittleTile tile : te.getTiles()) {
                if (!tile.shouldCheckForCollision() || !tile.box.getBox().func_186670_a(pos).func_72326_a(entityIn.func_174813_aQ())) continue;
                tile.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLittleTiles();
    }

    @SideOnly(value=Side.CLIENT)
    private static TileEntityLittleTiles checkforTileEntity(World world, EnumFacing facing, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean checkforNeighbor(World world, EnumFacing facing, BlockPos pos) {
        BlockPos newPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(newPos);
        return !state.doesSideBlockRendering((IBlockAccess)world, newPos, facing.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    private static void updateRenderer(TileEntityLittleTiles tileEntity, EnumFacing facing, HashMap<EnumFacing, Boolean> neighbors, HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles, RenderCubeObject cube, LittleTileBox.LittleTileFace face) {
        if (face == null) {
            cube.setSideRender(facing, RenderCubeObject.EnumSideRender.INSIDE_RENDERED);
            return;
        }
        Boolean shouldRender = neighbors.get(facing);
        if (shouldRender == null) {
            shouldRender = BlockTile.checkforNeighbor(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
            neighbors.put(facing, shouldRender);
        }
        if (shouldRender == Boolean.TRUE) {
            TileEntityLittleTiles otherTile = null;
            if (!neighborsTiles.containsKey(facing)) {
                otherTile = BlockTile.checkforTileEntity(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
                neighborsTiles.put(facing, otherTile);
            } else {
                otherTile = neighborsTiles.get(facing);
            }
            if (otherTile != null) {
                face.move(facing);
                shouldRender = otherTile.shouldSideBeRendered(facing.func_176734_d(), face, (LittleTile)cube.customData);
            }
        }
        cube.setSideRender(facing, shouldRender != false ? RenderCubeObject.EnumSideRender.OUTSIDE_RENDERED : RenderCubeObject.EnumSideRender.OUTSIDE_NOT_RENDERD);
    }

    @SideOnly(value=Side.CLIENT)
    public List<? extends RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityLittleTiles) {
            return Collections.emptyList();
        }
        return BlockTile.getRenderingCubes(state, te, stack, MinecraftForgeClient.getRenderLayer());
    }

    @SideOnly(value=Side.CLIENT)
    public static List<LittleRenderingCube> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack, BlockRenderLayer layer) {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        if (te instanceof TileEntityLittleTiles) {
            HashMap<EnumFacing, Boolean> neighbors = new HashMap<EnumFacing, Boolean>();
            HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles = new HashMap<EnumFacing, TileEntityLittleTiles>();
            TileEntityLittleTiles tileEntity = (TileEntityLittleTiles)te;
            RenderCubeLayerCache cache = tileEntity.getCubeCache();
            List<LittleRenderingCube> cachedCubes = cache.getCubesByLayer(layer);
            if (cachedCubes != null) {
                if (tileEntity.hasNeighborChanged) {
                    for (BlockRenderLayer tempLayer : BlockRenderLayer.values()) {
                        List<LittleRenderingCube> renderCubes = cache.getCubesByLayer(tempLayer);
                        if (renderCubes == null) continue;
                        for (int i = 0; i < renderCubes.size(); ++i) {
                            LittleRenderingCube cube = renderCubes.get(i);
                            for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                                EnumFacing facing = EnumFacing.field_82609_l[k];
                                if (!cube.getSidedRendererType((EnumFacing)facing).outside) continue;
                                LittleTileBox.LittleTileFace face = cube.box.getFace(facing);
                                boolean shouldRenderBefore = cube.shouldSideBeRendered(facing);
                                BlockTile.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, face);
                                if (cube.shouldSideBeRendered(facing)) {
                                    if (shouldRenderBefore) continue;
                                    cube.doesNeedQuadUpdate = true;
                                    continue;
                                }
                                cube.setQuad(facing, null);
                            }
                        }
                    }
                    tileEntity.hasNeighborChanged = false;
                }
                return cachedCubes;
            }
            for (LittleTile tile : tileEntity.getTiles()) {
                if (!tile.shouldBeRenderedInLayer(layer)) continue;
                List<LittleRenderingCube> tileCubes = tile.getRenderingCubes();
                for (int j = 0; j < tileCubes.size(); ++j) {
                    LittleRenderingCube cube = tileCubes.get(j);
                    for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                        EnumFacing facing = EnumFacing.field_82609_l[k];
                        LittleTileBox.LittleTileFace face = cube.box.getFace(facing);
                        cube.customData = tile;
                        if (face == null) {
                            cube.setSideRender(facing, RenderCubeObject.EnumSideRender.INSIDE_RENDERED);
                            continue;
                        }
                        if (face.isFaceInsideBlock()) {
                            cube.setSideRender(facing, ((TileEntityLittleTiles)te).shouldSideBeRendered(facing, face, tile) ? RenderCubeObject.EnumSideRender.INSIDE_RENDERED : RenderCubeObject.EnumSideRender.INSIDE_NOT_RENDERED);
                            continue;
                        }
                        BlockTile.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, face);
                    }
                }
                cubes.addAll(tileCubes);
            }
            cache.setCubesByLayer(cubes, layer);
        } else if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return cubes;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null && !world.field_72995_K) {
            float size = ((Float)ReflectionHelper.getPrivateValue(Explosion.class, (Object)explosion, (String[])new String[]{"explosionSize", "field_77280_f"})).floatValue();
            Vec3d center = explosion.getPosition();
            ArrayList<LittleTile> removeTiles = new ArrayList<LittleTile>();
            for (LittleTile tile : te.getTiles()) {
                if (tile.isStructureBlock) continue;
                LittleTileVec vec = tile.getCenter();
                Vec3d newVec = new Vec3d((Vec3i)pos);
                newVec = newVec.func_72441_c(vec.getPosX(), vec.getPosY(), vec.getPosZ());
                int explosionStrength = (int)(50.0 / center.func_72438_d(newVec) * (double)size);
                double random = Math.random() * (double)explosionStrength;
                if (!(random > (double)tile.getExplosionResistance())) continue;
                removeTiles.add(tile);
            }
            for (int i = 0; i < removeTiles.size(); ++i) {
                ((LittleTile)removeTiles.get(i)).onTileExplodes(explosion);
                ((LittleTile)removeTiles.get(i)).destroy();
            }
            te.func_73660_a();
        }
    }

    @Nullable
    public Boolean isEntityInsideMaterial(IBlockAccess world, BlockPos blockpos, IBlockState iblockstate, Entity entity, double yToTest, Material materialIn, boolean testingHead) {
        return this.isAABBInsideMaterial(entity.field_70170_p, blockpos, entity.func_174813_aQ(), materialIn);
    }

    @Nullable
    public Boolean isAABBInsideMaterial(World world, BlockPos pos, AxisAlignedBB boundingBox, Material materialIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                if (!tile.isMaterial(materialIn) || !tile.box.getBox(pos).func_72326_a(boundingBox)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        cancelNext = false;
        loadingTileEntityFromWorld = false;
    }

    public static class TEResult {
        public final TileEntityLittleTiles te;
        public final LittleTile tile;

        public TEResult(TileEntityLittleTiles te, LittleTile tile) {
            this.te = te;
            this.tile = tile;
        }

        public boolean isComplete() {
            return this.te != null && this.tile != null;
        }
    }
}

