/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.container;

import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class SubContainerScrewdriver
extends SubContainer {
    public SubContainerScrewdriver(EntityPlayer player) {
        super(player);
    }

    public void createControls() {
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        int firstX = nbt.func_74762_e("x1");
        int firstY = nbt.func_74762_e("y1");
        int firstZ = nbt.func_74762_e("z1");
        int secX = nbt.func_74762_e("x2");
        int secY = nbt.func_74762_e("y2");
        int secZ = nbt.func_74762_e("z2");
        int minX = Math.min(firstX, secX);
        int maxX = Math.max(firstX, secX);
        int minY = Math.min(firstY, secY);
        int maxY = Math.max(firstY, secY);
        int minZ = Math.min(firstZ, secZ);
        int maxZ = Math.max(firstZ, secZ);
        boolean remove = nbt.func_74767_n("remove");
        boolean colorize = nbt.func_74764_b("color");
        int color = nbt.func_74762_e("color");
        Block filter = null;
        int meta = -1;
        if (nbt.func_74764_b("filterBlock")) {
            filter = Block.func_149684_b((String)nbt.func_74779_i("filterBlock"));
            if (nbt.func_74764_b("filterMeta")) {
                meta = nbt.func_74762_e("filterMeta");
            }
        }
        Block replacement = null;
        int metaReplacement = -1;
        if (nbt.func_74764_b("replaceBlock")) {
            replacement = Block.func_149684_b((String)nbt.func_74779_i("replaceBlock"));
            if (nbt.func_74764_b("replaceMeta")) {
                metaReplacement = nbt.func_74762_e("replaceMeta");
            }
        }
        int effected = 0;
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    BlockPos pos = new BlockPos(posX, posY, posZ);
                    TileEntity tileEntity = this.player.field_70170_p.func_175625_s(pos);
                    boolean hasChanged = false;
                    if (!(tileEntity instanceof TileEntityLittleTiles)) continue;
                    TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                    ((TileEntityLittleTiles)tileEntity).preventUpdate = true;
                    for (LittleTile tile : te.getTiles()) {
                        boolean shouldEffect;
                        boolean bl = shouldEffect = tile.getClass() == LittleTileBlock.class || tile instanceof LittleTileBlockColored;
                        if (filter != null) {
                            if (((LittleTileBlock)tile).getBlock() != filter) {
                                shouldEffect = false;
                            }
                            if (meta != -1 && ((LittleTileBlock)tile).getMeta() != meta) {
                                shouldEffect = false;
                            }
                        }
                        if (!shouldEffect) continue;
                        hasChanged = true;
                        if (remove) {
                            tile.destroy();
                        } else {
                            LittleTileBlock newTile;
                            if (replacement != null) {
                                ((LittleTileBlock)tile).setBlock(replacement);
                                if (metaReplacement != -1) {
                                    ((LittleTileBlock)tile).setMeta(metaReplacement);
                                }
                                ((LittleTileBlock)tile).updateBlockState();
                            }
                            if (colorize && (newTile = LittleTileBlockColored.setColor((LittleTileBlock)tile, color)) != null) {
                                if (tile.isStructureBlock && tile.isLoaded()) {
                                    tile.structure.removeTile(tile);
                                    newTile.coord = tile.coord;
                                    newTile.structure.addTile(newTile);
                                    if (tile.isMainBlock) {
                                        newTile.isMainBlock = true;
                                        newTile.structure.setMainTile(newTile);
                                    }
                                }
                                te.getTiles().set(te.getTiles().indexOf(tile), newTile);
                            }
                        }
                        ++effected;
                    }
                    ((TileEntityLittleTiles)tileEntity).preventUpdate = false;
                    if (!hasChanged) continue;
                    te.updateTiles();
                }
            }
        }
        this.player.func_145747_a((ITextComponent)new TextComponentTranslation("Done! Effected " + effected + " tiles!", new Object[0]));
    }
}

