/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.BoxUtils;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.world.WorldFake;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.client.render.entity.TERenderData;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAnimation<T extends EntityAnimation>
extends Entity {
    protected LittleTileVec center;
    protected LittleTileVec inBlockCenter;
    protected BlockPos baseOffset;
    protected BlockPos chunkOffset;
    protected BlockPos inChunkOffset;
    public BlockPos startOffset;
    public LittleDoorBase structure;
    public ArrayList<PlacePreviewTile> previews;
    public ArrayList<TileEntityLittleTiles> blocks;
    public double prevWorldRotX = 0.0;
    public double prevWorldRotY = 0.0;
    public double prevWorldRotZ = 0.0;
    public double worldRotX = 0.0;
    public double worldRotY = 0.0;
    public double worldRotZ = 0.0;
    public ArrayList<AxisAlignedBB> collisionBoxes;
    public ArrayList<AxisAlignedBB> worldCollisionBoxes;
    public AxisAlignedBB worldBoundingBox;
    @SideOnly(value=Side.CLIENT)
    public HashMap<BlockPos, LittleRenderChunk> chunk;
    @SideOnly(value=Side.CLIENT)
    public HashMapList<BlockRenderLayer, TERenderData> renderData;
    @SideOnly(value=Side.CLIENT)
    public ArrayList<TileEntityLittleTiles> renderQueue;
    @SideOnly(value=Side.CLIENT)
    protected ArrayList<TileEntityLittleTiles> waitingForRender;
    @SideOnly(value=Side.CLIENT)
    protected int ticksToWait;

    public static int intFloorDiv(int p_76137_0_, int p_76137_1_) {
        return p_76137_0_ < 0 ? -((-p_76137_0_ - 1) / p_76137_1_) - 1 : p_76137_0_ / p_76137_1_;
    }

    public void setCenterVec(LittleTileVec axis) {
        this.center = axis;
        this.baseOffset = axis.getBlockPos();
        this.inBlockCenter = axis.copy();
        this.inBlockCenter.sub(new LittleTileVec((Vec3i)this.baseOffset));
        this.chunkOffset = EntityAnimation.getRenderChunkPos(this.baseOffset);
        int chunkX = EntityAnimation.intFloorDiv(this.baseOffset.func_177958_n(), 16);
        int chunkY = EntityAnimation.intFloorDiv(this.baseOffset.func_177956_o(), 16);
        int chunkZ = EntityAnimation.intFloorDiv(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
    }

    public static BlockPos getRenderChunkPos(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n() >> 4, blockPos.func_177956_o() >> 4, blockPos.func_177952_p() >> 4);
    }

    public LittleTileVec getCenter() {
        return this.center;
    }

    public LittleTileVec getInsideBlockCenter() {
        return this.inBlockCenter;
    }

    public BlockPos getAxisPos() {
        return this.baseOffset;
    }

    public BlockPos getAxisChunkPos() {
        return this.chunkOffset;
    }

    public BlockPos getInsideChunkPos() {
        return this.inChunkOffset;
    }

    public Vec3d getRotVector(float partialTicks) {
        return new Vec3d(this.prevWorldRotX + (this.worldRotX - this.prevWorldRotX) * (double)partialTicks, this.prevWorldRotY + (this.worldRotY - this.prevWorldRotY) * (double)partialTicks, this.prevWorldRotZ + (this.worldRotZ - this.prevWorldRotZ) * (double)partialTicks);
    }

    public void updateWorldCollision() {
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double minZ = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        double maxZ = -2.147483648E9;
        this.worldCollisionBoxes = new ArrayList();
        Iterator<TileEntityLittleTiles> iterator = this.blocks.iterator();
        while (iterator.hasNext()) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            TileEntityLittleTiles te = iterator.next();
            this.onScanningTE(te);
            AxisAlignedBB bb = te.getSelectionBox();
            minX = Math.min(minX, bb.field_72340_a);
            minY = Math.min(minY, bb.field_72338_b);
            minZ = Math.min(minZ, bb.field_72339_c);
            maxX = Math.max(maxX, bb.field_72336_d);
            maxY = Math.max(maxY, bb.field_72337_e);
            maxZ = Math.max(maxZ, bb.field_72334_f);
            for (LittleTile tile : te.getTiles()) {
                List<LittleTileBox> tileBoxes = tile.getCollisionBoxes();
                for (LittleTileBox box : tileBoxes) {
                    boxes.add(box.getBox(te.func_174877_v()));
                }
            }
            BoxUtils.compressBoxes(boxes, (double)1.0);
            this.worldCollisionBoxes.addAll(boxes);
        }
        BoxUtils.compressBoxes(this.worldCollisionBoxes, (double)0.0);
        this.worldBoundingBox = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isWaitingForRender() {
        return this.waitingForRender != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void removeWaitingTe(TileEntityLittleTiles te) {
        this.waitingForRender.remove(te);
        this.renderData.removeValue((Object)new TERenderData(null, null, te.func_174877_v()));
    }

    public EntityAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityAnimation(World world, BlockPos pos, ArrayList<TileEntityLittleTiles> blocks, ArrayList<PlacePreviewTile> previews, UUID uuid, LittleTileVec center) {
        this(world);
        this.blocks = blocks;
        this.previews = previews;
        this.field_96093_i = uuid;
        this.field_189513_ar = this.field_96093_i.toString();
        this.setCenterVec(center);
        this.startOffset = pos.func_177973_b((Vec3i)this.baseOffset);
        if (world.field_72995_K) {
            this.createClient();
        }
        this.updateWorldCollision();
        this.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void createClient() {
        if (this.blocks != null) {
            this.renderData = new HashMapList();
            this.renderQueue = new ArrayList<TileEntityLittleTiles>(this.blocks);
        }
    }

    public void onScanningTE(TileEntityLittleTiles te) {
        te.setLoaded();
        if (te.isClientSide()) {
            te.rendering = new AtomicBoolean(false);
            RenderingThread.addCoordToUpdate(te, 0.0, false);
        }
    }

    protected void handleForces() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void updateBoundingBox() {
        boolean moved;
        if (this.worldBoundingBox == null) {
            return;
        }
        boolean rotated = this.prevWorldRotX != this.worldRotX || this.prevWorldRotY != this.worldRotY || this.field_70166_s != this.worldRotZ;
        boolean bl = moved = this.field_70169_q != this.field_70165_t || this.field_70167_r != this.field_70163_u || this.field_70166_s != this.field_70161_v;
        if (rotated || moved) {
            Matrix3d rotationX = new Matrix3d();
            rotationX.rotX(Math.toRadians(this.worldRotX));
            Matrix3d rotationY = new Matrix3d();
            rotationY.rotY(Math.toRadians(this.worldRotY));
            Matrix3d rotationZ = new Matrix3d();
            rotationZ.rotZ(Math.toRadians(this.worldRotZ));
            ArrayList<Vector3d> boxPoints = new ArrayList<Vector3d>();
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72340_a, this.worldBoundingBox.field_72338_b, this.worldBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72336_d, this.worldBoundingBox.field_72338_b, this.worldBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72340_a, this.worldBoundingBox.field_72337_e, this.worldBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72340_a, this.worldBoundingBox.field_72338_b, this.worldBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72336_d, this.worldBoundingBox.field_72337_e, this.worldBoundingBox.field_72339_c));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72336_d, this.worldBoundingBox.field_72338_b, this.worldBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72340_a, this.worldBoundingBox.field_72337_e, this.worldBoundingBox.field_72334_f));
            boxPoints.add(new Vector3d(this.worldBoundingBox.field_72336_d, this.worldBoundingBox.field_72337_e, this.worldBoundingBox.field_72334_f));
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            Vector3d origin = new Vector3d(this.center.getPosX() + LittleTile.gridMCLength / 2.0, this.center.getPosY() + LittleTile.gridMCLength / 2.0, this.center.getPosZ() + LittleTile.gridMCLength / 2.0);
            for (int i = 0; i < boxPoints.size(); ++i) {
                Vector3d vec = (Vector3d)boxPoints.get(i);
                vec.sub((Tuple3d)origin);
                rotationX.transform((Tuple3d)vec);
                rotationY.transform((Tuple3d)vec);
                rotationZ.transform((Tuple3d)vec);
                vec.add((Tuple3d)origin);
                minX = Math.min(minX, vec.x);
                minY = Math.min(minY, vec.y);
                minZ = Math.min(minZ, vec.z);
                maxX = Math.max(maxX, vec.x);
                maxY = Math.max(maxY, vec.y);
                maxZ = Math.max(maxZ, vec.z);
            }
            BlockPos realStart = this.baseOffset.func_177971_a((Vec3i)this.startOffset);
            double offsetX = this.field_70165_t - (double)realStart.func_177958_n();
            double offsetY = this.field_70163_u - (double)realStart.func_177956_o();
            double offsetZ = this.field_70161_v - (double)realStart.func_177952_p();
            this.func_174826_a(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ).func_72317_d(offsetX, offsetY, offsetZ));
        }
    }

    public void onTick() {
    }

    public void onPostTick() {
    }

    public void func_70071_h_() {
        if (this.blocks == null && !this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
        if (this.blocks == null) {
            return;
        }
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.handleForces();
        super.func_70071_h_();
        this.onTick();
        this.onPostTick();
        this.updateBoundingBox();
        for (int i = 0; i < this.blocks.size(); ++i) {
            if (i == 0) {
                WorldFake fakeWorld = (WorldFake)this.blocks.get(i).func_145831_w();
                fakeWorld.offsetX = this.field_70165_t - (double)(this.getAxisPos().func_177958_n() - this.startOffset.func_177958_n());
                fakeWorld.offsetY = this.field_70163_u - (double)(this.getAxisPos().func_177956_o() - this.startOffset.func_177956_o());
                fakeWorld.offsetZ = this.field_70161_v - (double)(this.getAxisPos().func_177952_p() - this.startOffset.func_177952_p());
                if (fakeWorld.axis == null) {
                    Vec3d vec = this.getCenter().getVec();
                    fakeWorld.axis = new Vector3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
                fakeWorld.rotX = this.worldRotX;
                fakeWorld.rotY = this.worldRotY;
                fakeWorld.rotZ = this.worldRotZ;
            }
            if (!this.blocks.get(i).shouldTick()) continue;
            this.blocks.get(i).func_73660_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateBoundingBox();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return EnumActionResult.SUCCESS;
    }

    protected abstract void copyExtra(T var1);

    public T copy() {
        EntityAnimation animation = null;
        try {
            animation = (EntityAnimation)((Object)((Object)((Object)this)).getClass().getConstructor(World.class).newInstance(this.field_70170_p));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        animation.func_184221_a(this.func_110124_au());
        animation.setCenterVec(this.center.copy());
        animation.structure = this.structure;
        animation.previews = new ArrayList<PlacePreviewTile>(this.previews);
        animation.blocks = new ArrayList<TileEntityLittleTiles>(this.blocks);
        animation.worldBoundingBox = this.worldBoundingBox;
        animation.worldCollisionBoxes = new ArrayList<AxisAlignedBB>(this.worldCollisionBoxes);
        if (this.collisionBoxes != null) {
            animation.collisionBoxes = new ArrayList<AxisAlignedBB>(this.collisionBoxes);
        }
        if (this.field_70170_p.field_72995_K) {
            animation.renderData = this.renderData;
            animation.renderQueue = this.renderQueue;
        }
        animation.prevWorldRotX = this.prevWorldRotX;
        animation.prevWorldRotY = this.prevWorldRotY;
        animation.prevWorldRotZ = this.prevWorldRotZ;
        animation.worldRotX = this.worldRotX;
        animation.worldRotY = this.worldRotY;
        animation.worldRotZ = this.worldRotZ;
        animation.startOffset = this.startOffset;
        this.copyExtra(animation);
        return (T)((Object)animation);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.startOffset = new BlockPos(compound.func_74762_e("strOffX"), compound.func_74762_e("strOffY"), compound.func_74762_e("strOffZ"));
        this.setCenterVec(new LittleTileVec("axis", compound));
        WorldFake worldFake = WorldFake.createFakeWorld((World)this.field_70170_p);
        NBTTagList list = compound.func_150295_c("tileEntity", (int)compound.func_74732_a());
        this.blocks = new ArrayList();
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        this.structure = null;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            TileEntityLittleTiles te = (TileEntityLittleTiles)TileEntity.func_190200_a((World)worldFake, (NBTTagCompound)nbt);
            te.func_145834_a((World)worldFake);
            this.blocks.add(te);
            for (LittleTile tile : te.getTiles()) {
                if (tile.isMainBlock) {
                    this.structure = (LittleDoorBase)tile.structure;
                }
                tiles.add(tile);
            }
            worldFake.func_175656_a(te.func_174877_v(), LittleTiles.blockTile.func_176223_P());
            worldFake.func_175690_a(te.func_174877_v(), (TileEntity)te);
        }
        ArrayList<PlacePreviewTile> defaultpreviews = new ArrayList<PlacePreviewTile>();
        LittleTileVec axisPoint = this.structure.getAbsoluteAxisVec();
        LittleTileVec invaxis = axisPoint.copy();
        invaxis.invert();
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTile tileOfList = (LittleTile)tiles.get(i);
            NBTTagCompound nbt = new NBTTagCompound();
            LittleTilePreview preview = tileOfList.getPreviewTile();
            preview.box.addOffset((Vec3i)tileOfList.te.func_174877_v());
            preview.box.addOffset(invaxis);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, new LittleTileVec(0, 0, 0)));
        }
        defaultpreviews.addAll(this.structure.getAdditionalPreviews());
        LittleTileVec internalOffset = new LittleTileVec(axisPoint.x - this.baseOffset.func_177958_n() * LittleTile.gridSize, axisPoint.y - this.baseOffset.func_177956_o() * LittleTile.gridSize, axisPoint.z - this.baseOffset.func_177952_p() * LittleTile.gridSize);
        this.previews = new ArrayList();
        for (int i = 0; i < defaultpreviews.size(); ++i) {
            PlacePreviewTile box = (PlacePreviewTile)defaultpreviews.get(i);
            box.box.addOffset(internalOffset);
            this.previews.add(box);
        }
        this.updateWorldCollision();
        this.updateBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("strOffX", this.startOffset.func_177958_n());
        compound.func_74768_a("strOffY", this.startOffset.func_177956_o());
        compound.func_74768_a("strOffZ", this.startOffset.func_177952_p());
        this.center.writeToNBT("axis", compound);
        NBTTagList list = new NBTTagList();
        for (TileEntityLittleTiles te : this.blocks) {
            list.func_74742_a((NBTBase)te.func_189515_b(new NBTTagCompound()));
        }
        compound.func_74782_a("tileEntity", (NBTBase)list);
    }
}

