/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceRelative;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDoorAnimation
extends EntityAnimation<EntityDoorAnimation> {
    private static final DataParameter<Integer> ENTITY_PROGRESS = EntityDataManager.func_187226_a(EntityDoorAnimation.class, (DataSerializer)DataSerializers.field_187192_b);
    public EntityPlayer activator;
    private int progress;
    public int duration;
    public boolean approved = true;
    public DoorTransformation transformation;
    public LittleTileVec additionalAxis;
    private int lastSendProgress = -1;

    public void setTransformationStartOffset() {
        this.transformation.performTransformation(this, 0.0);
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public EntityDoorAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityDoorAnimation(World world, BlockPos pos, LittleDoorBase structure, ArrayList<TileEntityLittleTiles> blocks, ArrayList<PlacePreviewTile> previews, LittleTileVec axis, DoorTransformation transformation, UUID uuid, EntityPlayer activator, LittleTileVec additionalAxis) {
        super(world, pos, blocks, previews, uuid, axis);
        this.activator = activator;
        this.structure = structure;
        this.transformation = transformation;
        this.duration = structure.duration;
        this.additionalAxis = additionalAxis.copy();
        this.setTransformationStartOffset();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onScanningTE(TileEntityLittleTiles te) {
        if (this.field_70170_p.field_72995_K) {
            te.rendering = new AtomicBoolean(false);
            te.setLoaded();
            RenderingThread.addCoordToUpdate(te, 0.0, false);
        }
        super.onScanningTE(te);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createClient() {
        super.createClient();
        this.approved = false;
    }

    @Override
    public void copyExtra(EntityDoorAnimation animation) {
        animation.progress = this.progress;
        animation.duration = this.duration;
        animation.approved = this.approved;
        animation.transformation = this.transformation;
        animation.lastSendProgress = this.lastSendProgress;
        animation.additionalAxis = this.additionalAxis.copy();
    }

    public void setProgress(int progress) {
        this.progress = progress;
        if (!(this.field_70170_p.field_72995_K || this.lastSendProgress != -1 && progress - this.lastSendProgress <= 10 && progress != this.duration)) {
            this.field_70180_af.func_187227_b(ENTITY_PROGRESS, (Object)progress);
            this.lastSendProgress = progress;
        }
    }

    public int getProgress() {
        return this.progress;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ENTITY_PROGRESS, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (this.field_70170_p.field_72995_K && ENTITY_PROGRESS.equals(key) && !this.isWaitingForRender()) {
            this.progress = (Integer)this.field_70180_af.func_187225_a(ENTITY_PROGRESS);
        }
    }

    @Override
    public void onTick() {
        if (this.transformation != null) {
            this.transformation.performTransformation(this, (double)this.progress / (double)this.duration);
        }
    }

    @Override
    public void onPostTick() {
        if (this.transformation == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K && this.isWaitingForRender()) {
            --this.ticksToWait;
            this.field_70128_L = this.waitingForRender.size() == 0 || this.ticksToWait < 0;
        } else if (this.progress >= this.duration) {
            LittleDoorBase structure = this.structure.copyToPlaceDoor();
            if (this.field_70170_p.field_72995_K) {
                structure.isWaitingForApprove = true;
            }
            if (!this.field_70170_p.field_72995_K || this.approved) {
                if (LittleActionPlaceRelative.placeTiles(this.field_70170_p, null, this.previews, structure, false, this.baseOffset, null, null, false, EnumFacing.EAST) != null) {
                    if (this.field_70170_p.field_72995_K) {
                        this.waitingForRender = new ArrayList();
                        ArrayList coordsToCheck = new ArrayList(LittleActionPlaceRelative.getSplittedTiles(this.previews, this.baseOffset).getKeys());
                        for (int i = 0; i < coordsToCheck.size(); ++i) {
                            TileEntity te = this.field_70170_p.func_175625_s((BlockPos)coordsToCheck.get(i));
                            if (!(te instanceof TileEntityLittleTiles)) continue;
                            ((TileEntityLittleTiles)te).waitingAnimation = this;
                            this.waitingForRender.add((TileEntityLittleTiles)te);
                        }
                        this.ticksToWait = this.waitingForRender.size() * 10;
                        this.field_70128_L = false;
                        return;
                    }
                } else if (!this.field_70170_p.field_72995_K) {
                    WorldUtils.dropItem((World)this.field_70170_p, (ItemStack)this.structure.getStructureDrop(), (BlockPos)this.baseOffset);
                }
            }
            this.field_70128_L = true;
        } else {
            this.setProgress(this.progress + 1);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.duration = compound.func_74762_e("duration");
        this.setProgress(compound.func_74762_e("progress"));
        this.transformation = DoorTransformation.loadFromNBT(compound.func_74775_l("transform"));
        this.additionalAxis = new LittleTileVec("additional", compound);
        this.setTransformationStartOffset();
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("duration", this.duration);
        compound.func_74768_a("progress", this.progress);
        compound.func_74782_a("transform", (NBTBase)this.transformation.writeToNBT(new NBTTagCompound()));
        this.additionalAxis.writeToNBT("additional", compound);
    }
}

