/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.utils.geo.SelectShape;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.util.Color;

public class SubGuiColorTube
extends SubGui {
    public ItemStack stack;

    public SubGuiColorTube(ItemStack stack) {
        super(140, 173);
        this.stack = stack;
    }

    public void createControls() {
        Color color = ColorUtils.IntToRGBA((int)ItemColorTube.getColor(this.stack));
        color.setAlpha(255);
        this.controls.add(new GuiColorPicker("picker", 2, 2, color));
        ArrayList<String> shapes = new ArrayList<String>(SelectShape.shapes.keySet());
        shapes.add(0, "tile");
        GuiComboBox box = new GuiComboBox("shape", 0, 40, 134, shapes);
        SelectShape shape = ItemColorTube.getShape(this.stack);
        box.select(shape == null ? "tile" : shape.key);
        GuiScrollBox scroll = new GuiScrollBox("settings", 0, 63, 134, 90);
        this.controls.add(box);
        this.controls.add(scroll);
        this.onChange();
    }

    public void onClosed() {
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        SelectShape shape = box.caption.equals("tile") || box.caption.equals("") ? null : SelectShape.getShape(box.caption);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("shape", shape == null ? "tile" : shape.key);
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        nbt.func_74768_a("color", ColorUtils.RGBAToInt((Color)picker.color));
        if (shape != null) {
            shape.saveCustomSettings((GuiParent)scroll, nbt);
        }
        this.sendPacketToServer(nbt);
        super.onClosed();
    }

    @CustomEventSubscribe
    public void onComboBoxChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"shape"})) {
            this.onChange();
        }
    }

    public void onChange() {
        SelectShape shape;
        GuiComboBox box = (GuiComboBox)this.get("shape");
        GuiScrollBox scroll = (GuiScrollBox)this.get("settings");
        scroll.controls.clear();
        SelectShape selectShape = shape = box.caption.equals("tile") || box.caption.equals("") ? null : SelectShape.getShape(box.caption);
        if (shape != null) {
            scroll.controls.addAll(shape.getCustomSettings(this.stack.func_77978_p()));
            scroll.refreshControls();
        }
    }
}

