/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.custom.GuiItemListBox;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.container.SubContainerWrench;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiWrench
extends SubGui {
    public void createControls() {
        this.controls.add(new GuiButton("Craft", 55, 3, 40){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClicked(int x, int y, int button) {
                ItemStack stack1 = ((SubContainerWrench)SubGuiWrench.this.container).basic.func_70301_a(0);
                ItemStack stack2 = ((SubContainerWrench)SubGuiWrench.this.container).basic.func_70301_a(1);
                GuiItemListBox listBox = (GuiItemListBox)SubGuiWrench.this.get("missing");
                GuiLabel label = (GuiLabel)SubGuiWrench.this.get("label");
                label.caption = "";
                listBox.clear();
                if (stack1.func_190926_b()) return;
                if (stack1.func_77973_b() instanceof ItemRecipe) {
                    List<LittleTilePreview> previews = LittleTilePreview.getPreview(stack1);
                    EntityPlayer player = this.getPlayer();
                    ColorUnit color = new ColorUnit();
                    BlockIngredient.BlockIngredients ingredients = new BlockIngredient.BlockIngredients();
                    for (LittleTilePreview preview : previews) {
                        if (!preview.canBeConvertedToBlockEntry()) continue;
                        ingredients.addIngredient(preview.getBlockIngredient());
                        color.addColorUnit(ColorUnit.getRequiredColors(preview));
                    }
                    try {
                        if (!LittleAction.drainIngredients(player, ingredients, color)) return;
                        SubGuiWrench.this.sendPacketToServer(new NBTTagCompound());
                        return;
                    }
                    catch (NotEnoughIngredientsException e) {
                        if (e instanceof NotEnoughIngredientsException.NotEnoughVolumeExcepion) {
                            for (BlockIngredient ingredient : ingredients.getIngredients()) {
                                listBox.add(ingredient.value > 1.0 ? ingredient.value + " blocks" : (int)(ingredient.value * (double)LittleTile.maxTilesPerBlock) + " pixels", ingredient.getItemStack());
                            }
                            return;
                        }
                        label.caption = e.getLocalizedMessage();
                        return;
                    }
                } else {
                    SubGuiWrench.this.sendPacketToServer(new NBTTagCompound());
                }
            }
        });
        this.controls.add(new GuiItemListBox("missing", 5, 25, 160, 50, new ArrayList(), new ArrayList()));
        this.controls.add(new GuiLabel("label", "", 100, 5));
    }
}

