/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui.controls;

import com.creativemd.creativecore.gui.controls.container.SlotControl;
import com.creativemd.creativecore.gui.controls.container.client.GuiSlotControl;
import com.creativemd.littletiles.common.gui.controls.SlotControlBlockIngredient;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class GuiSlotControlBlockIngredient
extends GuiSlotControl {
    public GuiSlotControlBlockIngredient(int x, int y, SlotControl slot, BlockIngredient ingredient) {
        super(x, y, slot);
    }

    public ItemStack getStackToRender() {
        ItemStack stack = super.getStackToRender();
        if (stack.func_77973_b() instanceof ItemBlockTiles) {
            if (stack.func_190916_E() >= LittleTile.maxTilesPerBlock) {
                LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p());
                stack = new ItemStack(preview.getPreviewBlock(), stack.func_190916_E() / LittleTile.maxTilesPerBlock, preview.getPreviewBlockMeta());
            } else {
                stack = stack.func_77946_l();
                stack.func_190920_e(1);
                new LittleTileSize(LittleTile.gridSize / 4 * 3, LittleTile.gridSize / 4 * 3, LittleTile.gridSize / 4 * 3).writeToNBT("size", stack.func_77978_p());
            }
        }
        return stack;
    }

    public ArrayList<String> getTooltip() {
        ArrayList tooltip = super.getTooltip();
        BlockIngredient ingredient = ((SlotControlBlockIngredient)this.slot).ingredient;
        if (ingredient != null) {
            if (ingredient.value > 1.0) {
                tooltip.add("volume: " + ingredient.value + " blocks");
            } else {
                tooltip.add("volume: " + (int)(ingredient.value * (double)LittleTile.maxTilesPerBlock) + " pixels");
            }
        }
        return tooltip;
    }
}

