/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui.controls;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.gui.GuiRenderHelper;
import com.creativemd.creativecore.gui.client.style.Style;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class GuiTileViewer
extends GuiParent {
    public ItemStack stack;
    public float scale = 5.0f;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public EnumFacing viewDirection = EnumFacing.EAST;
    public boolean visibleAxis = false;
    public EnumFacing.Axis normalAxis = null;
    public EnumFacing.Axis axisDirection = EnumFacing.Axis.Y;
    public int axisX = 1;
    public int axisY = 1;
    public int axisZ = 1;
    private boolean even;
    public boolean grabbed = false;
    public List<BakedQuad> baked = null;
    public Vec3d lastPosition;

    public void setEven(boolean even) {
        this.even = even;
        if (even) {
            this.axisX = this.axisX % 2 == 0 ? this.axisX : this.axisX - 1;
            this.axisY = this.axisY % 2 == 0 ? this.axisY : this.axisY - 1;
            this.axisZ = this.axisZ % 2 == 0 ? this.axisZ : this.axisZ - 1;
        } else {
            this.axisX = this.axisX % 2 == 0 ? this.axisX + 1 : this.axisX;
            this.axisY = this.axisY % 2 == 0 ? this.axisY + 1 : this.axisY;
            this.axisZ = this.axisZ % 2 == 0 ? this.axisZ + 1 : this.axisZ;
        }
    }

    public GuiTileViewer(String name, int x, int y, int width, int height, ItemStack stack) {
        super(name, x, y, width, height);
        this.stack = stack;
        this.marginWidth = 0;
        this.updateNormalAxis();
    }

    public void updateNormalAxis() {
        List cubes = ((ICreativeRendered)this.stack.func_77973_b()).getRenderingCubes(null, null, this.stack);
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double minZ = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        double maxZ = -2.147483648E9;
        for (int i = 0; i < cubes.size(); ++i) {
            CubeObject cube = (CubeObject)cubes.get(i);
            minX = Math.min(minX, (double)cube.minX);
            minY = Math.min(minY, (double)cube.minY);
            minZ = Math.min(minZ, (double)cube.minZ);
            maxX = Math.max(maxX, (double)cube.maxX);
            maxY = Math.max(maxY, (double)cube.maxY);
            maxZ = Math.max(maxZ, (double)cube.maxZ);
        }
        double sizeX = maxX - minX;
        double sizeY = maxY - minZ;
        double sizeZ = maxZ - minZ;
        switch (this.axisDirection) {
            case X: {
                if (sizeY >= sizeZ) {
                    this.normalAxis = EnumFacing.Axis.Y;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.Z;
                break;
            }
            case Y: {
                if (sizeX >= sizeZ) {
                    this.normalAxis = EnumFacing.Axis.Z;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.X;
                break;
            }
            case Z: {
                if (sizeX >= sizeY) {
                    this.normalAxis = EnumFacing.Axis.X;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.Y;
                break;
            }
        }
    }

    public void changeNormalAxis() {
        switch (this.axisDirection) {
            case X: {
                if (this.normalAxis == EnumFacing.Axis.Z) {
                    this.normalAxis = EnumFacing.Axis.Y;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.Z;
                break;
            }
            case Y: {
                if (this.normalAxis == EnumFacing.Axis.Z) {
                    this.normalAxis = EnumFacing.Axis.X;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.Z;
                break;
            }
            case Z: {
                if (this.normalAxis == EnumFacing.Axis.Y) {
                    this.normalAxis = EnumFacing.Axis.X;
                    break;
                }
                this.normalAxis = EnumFacing.Axis.Y;
                break;
            }
        }
    }

    protected void renderContent(GuiRenderHelper helper, Style style, int width, int height) {
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)((float)(this.width / 2) + this.offsetX), (double)((float)(this.height / 2) + this.offsetY), (double)0.0);
        GL11.glScaled((double)4.0, (double)4.0, (double)4.0);
        GL11.glScaled((double)this.scale, (double)this.scale, (double)this.scale);
        GL11.glTranslated((double)(-this.offsetX * 2.0f), (double)(-this.offsetY * 2.0f), (double)0.0);
        GlStateManager.func_179094_E();
        if (this.viewDirection.func_176740_k() != EnumFacing.Axis.Y) {
            GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
        }
        EnumFacing facing = this.viewDirection;
        switch (this.viewDirection) {
            case EAST: {
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                facing = EnumFacing.SOUTH;
                break;
            }
            case WEST: {
                facing = EnumFacing.NORTH;
                break;
            }
            case UP: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case SOUTH: {
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                facing = EnumFacing.EAST;
                break;
            }
            case NORTH: {
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                facing = EnumFacing.WEST;
            }
        }
        if (this.baked == null) {
            CreativeBakedModel.setLastItemStack((ItemStack)this.stack);
            this.baked = new ArrayList<BakedQuad>(CreativeBakedModel.getBlockQuads(null, (EnumFacing)facing, (long)0L, (boolean)false));
            CreativeBakedModel.setLastItemStack(null);
        }
        ArrayList quads = new ArrayList();
        if (this.visibleAxis) {
            ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
            CubeObject cube = new CubeObject(LittleUtils.toVanillaGrid((float)this.axisX / 2.0f) - (float)LittleTile.gridMCLength / 2.0f, LittleUtils.toVanillaGrid((float)this.axisY / 2.0f) - (float)LittleTile.gridMCLength / 2.0f, LittleUtils.toVanillaGrid((float)this.axisZ / 2.0f) - (float)LittleTile.gridMCLength / 2.0f, LittleUtils.toVanillaGrid((float)this.axisX / 2.0f) + (float)LittleTile.gridMCLength / 2.0f, LittleUtils.toVanillaGrid((float)this.axisY / 2.0f) + (float)LittleTile.gridMCLength / 2.0f, LittleUtils.toVanillaGrid((float)this.axisZ / 2.0f) + (float)LittleTile.gridMCLength / 2.0f);
            RenderCubeObject normalCube = new RenderCubeObject(cube, Blocks.field_150325_L, 0);
            normalCube.keepVU = true;
            float min = -100.0f / this.scale;
            float max = -min;
            switch (this.normalAxis) {
                case X: {
                    normalCube.minX = min;
                    normalCube.maxX = max;
                    break;
                }
                case Y: {
                    normalCube.minY = min;
                    normalCube.maxY = max;
                    break;
                }
                case Z: {
                    normalCube.minZ = min;
                    normalCube.maxZ = max;
                    break;
                }
            }
            cubes.add(normalCube);
            RenderCubeObject axisCube = new RenderCubeObject(cube, Blocks.field_150325_L, 5);
            axisCube.keepVU = true;
            cubes.add(axisCube);
            CreativeBakedModel.getBlockQuads(cubes, quads, (ICreativeRendered)((ICreativeRendered)LittleTiles.multiTiles), (EnumFacing)facing, null, (BlockRenderLayer)BlockRenderLayer.SOLID, (Block)Blocks.field_150325_L, null, (long)0L, null, (boolean)false);
        }
        GuiRenderHelper.renderBakedQuads(this.baked);
        GlStateManager.func_179097_i();
        GuiRenderHelper.renderBakedQuads(quads);
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        String xAxis = this.getXFacing().func_176740_k().name();
        xAxis = this.getXFacing().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? xAxis + " ->" : "<- " + xAxis;
        String yAxis = this.getYFacing().func_176740_k().name();
        yAxis = this.getYFacing().func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? yAxis + " ->" : "<- " + yAxis;
        helper.drawStringWithShadow(xAxis, 0, 0, width, 14, ColorUtils.WHITE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)14.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        helper.drawStringWithShadow(yAxis, 0, 0, width, 14, ColorUtils.WHITE);
        GlStateManager.func_179121_F();
    }

    public EnumFacing getXFacing() {
        switch (this.viewDirection) {
            case EAST: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
            case UP: {
                return EnumFacing.EAST;
            }
            case DOWN: {
                return EnumFacing.EAST;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.EAST;
    }

    public EnumFacing getYFacing() {
        switch (this.viewDirection) {
            case EAST: {
                return EnumFacing.DOWN;
            }
            case WEST: {
                return EnumFacing.DOWN;
            }
            case UP: {
                return EnumFacing.SOUTH;
            }
            case DOWN: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.DOWN;
            }
            case NORTH: {
                return EnumFacing.DOWN;
            }
        }
        return EnumFacing.DOWN;
    }

    public EnumFacing getZFacing() {
        switch (this.viewDirection) {
            case EAST: {
                return EnumFacing.NORTH;
            }
            case WEST: {
                return EnumFacing.NORTH;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.DOWN;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case NORTH: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        if (scrolled > 0) {
            this.scale = (float)((double)this.scale * ((double)scrolled * 1.5));
        } else if (scrolled < 0) {
            this.scale = (float)((double)this.scale / ((double)scrolled * -1.5));
        }
        return true;
    }

    public boolean mousePressed(int posX, int posY, int button) {
        this.grabbed = true;
        this.lastPosition = new Vec3d((double)posX, (double)posY, 0.0);
        return true;
    }

    public void mouseMove(int posX, int posY, int button) {
        if (this.grabbed) {
            Vec3d currentPosition = new Vec3d((double)posX, (double)posY, 0.0);
            if (this.lastPosition != null) {
                Vec3d move = this.lastPosition.func_178788_d(currentPosition);
                double percent = 0.3;
                this.offsetX = (float)((double)this.offsetX + (double)(1.0f / this.scale) * move.field_72450_a * percent);
                this.offsetY = (float)((double)this.offsetY + (double)(1.0f / this.scale) * move.field_72448_b * percent);
            }
            this.lastPosition = currentPosition;
        }
    }

    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbed) {
            this.lastPosition = null;
            this.grabbed = false;
        }
    }

    public boolean onKeyPressed(char character, int key) {
        if (key == 78) {
            this.scale *= 2.0f;
            return true;
        }
        if (key == 74) {
            this.scale /= 2.0f;
            return true;
        }
        int ammount = 5;
        if (key == 200) {
            this.offsetY += (float)ammount;
            return true;
        }
        if (key == 208) {
            this.offsetY -= (float)ammount;
            return true;
        }
        if (key == 205) {
            this.offsetX -= (float)ammount;
            return true;
        }
        if (key == 203) {
            this.offsetX += (float)ammount;
            return true;
        }
        return false;
    }

    public void updateViewDirection() {
        switch (this.axisDirection) {
            case X: {
                this.viewDirection = EnumFacing.SOUTH;
                break;
            }
            case Y: {
                this.viewDirection = EnumFacing.UP;
                break;
            }
            case Z: {
                this.viewDirection = EnumFacing.EAST;
                break;
            }
        }
        this.updateNormalAxis();
        this.baked = null;
    }
}

