/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.ingredients;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.mojang.realmsclient.gui.ChatFormatting;
import net.minecraft.util.text.translation.I18n;

public class ColorUnit {
    public int BLACK;
    public int RED;
    public int GREEN;
    public int BLUE;
    public static int dyeToBlockPercentage = 1;

    public ColorUnit() {
        this.BLACK = 0;
        this.RED = 0;
        this.GREEN = 0;
        this.BLUE = 0;
    }

    public ColorUnit(int[] array) {
        if (array.length != 4) {
            throw new IllegalArgumentException("Invalid array " + array + "!");
        }
        this.BLACK = array[0];
        this.RED = array[1];
        this.GREEN = array[2];
        this.BLUE = array[3];
    }

    public ColorUnit(int black, int red, int green, int blue) {
        this.BLACK = black;
        this.RED = red;
        this.GREEN = green;
        this.BLUE = blue;
    }

    public int[] getArray() {
        return new int[]{this.BLACK, this.RED, this.GREEN, this.BLUE};
    }

    private static String getUnit(int number) {
        if (number == 1) {
            return I18n.func_74838_a((String)"color.unit.single");
        }
        return I18n.func_74838_a((String)"color.unit.multiple");
    }

    public String getDescription() {
        String description = "";
        if (this.BLACK > 0) {
            description = description + this.BLACK + " " + ChatFormatting.DARK_GRAY + I18n.func_74838_a((String)"color.unit.black") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.BLACK);
        }
        if (this.RED > 0) {
            description = description + this.RED + " " + ChatFormatting.DARK_RED + I18n.func_74838_a((String)"color.unit.red") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.RED);
        }
        if (this.GREEN > 0) {
            description = description + this.GREEN + " " + ChatFormatting.DARK_GREEN + I18n.func_74838_a((String)"color.unit.green") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.GREEN);
        }
        if (this.BLUE > 0) {
            description = description + this.BLUE + " " + ChatFormatting.DARK_BLUE + I18n.func_74838_a((String)"color.unit.blue") + ChatFormatting.WHITE + " " + ColorUnit.getUnit(this.BLUE);
        }
        return description;
    }

    public String toString() {
        return "[back=" + this.BLACK + ",red=" + this.RED + ",green=" + this.GREEN + ",blue=" + this.BLUE + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorUnit) {
            return this.BLACK == ((ColorUnit)obj).BLACK && this.RED == ((ColorUnit)obj).RED && this.GREEN == ((ColorUnit)obj).GREEN && this.BLUE == ((ColorUnit)obj).BLUE;
        }
        return false;
    }

    public int hashCode() {
        return this.BLACK + this.RED + this.GREEN + this.BLUE;
    }

    public void scale(double scale) {
        this.BLACK = (int)Math.ceil((double)this.BLACK * scale);
        this.RED = (int)Math.ceil((double)this.RED * scale);
        this.GREEN = (int)Math.ceil((double)this.GREEN * scale);
        this.BLUE = (int)Math.ceil((double)this.BLUE * scale);
    }

    public void subColorUnit(ColorUnit unit) {
        if (unit == null) {
            return;
        }
        this.BLACK -= unit.BLACK;
        this.RED -= unit.RED;
        this.GREEN -= unit.GREEN;
        this.BLUE -= unit.BLUE;
    }

    public void addColorUnit(ColorUnit unit) {
        if (unit == null) {
            return;
        }
        this.BLACK += unit.BLACK;
        this.RED += unit.RED;
        this.GREEN += unit.GREEN;
        this.BLUE += unit.BLUE;
    }

    public ColorUnit copy() {
        return new ColorUnit(this.BLACK, this.RED, this.GREEN, this.BLUE);
    }

    public static ColorUnit getColors(int color) {
        double percent = 25.5 * (double)dyeToBlockPercentage / 3.0;
        int maxPerColor = (int)(percent * 255.0);
        int r = (int)((double)(color >> 16 & 0xFF) * percent);
        int g = (int)((double)(color >> 8 & 0xFF) * percent);
        int b = (int)((double)(color & 0xFF) * percent);
        return new ColorUnit(maxPerColor - r + maxPerColor - g + maxPerColor - b, r, g, b);
    }

    public static ColorUnit getRequiredColors(LittleTilePreview preview, double volume) {
        if (preview.hasColor()) {
            ColorUnit color = ColorUnit.getRequiredColors(preview.getColor());
            color.BLACK = (int)Math.ceil((double)color.BLACK * volume);
            color.RED = (int)Math.ceil((double)color.RED * volume);
            color.GREEN = (int)Math.ceil((double)color.GREEN * volume);
            color.BLUE = (int)Math.ceil((double)color.BLUE * volume);
            return color;
        }
        return null;
    }

    public static ColorUnit getRequiredColors(LittleTilePreview preview) {
        if (preview.hasColor()) {
            ColorUnit color = ColorUnit.getRequiredColors(preview.getColor());
            color.BLACK = (int)((double)color.BLACK * preview.getPercentVolume());
            color.RED = (int)((double)color.RED * preview.getPercentVolume());
            color.GREEN = (int)((double)color.GREEN * preview.getPercentVolume());
            color.BLUE = (int)((double)color.BLUE * preview.getPercentVolume());
            return color;
        }
        return null;
    }

    public static ColorUnit getRequiredColors(int color) {
        if (ColorUtils.isWhite((int)color)) {
            return new ColorUnit();
        }
        double percent = 25.5 * (double)dyeToBlockPercentage / 3.0;
        int maxPerColor = (int)Math.ceil(percent * 255.0);
        int r = (int)((double)(color >> 16 & 0xFF) * percent);
        int g = (int)((double)(color >> 8 & 0xFF) * percent);
        int b = (int)((double)(color & 0xFF) * percent);
        int lowest = Math.min(r, Math.min(g, b));
        int remaining = maxPerColor - lowest;
        return new ColorUnit(maxPerColor - lowest + remaining - (r -= lowest) + remaining - (g -= lowest) + remaining - (b -= lowest), r, g, b);
    }

    public boolean isEmpty() {
        return this.BLACK == 0 && this.RED == 0 && this.GREEN == 0 && this.BLUE == 0;
    }

    public void drain(ColorUnit toDrain) {
        int drain = Math.min(this.BLACK, toDrain.BLACK);
        this.BLACK -= drain;
        toDrain.BLACK -= drain;
        drain = Math.min(this.RED, toDrain.RED);
        this.RED -= drain;
        toDrain.RED -= drain;
        drain = Math.min(this.GREEN, toDrain.GREEN);
        this.GREEN -= drain;
        toDrain.GREEN -= drain;
        drain = Math.min(this.BLUE, toDrain.BLUE);
        this.BLUE -= drain;
        toDrain.BLUE -= drain;
    }
}

