/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.ingredients;

import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import java.util.List;

public class CombinedIngredients {
    public final ColorUnit color;
    public final BlockIngredient.BlockIngredients block;

    public CombinedIngredients() {
        this(new ColorUnit(), new BlockIngredient.BlockIngredients());
    }

    public CombinedIngredients(ColorUnit color, BlockIngredient.BlockIngredients block) {
        this.color = color;
        this.block = block;
    }

    public void addPreview(List<LittleTilePreview> previews) {
        for (LittleTilePreview preview : previews) {
            this.addPreview(preview);
        }
    }

    public void addPreview(LittleTilePreview preview) {
        if (preview.canBeConvertedToBlockEntry()) {
            this.block.addIngredient(preview.getBlockIngredient());
            this.color.addColorUnit(ColorUnit.getRequiredColors(preview));
        }
    }

    public void addPreview(LittleTilePreview preview, double volume) {
        if (preview.canBeConvertedToBlockEntry()) {
            BlockIngredient ingredient = preview.getBlockIngredient();
            ingredient.value = volume;
            this.block.addIngredient(ingredient);
            this.color.addColorUnit(ColorUnit.getRequiredColors(preview, volume));
        }
    }
}

