/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTiles
extends ItemBlock
implements ILittleTile,
ICreativeRendered {
    public ItemBlockTiles(Block block, ResourceLocation location) {
        super(block);
        this.func_77655_b(location.func_110623_a());
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String result = super.func_77653_i(stack);
        if (stack.func_77942_o()) {
            LittleTileSize size = stack.func_77978_p().func_74764_b("size") ? new LittleTileSize("size", stack.func_77978_p()) : LittleTileBox.loadBox("bBox", stack.func_77978_p()).getSize();
            result = result + " (x=" + size.sizeX + ",y=" + size.sizeY + "z=" + size.sizeZ + ")";
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        Block block;
        if (stack.func_77942_o() && (block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("block"))) != null && !(block instanceof BlockAir)) {
            return new ItemStack(block, 1, stack.func_77978_p().func_74762_e("meta")).func_77977_a();
        }
        return super.func_77667_c(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item stack, CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    public ArrayList<LittleTilePreview> getLittlePreview(ItemStack stack) {
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        previews.add(LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p()));
        return previews;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, List<LittleTilePreview> previews) {
        if (previews.size() > 0) {
            LittleTilePreview preview = previews.get(0);
            NBTTagCompound nbt = preview.getTileData().func_74737_b();
            LittleTileBox tempBox = preview.box;
            preview.box = preview.box.copy();
            preview.box.subOffset(preview.box.getMinVec());
            preview.writeToNBT(nbt);
            preview.box = tempBox;
            stack.func_77982_d(nbt);
        } else {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public static ItemStack getStackFromPreview(LittleTilePreview preview) {
        ItemStack stack = new ItemStack((Block)LittleTiles.blockTile);
        NBTTagCompound nbt = preview.getTileData().func_74737_b();
        preview.writeToNBT(nbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static List<LittleRenderingCube> getItemRenderingCubes(ItemStack stack) {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        if (stack != null && stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("size")) {
                Block block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("block"));
                int meta = stack.func_77978_p().func_74762_e("meta");
                LittleTileSize size = new LittleTileSize("size", stack.func_77978_p());
                if (!(block instanceof BlockAir)) {
                    LittleRenderingCube cube = new LittleTileBox(new LittleTileVec(LittleTile.halfGridSize, LittleTile.halfGridSize, LittleTile.halfGridSize), size).getRenderingCube(block, meta);
                    if (stack.func_77978_p().func_74764_b("color")) {
                        cube.color = stack.func_77978_p().func_74762_e("color");
                    }
                    cubes.add(cube);
                }
            } else {
                LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p());
                cubes.add((LittleRenderingCube)preview.getCubeBlock());
            }
        }
        return cubes;
    }

    @Override
    public LittleStructure getLittleStructure(ItemStack stack) {
        return null;
    }

    public List<? extends RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return new ArrayList();
    }
}

