/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.gui.opener.GuiHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.container.SubContainerGrabber;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleVanillaBlockPacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShape;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.Color;

public class ItemLittleChisel
extends Item
implements ICreativeRendered,
ILittleTile {
    public static LittleTileVec min;
    @SideOnly(value=Side.CLIENT)
    public static LittleTileVec lastMax;
    private static LittleTileVec cachedPos;
    private static List<LittleTileBox> cachedShape;
    private static boolean cachedLow;
    private static NBTTagCompound cachedSettings;

    public ItemLittleChisel() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
        this.func_77625_d(1);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        DragShape shape = ItemLittleChisel.getShape(stack);
        list.add("shape: " + shape.key);
        shape.addExtraInformation(stack.func_77978_p(), list);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return false;
    }

    public static DragShape getShape(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return DragShape.getShape(stack.func_77978_p().func_74779_i("shape"));
    }

    public static void setShape(ItemStack stack, DragShape shape) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("shape", shape.key);
    }

    public static LittleTilePreview getPreview(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("preview")) {
            return LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p().func_74775_l("preview"));
        }
        IBlockState state = stack.func_77978_p().func_74764_b("state") ? Block.func_176220_d((int)stack.func_77978_p().func_74762_e("state")) : Blocks.field_150348_b.func_176223_P();
        LittleTileBlock tile = stack.func_77978_p().func_74764_b("color") ? new LittleTileBlockColored(state.func_177230_c(), state.func_177230_c().func_176201_c(state), stack.func_77978_p().func_74762_e("color")) : new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        tile.box = new LittleTileBox(LittleTile.minPos, LittleTile.minPos, LittleTile.minPos, LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize);
        LittleTilePreview preview = tile.getPreviewTile();
        ItemLittleChisel.setPreview(stack, preview);
        return preview;
    }

    public static void setPreview(ItemStack stack, LittleTilePreview preview) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        preview.writeToNBT(nbt);
        stack.func_77978_p().func_74782_a("preview", (NBTBase)nbt);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        IBakedModel model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:chisel_background", "inventory"));
        ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
        mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            LittleTilePreview preview = ItemLittleChisel.getPreview(stack);
            ItemStack blockStack = new ItemStack(preview.getPreviewBlock(), 1, preview.getPreviewBlockMeta());
            model = mc.func_175599_af().func_184393_a(blockStack, (World)mc.field_71441_e, (EntityLivingBase)mc.field_71439_g);
            if (!(model instanceof CreativeBakedModel)) {
                ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            try {
                if (model.func_188618_c()) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179091_B();
                    TileEntityItemStackRenderer.field_147719_a.func_179022_a(blockStack);
                } else {
                    Color color = preview.hasColor() ? ColorUtils.IntToRGBA((int)preview.getColor()) : ColorUtils.IntToRGBA((int)ColorUtils.WHITE);
                    color.setAlpha(255);
                    ReflectionHelper.findMethod(RenderItem.class, (String)"renderModel", (String)"func_175045_a", (Class[])new Class[]{IBakedModel.class, Integer.TYPE, ItemStack.class}).invoke((Object)mc.func_175599_af(), model, preview.hasColor() ? ColorUtils.RGBAToInt((Color)color) : -1, blockStack);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return min != null;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static LittleTileBox getBox() {
        if (lastMax == null) {
            lastMax = min.copy();
        }
        return new LittleTileBox(new LittleTileBox(min), new LittleTileBox(lastMax));
    }

    @Override
    public List<LittleTilePreview> getLittlePreview(ItemStack stack) {
        return null;
    }

    @Override
    public List<LittleTilePreview> getLittlePreview(ItemStack stack, boolean allowLowResolution, boolean marked) {
        if (min != null) {
            boolean low;
            List<LittleTileBox> boxes = null;
            boolean bl = low = allowLowResolution && !marked;
            if (cachedPos == null || !cachedPos.equals(lastMax) || !cachedSettings.equals((Object)stack.func_77978_p()) || cachedLow != low) {
                DragShape shape = ItemLittleChisel.getShape(stack);
                LittleTileBox newBox = ItemLittleChisel.getBox();
                boxes = shape.getBoxes(newBox.getMinVec(), newBox.getMaxVec(), ItemLittleChisel.getPlayer(), stack.func_77978_p(), low, min, lastMax);
                cachedPos = lastMax.copy();
                cachedShape = new ArrayList<LittleTileBox>(boxes);
                cachedSettings = stack.func_77978_p().func_74737_b();
                cachedLow = low;
            } else {
                boxes = cachedShape;
            }
            ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
            LittleTilePreview preview = ItemLittleChisel.getPreview(stack);
            for (int i = 0; i < boxes.size(); ++i) {
                LittleTilePreview newPreview = preview.copy();
                newPreview.box = boxes.get(i);
                previews.add(newPreview);
            }
            return previews;
        }
        return null;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, List<LittleTilePreview> previews) {
    }

    @Override
    public void rotateLittlePreview(ItemStack stack, Rotation rotation) {
        ItemLittleChisel.getShape(stack).rotate(stack.func_77978_p(), rotation);
    }

    @Override
    public void flipLittlePreview(ItemStack stack, EnumFacing.Axis axis) {
        ItemLittleChisel.getShape(stack).flip(stack.func_77978_p(), axis);
    }

    @Override
    public LittleStructure getLittleStructure(ItemStack stack) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getPreviewAlphaFactor() {
        return 0.4f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void tickPreview(EntityPlayer player, ItemStack stack, PlacementHelper.PositionResult position, RayTraceResult result) {
        lastMax = position.getAbsoluteVec();
        if (position.facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
            lastMax.add(position.facing);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldCache() {
        return false;
    }

    @Override
    public boolean arePreviewsAbsolute() {
        return true;
    }

    @Override
    public void onDeselect(EntityPlayer player, ItemStack stack) {
        min = null;
        lastMax = null;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        LittleTileVec absoluteHit = new LittleTileVec(result);
        if (min == null) {
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                absoluteHit.add(result.field_178784_b);
            }
            min = absoluteHit;
        } else if (LittleAction.isUsingSecondMode(player)) {
            min = null;
        } else {
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseWheelClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        IBlockState state = player.field_70170_p.func_180495_p(result.func_178782_a());
        if (SubContainerGrabber.isBlockValid(state.func_177230_c())) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleVanillaBlockPacket(result.func_178782_a(), LittleVanillaBlockPacket.VanillaBlockAction.CHISEL));
            return true;
        }
        if (state.func_177230_c() instanceof BlockTile) {
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(result.func_178782_a(), player, LittleBlockPacket.BlockPacketAction.CHISEL, new NBTTagCompound()));
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClickBlock(EntityPlayer player, ItemStack stack, RayTraceResult result) {
        GuiHandler.openGui((String)"chisel", (NBTTagCompound)new NBTTagCompound(), (EntityPlayer)player);
    }
}

