/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.IExtendedCreativeRendered;
import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.opener.GuiHandler;
import com.creativemd.creativecore.gui.opener.IGuiCreator;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.ItemModelCache;
import com.creativemd.littletiles.common.container.SubContainerStructure;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRecipe
extends Item
implements IExtendedCreativeRendered,
IGuiCreator {
    public ItemRecipe() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!player.func_70093_af() && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            if (!world.field_72995_K) {
                GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                stack.func_77982_d(null);
            }
            return EnumActionResult.SUCCESS;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("x")) {
            if (!world.field_72995_K) {
                int firstX = stack.func_77978_p().func_74762_e("x");
                int firstY = stack.func_77978_p().func_74762_e("y");
                int firstZ = stack.func_77978_p().func_74762_e("z");
                int minX = Math.min(firstX, pos.func_177958_n());
                int maxX = Math.max(firstX, pos.func_177958_n());
                int minY = Math.min(firstY, pos.func_177956_o());
                int maxY = Math.max(firstY, pos.func_177956_o());
                int minZ = Math.min(firstZ, pos.func_177952_p());
                int maxZ = Math.max(firstZ, pos.func_177952_p());
                ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
                stack.func_77978_p().func_82580_o("x");
                stack.func_77978_p().func_82580_o("y");
                stack.func_77978_p().func_82580_o("z");
                for (int posX = minX; posX <= maxX; ++posX) {
                    for (int posY = minY; posY <= maxY; ++posY) {
                        for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                            List<LittleTilePreview> specialPreviews;
                            BlockPos newPos = new BlockPos(posX, posY, posZ);
                            TileEntity tileEntity = world.func_175625_s(newPos);
                            LittleTileVec offset = new LittleTileVec((posX - minX) * LittleTile.gridSize, (posY - minY) * LittleTile.gridSize, (posZ - minZ) * LittleTile.gridSize);
                            if (tileEntity instanceof TileEntityLittleTiles) {
                                TileEntityLittleTiles te = (TileEntityLittleTiles)tileEntity;
                                Iterator<LittleTile> iterator = te.getTiles().iterator();
                                while (iterator.hasNext()) {
                                    LittleTilePreview preview = iterator.next().getPreviewTile();
                                    preview.box.addOffset(offset);
                                    previews.add(preview);
                                }
                            }
                            if ((specialPreviews = ChiselsAndBitsManager.getPreviews(tileEntity)) == null) continue;
                            for (int i = 0; i < specialPreviews.size(); ++i) {
                                specialPreviews.get((int)i).box.addOffset(offset);
                                previews.add(specialPreviews.get(i));
                            }
                        }
                    }
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("Second position: x=" + pos.func_177958_n() + ",y=" + pos.func_177956_o() + ",z=" + pos.func_177952_p(), new Object[0]));
                LittleTilePreview.savePreviewTiles(previews, stack);
            }
            return EnumActionResult.SUCCESS;
        }
        if (!stack.func_77942_o()) {
            if (!world.field_72995_K) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
                stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
                stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
                player.func_145747_a((ITextComponent)new TextComponentTranslation("First position: x=" + pos.func_177958_n() + ",y=" + pos.func_177956_o() + ",z=" + pos.func_177952_p(), new Object[0]));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("x")) {
                list.add("First pos: x=" + stack.func_77978_p().func_74762_e("x") + ",y=" + stack.func_77978_p().func_74762_e("y") + ",z=" + stack.func_77978_p().func_74762_e("z"));
            } else {
                String id = "none";
                if (stack.func_77978_p().func_74764_b("structure")) {
                    id = stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
                }
                list.add("structure: " + id);
                list.add("contains " + stack.func_77978_p().func_74762_e("count") + " tiles");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiStructure(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerStructure(player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public ArrayList<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            return LittleTilePreview.getCubes(stack);
        }
        return new ArrayList<RenderCubeObject>();
    }

    @SideOnly(value=Side.CLIENT)
    public void applyCustomOpenGLHackery(ItemStack stack, ItemCameraTransforms.TransformType cameraTransformType) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tiles")) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179097_i();
            }
            IBakedModel model = mc.func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("littletiles:recipe_background", "inventory"));
            ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)cameraTransformType, (boolean)false);
            mc.func_175599_af().func_180454_a(new ItemStack(Items.field_151121_aF), model);
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179126_j();
            }
        }
        GlStateManager.func_179121_F();
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("x")) {
            LittleTileSize size = LittleTilePreview.getSize(stack);
            double scaler = 1.0 / Math.max(1.0, Math.max(1.0, Math.max(size.getPosX(), Math.max(size.getPosY(), size.getPosZ()))));
            GlStateManager.func_179139_a((double)scaler, (double)scaler, (double)scaler);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getSpecialBakedQuads(IBlockState state, TileEntity te, EnumFacing side, long rand, ItemStack stack) {
        return new ArrayList<BakedQuad>();
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        ItemModelCache.cacheModel(stack, facing, cachedQuads);
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        return ItemModelCache.getCache(stack, facing);
    }
}

