/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.opener.GuiHandler;
import com.creativemd.creativecore.gui.opener.IGuiCreator;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.container.SubContainerTileContainer;
import com.creativemd.littletiles.common.gui.SubGuiTileContainer;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.ingredients.ColorUnit;
import com.creativemd.littletiles.common.tiles.LittleTile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTileContainer
extends Item
implements IGuiCreator {
    public static int colorUnitMaximum = 1000000;
    public static int inventoryWidth = 6;
    public static int inventoryHeight = 4;
    public static int inventorySize = inventoryWidth * inventoryHeight;
    public static int maxStackSize = 64;
    public static int maxStackSizeOfTiles = maxStackSize * LittleTile.maxTilesPerBlock;

    public ItemTileContainer() {
        this.func_77637_a(LittleTiles.littleTab);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
    }

    public static void saveInventory(ItemStack stack, List<BlockIngredient> inventory) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = new NBTTagList();
        int i = 0;
        for (BlockIngredient ingredient : inventory) {
            if (ingredient.block instanceof BlockAir) continue;
            if (i >= inventorySize) break;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)ingredient.block)).toString());
            nbt.func_74768_a("meta", ingredient.meta);
            nbt.func_74780_a("volume", ingredient.value);
            list.func_74742_a((NBTBase)nbt);
            ++i;
        }
        stack.func_77978_p().func_74782_a("inv", (NBTBase)list);
    }

    public static List<BlockIngredient> loadInventory(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ArrayList<BlockIngredient> inventory = new ArrayList<BlockIngredient>();
        NBTTagList list = stack.func_77978_p().func_150295_c("inv", 10);
        int size = Math.min(inventorySize, list.func_74745_c());
        for (int i = 0; i < size; ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
            if (block instanceof BlockAir) continue;
            inventory.add(new BlockIngredient(block, nbt.func_74762_e("meta"), nbt.func_74769_h("volume")));
        }
        return inventory;
    }

    public static BlockIngredient.BlockIngredients drainBlocks(ItemStack stack, BlockIngredient.BlockIngredients ingredients, boolean simulate) {
        List<BlockIngredient> inventory = ItemTileContainer.loadInventory(stack);
        Iterator<BlockIngredient> iterator = ingredients.getIngredients().iterator();
        block0: while (iterator.hasNext()) {
            BlockIngredient ingredient = iterator.next();
            Iterator<BlockIngredient> iterator2 = inventory.iterator();
            while (iterator2.hasNext()) {
                BlockIngredient invIngredient = iterator2.next();
                if (!invIngredient.equals(ingredient)) continue;
                double amount = Math.min(invIngredient.value, ingredient.value);
                ingredient.value -= amount;
                invIngredient.value -= amount;
                if (ingredient.value <= 0.0) {
                    iterator.remove();
                    continue block0;
                }
                if (!(invIngredient.value <= 0.0)) continue;
                iterator2.remove();
            }
        }
        if (!simulate) {
            ItemTileContainer.saveInventory(stack, inventory);
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return ingredients;
    }

    public static BlockIngredient.BlockIngredients storeBlocks(ItemStack stack, BlockIngredient.BlockIngredients ingredients, boolean simulate) {
        if ((ingredients = ItemTileContainer.storeBlocks(stack, ingredients, true, simulate)) != null) {
            ingredients = ItemTileContainer.storeBlocks(stack, ingredients, false, simulate);
        }
        return ingredients;
    }

    public static BlockIngredient.BlockIngredients storeBlocks(ItemStack stack, BlockIngredient.BlockIngredients ingredients, boolean stackOnly, boolean simulate) {
        List<BlockIngredient> inventory = ItemTileContainer.loadInventory(stack);
        if (stackOnly) {
            Iterator<BlockIngredient> iterator = ingredients.getIngredients().iterator();
            block0: while (iterator.hasNext()) {
                BlockIngredient ingredient = iterator.next();
                for (BlockIngredient equal : inventory) {
                    if (!equal.equals(ingredient)) continue;
                    double amount = Math.min(equal.value + ingredient.value, (double)maxStackSize);
                    ingredient.value -= amount - equal.value;
                    equal.value = amount;
                    if (!(ingredient.value <= 0.0)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        } else {
            Iterator<BlockIngredient> iterator = ingredients.getIngredients().iterator();
            while (iterator.hasNext()) {
                BlockIngredient ingredient = iterator.next();
                if (inventory.size() < inventorySize) {
                    double amount = Math.min(ingredient.value, (double)maxStackSize);
                    ingredient.value -= amount;
                    if (ingredient.value <= 0.0) {
                        iterator.remove();
                    }
                    inventory.add(ingredient.copy(amount));
                    continue;
                }
                break;
            }
        }
        if (!simulate) {
            ItemTileContainer.saveInventory(stack, inventory);
        }
        if (ingredients.isEmpty()) {
            return null;
        }
        return ingredients;
    }

    public static ColorUnit loadColorUnit(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new ColorUnit(stack.func_77978_p().func_74762_e("black"), stack.func_77978_p().func_74762_e("red"), stack.func_77978_p().func_74762_e("green"), stack.func_77978_p().func_74762_e("blue"));
    }

    public static void saveColorUnit(ItemStack stack, ColorUnit unit) {
        stack.func_77978_p().func_74768_a("black", unit.BLACK);
        stack.func_77978_p().func_74768_a("red", unit.RED);
        stack.func_77978_p().func_74768_a("green", unit.GREEN);
        stack.func_77978_p().func_74768_a("blue", unit.BLUE);
    }

    public static ColorUnit storeColor(ItemStack stack, ColorUnit unit, boolean simulate) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ColorUnit result = unit.copy();
        int maxBlack = Math.min(stack.func_77978_p().func_74762_e("black") + unit.BLACK, colorUnitMaximum);
        if (stack.func_77978_p().func_74762_e("black") != maxBlack) {
            result.BLACK -= maxBlack - stack.func_77978_p().func_74762_e("black");
        }
        int maxRed = Math.min(stack.func_77978_p().func_74762_e("red") + unit.RED, colorUnitMaximum);
        if (stack.func_77978_p().func_74762_e("red") != maxRed) {
            result.RED -= maxRed - stack.func_77978_p().func_74762_e("red");
        }
        int maxGreen = Math.min(stack.func_77978_p().func_74762_e("green") + unit.GREEN, colorUnitMaximum);
        if (stack.func_77978_p().func_74762_e("green") != maxGreen) {
            result.GREEN -= maxGreen - stack.func_77978_p().func_74762_e("green");
        }
        int maxBlue = Math.min(stack.func_77978_p().func_74762_e("blue") + unit.BLUE, colorUnitMaximum);
        if (stack.func_77978_p().func_74762_e("blue") != maxBlue) {
            result.BLUE -= maxBlue - stack.func_77978_p().func_74762_e("blue");
        }
        if (!simulate) {
            stack.func_77978_p().func_74768_a("black", maxBlack);
            stack.func_77978_p().func_74768_a("red", maxRed);
            stack.func_77978_p().func_74768_a("green", maxGreen);
            stack.func_77978_p().func_74768_a("blue", maxBlue);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static ColorUnit drainColor(ItemStack stack, ColorUnit unit, boolean simulate) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        ColorUnit result = unit.copy();
        int drainBlack = Math.min(unit.BLACK, stack.func_77978_p().func_74762_e("black"));
        result.BLACK -= drainBlack;
        int drainRed = Math.min(unit.RED, stack.func_77978_p().func_74762_e("red"));
        result.RED -= drainRed;
        int drainGreen = Math.min(unit.GREEN, stack.func_77978_p().func_74762_e("green"));
        result.GREEN -= drainGreen;
        int drainBlue = Math.min(unit.BLUE, stack.func_77978_p().func_74762_e("blue"));
        result.BLUE -= drainBlue;
        if (!simulate) {
            stack.func_77978_p().func_74768_a("black", stack.func_77978_p().func_74762_e("black") - drainBlack);
            stack.func_77978_p().func_74768_a("red", stack.func_77978_p().func_74762_e("red") - drainRed);
            stack.func_77978_p().func_74768_a("green", stack.func_77978_p().func_74762_e("green") - drainGreen);
            stack.func_77978_p().func_74768_a("blue", stack.func_77978_p().func_74762_e("blue") - drainBlue);
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiTileContainer(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerTileContainer(player, stack, player.field_71071_by.field_70461_c);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)player, (World)world);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }
}

