/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mods.chiselsandbits;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockLTTransparentColored;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.LittleTileBlockColored;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ChiselsAndBitsInteractor {
    public static boolean isChiselsAndBitsStructure(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Map blocks = ChiselsAndBits.getBlocks().getConversions();
        for (Block block2 : blocks.values()) {
            if (block != block2) continue;
            return true;
        }
        return false;
    }

    public static List<LittleTile> getTiles(VoxelBlob blob) {
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        for (int x = 0; x < ChiselsAndBitsManager.convertingFrom; ++x) {
            for (int y = 0; y < ChiselsAndBitsManager.convertingFrom; ++y) {
                for (int z = 0; z < ChiselsAndBitsManager.convertingFrom; ++z) {
                    IBlockState state = ModUtil.getStateById((int)blob.get(x, y, z));
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        state = LittleTiles.transparentColoredBlock.func_176223_P().func_177226_a(BlockLTTransparentColored.VARIANT, (Comparable)((Object)BlockLTTransparentColored.EnumType.water));
                    }
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.box = new LittleTileBox(new LittleTileVec(x, y, z));
                    tiles.add(tile);
                }
            }
        }
        TileEntityLittleTiles.combineTilesList(tiles);
        return tiles;
    }

    public static List<LittleTilePreview> getPreviews(VoxelBlob blob) {
        List<LittleTile> tiles = ChiselsAndBitsInteractor.getTiles(blob);
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        for (int i = 0; i < tiles.size(); ++i) {
            previews.add(tiles.get(i).getPreviewTile());
        }
        return previews;
    }

    public static List<LittleTilePreview> getPreviews(ItemStack stack) {
        if (ChiselsAndBitsInteractor.isChiselsAndBitsStructure(stack)) {
            return ChiselsAndBitsInteractor.getPreviews(ModUtil.getBlobFromStack((ItemStack)stack, null));
        }
        return null;
    }

    public static List<LittleTilePreview> getPreviews(TileEntity te) {
        if (te instanceof TileEntityBlockChiseled) {
            return ChiselsAndBitsInteractor.getPreviews(((TileEntityBlockChiseled)te).getBlob());
        }
        return null;
    }

    public static boolean isChiselsAndBitsStructure(TileEntity te) {
        return te instanceof TileEntityBlockChiseled;
    }

    public static List<LittleTile> getTiles(TileEntity te) {
        if (te instanceof TileEntityBlockChiseled) {
            return ChiselsAndBitsInteractor.getTiles(((TileEntityBlockChiseled)te).getBlob());
        }
        return null;
    }

    public static VoxelBlob getVoxelBlob(TileEntityLittleTiles te, boolean force) throws Exception {
        if (LittleTile.gridSize != ChiselsAndBitsManager.convertingFrom) {
            throw new Exception("Invalid grid size of " + LittleTile.gridSize + "!");
        }
        VoxelBlob blob = new VoxelBlob();
        for (LittleTile tile : te.getTiles()) {
            boolean convert;
            if (tile.getClass() == LittleTileBlock.class) {
                convert = true;
            } else if (force) {
                if (tile.getClass() != LittleTileBlockColored.class) continue;
                convert = true;
            } else {
                throw new Exception("Cannot convert " + tile.getClass() + " tile!");
            }
            if (!convert) continue;
            if (!force && tile.box.getClass() != LittleTileBox.class) {
                throw new Exception("Cannot convert " + tile.box.getClass() + " box!");
            }
            for (int x = tile.box.minX; x < tile.box.maxX; ++x) {
                for (int y = tile.box.minY; y < tile.box.maxY; ++y) {
                    for (int z = tile.box.minZ; z < tile.box.maxZ; ++z) {
                        if (!tile.box.isCompletelyFilled() && !tile.box.isVecInsideBox(x, y, z)) continue;
                        blob.set(x, y, z, Block.func_176210_f((IBlockState)((LittleTileBlock)tile).getBlockState()));
                    }
                }
            }
        }
        return blob;
    }
}

