/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class LittleEntityRequestPacket
extends CreativeCorePacket {
    public UUID uuid;
    public NBTTagCompound nbt;
    public boolean completeData;

    public LittleEntityRequestPacket() {
    }

    public LittleEntityRequestPacket(UUID uuid, NBTTagCompound nbt, boolean completeData) {
        this.uuid = uuid;
        this.nbt = nbt;
        this.completeData = completeData;
    }

    public void writeBytes(ByteBuf buf) {
        LittleEntityRequestPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
        buf.writeBoolean(this.completeData);
        LittleEntityRequestPacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.uuid = UUID.fromString(LittleEntityRequestPacket.readString((ByteBuf)buf));
        this.completeData = buf.readBoolean();
        this.nbt = LittleEntityRequestPacket.readNBT((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        EntityAnimation animation = null;
        for (Entity entity : player.field_70170_p.func_72910_y()) {
            if (!(entity instanceof EntityDoorAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityDoorAnimation)entity;
            break;
        }
        if (animation != null) {
            if (this.nbt.func_74767_n("failed")) {
                animation.func_70106_y();
            } else if (this.completeData) {
                animation.func_70020_e(this.nbt);
                ((EntityDoorAnimation)animation).createClient();
                animation.updateBoundingBox();
                ((EntityDoorAnimation)animation).approved = true;
            } else {
                DoorTransformation transformation = DoorTransformation.loadFromNBT(this.nbt);
                ((EntityDoorAnimation)animation).approved = ((EntityDoorAnimation)animation).transformation.equals(transformation);
            }
        }
    }

    public void executeServer(EntityPlayer player) {
        EntityDoorAnimation animation = null;
        for (Entity entity : player.field_70170_p.func_175644_a(EntityDoorAnimation.class, (Predicate)new Predicate<EntityDoorAnimation>(){

            public boolean apply(EntityDoorAnimation input) {
                return true;
            }
        })) {
            if (!(entity instanceof EntityDoorAnimation) || !entity.func_110124_au().equals(this.uuid)) continue;
            animation = (EntityDoorAnimation)entity;
            break;
        }
        if (animation != null) {
            if (this.completeData) {
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(this.uuid, animation.func_189511_e(new NBTTagCompound()), this.completeData), (EntityPlayerMP)((EntityPlayerMP)player));
            } else {
                PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(this.uuid, animation.transformation.writeToNBT(new NBTTagCompound()), this.completeData), (EntityPlayerMP)((EntityPlayerMP)player));
            }
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("failed", true);
            PacketHandler.sendPacketToPlayer((CreativeCorePacket)new LittleEntityRequestPacket(this.uuid, nbt, false), (EntityPlayerMP)((EntityPlayerMP)player));
        }
    }
}

