/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class LittleFlipPacket
extends CreativeCorePacket {
    public EnumFacing.Axis axis;

    public LittleFlipPacket() {
    }

    public LittleFlipPacket(EnumFacing.Axis axis) {
        this.axis = axis;
    }

    public void writeBytes(ByteBuf buf) {
        buf.writeInt(this.axis.ordinal());
    }

    public void readBytes(ByteBuf buf) {
        this.axis = EnumFacing.Axis.values()[buf.readInt()];
    }

    public void executeClient(EntityPlayer player) {
        this.execute(player);
    }

    public void execute(EntityPlayer player) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (PlacementHelper.getLittleInterface(stack) != null) {
            ILittleTile itile = null;
            if (stack.func_77973_b() instanceof ILittleTile) {
                itile = (ILittleTile)stack.func_77973_b();
            } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
                itile = (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
            }
            if (itile != null) {
                itile.flipLittlePreview(stack, this.axis);
                LittleStructure structure = itile.getLittleStructure(stack);
                if (structure != null) {
                    structure.onFlip(player.field_70170_p, player, stack, this.axis, ILittleTile.rotationCenter);
                    NBTTagCompound nbt = new NBTTagCompound();
                    structure.writeToNBT(nbt);
                    stack.func_77978_p().func_74782_a("structure", (NBTBase)nbt);
                }
            }
        }
    }

    public void executeServer(EntityPlayer player) {
        this.execute(player);
    }
}

