/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileAbsoluteCoord;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileUpdatePacket
extends CreativeCorePacket {
    public LittleTileAbsoluteCoord coord;
    public NBTTagCompound nbt;

    public LittleTileUpdatePacket(LittleTile tile, NBTTagCompound nbt) {
        this.coord = new LittleTileAbsoluteCoord(tile);
        this.nbt = nbt;
    }

    public LittleTileUpdatePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeAbsoluteCoord(this.coord, buf);
        LittleTileUpdatePacket.writeNBT((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public void readBytes(ByteBuf buf) {
        this.coord = LittleAction.readAbsoluteCoord(buf);
        this.nbt = LittleTileUpdatePacket.readNBT((ByteBuf)buf);
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        try {
            LittleTile tile = LittleAction.getTile(player.field_70170_p, this.coord);
            if (tile.supportsUpdatePacket()) {
                tile.receivePacket(this.nbt, FMLClientHandler.instance().getClientToServerNetworkManager());
            }
        }
        catch (LittleActionException e) {
            e.printStackTrace();
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

