/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.littletiles.common.container.SubContainerGrabber;
import com.creativemd.littletiles.common.items.ItemColorTube;
import com.creativemd.littletiles.common.items.ItemLittleChisel;
import com.creativemd.littletiles.common.items.ItemLittleGrabber;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import io.netty.buffer.ByteBuf;
import mod.flatcoloredblocks.block.BlockFlatColored;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleVanillaBlockPacket
extends CreativeCorePacket {
    public BlockPos pos;
    public VanillaBlockAction action;

    public LittleVanillaBlockPacket(BlockPos pos, VanillaBlockAction action) {
        this.action = action;
        this.pos = pos;
    }

    public LittleVanillaBlockPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleVanillaBlockPacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeInt(this.action.ordinal());
    }

    public void readBytes(ByteBuf buf) {
        this.pos = LittleVanillaBlockPacket.readPos((ByteBuf)buf);
        this.action = VanillaBlockAction.values()[buf.readInt()];
    }

    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        this.action.action(player.field_70170_p, player, this.pos, player.field_70170_p.func_180495_p(this.pos));
        if (!player.field_70170_p.field_72995_K) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
        }
    }

    public static enum VanillaBlockAction {
        COLOR_TUBE{
            boolean flatColoredBlocks = this.isFlatColoredBlocksInstalled();

            public boolean isFlatColoredBlocksInstalled() {
                try {
                    return Class.forName("mod.flatcoloredblocks.block.BlockFlatColored") != null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }

            @Override
            public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
                int color = ColorUtils.WHITE;
                if (this.flatColoredBlocks && state.func_177230_c() instanceof BlockFlatColored) {
                    color = ((BlockFlatColored)state.func_177230_c()).colorFromState(state);
                }
                ItemColorTube.setColor(player.func_184614_ca(), color);
            }
        }
        ,
        CHISEL{

            @Override
            public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
                if (SubContainerGrabber.isBlockValid(state.func_177230_c())) {
                    LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.box = new LittleTileBox(LittleTile.minPos, LittleTile.minPos, LittleTile.minPos, LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize);
                    ItemLittleChisel.setPreview(player.func_184614_ca(), tile.getPreviewTile());
                }
            }
        }
        ,
        GRABBER{

            @Override
            public void action(World world, EntityPlayer player, BlockPos pos, IBlockState state) {
                if (SubContainerGrabber.isBlockValid(state.func_177230_c())) {
                    ItemStack stack = player.func_184614_ca();
                    ItemLittleGrabber.GrabberMode mode = ItemLittleGrabber.getMode(stack);
                    mode.vanillaBlockAction(world, stack, pos, state);
                }
            }
        };


        public abstract void action(World var1, EntityPlayer var2, BlockPos var3, IBlockState var4);
    }
}

