/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiIDButton;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.packet.LittleDoorInteractPacket;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.PlacePreviewTileAxis;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.rotation.OrdinaryDoorTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoor
extends LittleDoorBase {
    public EnumFacing normalDirection;
    public EnumFacing.Axis axis;
    public LittleTileVec doubledRelativeAxis;
    public LittleTileVec lastMainTileVec = null;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        if (nbt.func_74764_b("ax")) {
            this.doubledRelativeAxis = new LittleTileVec("a", nbt);
            if (this.getMainTile() != null) {
                this.doubledRelativeAxis.sub(this.getMainTile().getMinVec());
            }
            this.doubledRelativeAxis.scale(2);
            this.doubledRelativeAxis.add(new LittleTileVec(1, 1, 1));
        } else if (nbt.func_74764_b("av")) {
            this.doubledRelativeAxis = new LittleTileVec("av", nbt);
            this.doubledRelativeAxis.scale(2);
            this.doubledRelativeAxis.add(new LittleTileVec(1, 1, 1));
        } else {
            this.doubledRelativeAxis = new LittleTileVec("avec", nbt);
        }
        this.axis = EnumFacing.Axis.values()[nbt.func_74762_e("axis")];
        this.normalDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("ndirection"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        this.doubledRelativeAxis.writeToNBT("avec", nbt);
        nbt.func_74768_a("axis", this.axis.ordinal());
        nbt.func_74768_a("ndirection", this.normalDirection.func_176745_a());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        super.createControls(gui, structure);
        LittleDoor door = null;
        if (structure instanceof LittleDoor) {
            door = (LittleDoor)structure;
        }
        GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, ((SubGuiStructure)gui).stack);
        boolean even = false;
        if (door != null) {
            tile.axisDirection = door.axis;
            tile.axisX = door.doubledRelativeAxis.x;
            tile.axisY = door.doubledRelativeAxis.y;
            tile.axisZ = door.doubledRelativeAxis.z;
            tile.normalAxis = door.normalDirection.func_176740_k();
            even = door.doubledRelativeAxis.x % 2 == 0;
            tile.setEven(even);
        } else {
            tile.setEven(false);
        }
        tile.visibleAxis = true;
        tile.updateViewDirection();
        gui.controls.add(tile);
        gui.controls.add(new GuiIDButton("reset view", 109, 25, 0));
        gui.controls.add(new GuiIDButton("flip view", 109, 45, 1));
        gui.controls.add(new GuiIDButton("swap axis", 109, 5, 2));
        gui.controls.add(new GuiIDButton("swap normal", 109, 65, 3));
        gui.controls.add(new GuiButton("up", "<-", 125, 86, 14){

            public void onClicked(int x, int y, int button) {
            }
        }.setRotation(90.0f));
        gui.controls.add(new GuiIDButton("->", 146, 107, 4));
        gui.controls.add(new GuiIDButton("<-", 107, 107, 5));
        gui.controls.add(new GuiButton("down", "<-", 125, 107, 14){

            public void onClicked(int x, int y, int button) {
            }
        }.setRotation(-90.0f));
        gui.controls.add(new GuiCheckBox("even", 107, 124, even));
    }

    @Override
    public LittleTileVec getAbsoluteAxisVec() {
        LittleTileVec newAxisVec = new LittleTileVec(this.doubledRelativeAxis.x / 2, this.doubledRelativeAxis.y / 2, this.doubledRelativeAxis.z / 2);
        newAxisVec.add(this.getMainTile().getAbsoluteCoordinates());
        return newAxisVec;
    }

    @Override
    public LittleTileVec getAdditionalAxisVec() {
        return new LittleTileVec(this.doubledRelativeAxis.x % 2, this.doubledRelativeAxis.y % 2, this.doubledRelativeAxis.z % 2);
    }

    @Override
    public void moveStructure(EnumFacing facing) {
        this.doubledRelativeAxis.add(facing);
        this.doubledRelativeAxis.add(facing);
    }

    @Override
    public void setMainTile(LittleTile tile) {
        LittleTileVec absolute = tile.getAbsoluteCoordinates();
        if (this.getMainTile() != null) {
            LittleTileVec oldVec = this.lastMainTileVec;
            oldVec.sub(absolute);
            oldVec.scale(2);
            this.doubledRelativeAxis.add(oldVec);
        }
        this.lastMainTileVec = absolute;
        super.setMainTile(tile);
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(GuiControlClickEvent event) {
        GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
        if (event.source.is(new String[]{"swap axis"})) {
            switch (viewer.axisDirection) {
                case X: {
                    this.axis = EnumFacing.Axis.Y;
                    break;
                }
                case Y: {
                    this.axis = EnumFacing.Axis.Z;
                    break;
                }
                case Z: {
                    this.axis = EnumFacing.Axis.X;
                    break;
                }
            }
            viewer.axisDirection = this.axis;
            viewer.updateViewDirection();
            viewer.updateNormalAxis();
        } else if (event.source.is(new String[]{"reset view"})) {
            viewer.offsetX = 0.0f;
            viewer.offsetY = 0.0f;
            viewer.scale = 5.0f;
        } else if (event.source.is(new String[]{"flip view"})) {
            viewer.viewDirection = viewer.viewDirection.func_176734_d();
            viewer.baked = null;
        } else if (event.source instanceof GuiButton) {
            if (event.source.is(new String[]{"<-"})) {
                if (viewer.axisDirection == EnumFacing.Axis.X) {
                    viewer.axisZ += 2;
                } else {
                    viewer.axisX -= 2;
                }
            }
            if (event.source.is(new String[]{"->"})) {
                if (viewer.axisDirection == EnumFacing.Axis.X) {
                    viewer.axisZ -= 2;
                } else {
                    viewer.axisX += 2;
                }
            }
            if (event.source.is(new String[]{"up"})) {
                if (viewer.axisDirection == EnumFacing.Axis.Y) {
                    viewer.axisZ -= 2;
                } else {
                    viewer.axisY += 2;
                }
            }
            if (event.source.is(new String[]{"down"})) {
                if (viewer.axisDirection == EnumFacing.Axis.Y) {
                    viewer.axisZ += 2;
                } else {
                    viewer.axisY -= 2;
                }
            } else if (event.source.is(new String[]{"swap normal"})) {
                viewer.changeNormalAxis();
            }
        } else if (event.source.is(new String[]{"even"})) {
            viewer.setEven(((GuiCheckBox)event.source).value);
        }
    }

    @Override
    public ArrayList<PlacePreviewTile> getSpecialTiles() {
        ArrayList<PlacePreviewTile> boxes = new ArrayList<PlacePreviewTile>();
        LittleTileBox box = new LittleTileBox(this.doubledRelativeAxis.x / 2, this.doubledRelativeAxis.y / 2, this.doubledRelativeAxis.z / 2, this.doubledRelativeAxis.x / 2 + 1, this.doubledRelativeAxis.y / 2 + 1, this.doubledRelativeAxis.z / 2 + 1);
        boxes.add(new PlacePreviewTileAxis(box, null, this.axis, this.getAdditionalAxisVec()));
        return boxes;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        LittleTileVec doubleddoubled = doubledCenter.copy();
        doubleddoubled.scale(2);
        this.doubledRelativeAxis.scale(2);
        this.doubledRelativeAxis.sub(doubleddoubled);
        this.doubledRelativeAxis.flip(axis);
        this.doubledRelativeAxis.add(doubleddoubled);
        this.doubledRelativeAxis.x /= 2;
        this.doubledRelativeAxis.y /= 2;
        this.doubledRelativeAxis.z /= 2;
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, Rotation rotation, LittleTileVec doubledCenter) {
        LittleTileVec doubleddoubled = doubledCenter.copy();
        doubleddoubled.scale(2);
        this.doubledRelativeAxis.scale(2);
        this.doubledRelativeAxis.sub(doubleddoubled);
        this.doubledRelativeAxis.rotateVec(rotation);
        this.doubledRelativeAxis.add(doubleddoubled);
        this.doubledRelativeAxis.x /= 2;
        this.doubledRelativeAxis.y /= 2;
        this.doubledRelativeAxis.z /= 2;
        this.axis = RotationUtils.rotateFacing((EnumFacing)RotationUtils.getFacing((EnumFacing.Axis)this.axis), (Rotation)rotation).func_176740_k();
        this.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (Rotation)rotation);
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, BlockPos pos, Rotation direction, boolean inverse, UUID uuid, LittleTileVec absoluteAxis, LittleTileVec additional) {
        ArrayList<PlacePreviewTile> defaultpreviews = new ArrayList<PlacePreviewTile>();
        LittleTileVec invaxis = absoluteAxis.copy();
        invaxis.invert();
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tileOfList = iterator.next();
            NBTTagCompound nbt = new NBTTagCompound();
            LittleTilePreview preview = tileOfList.getPreviewTile();
            preview.box.addOffset((Vec3i)tileOfList.te.func_174877_v());
            preview.box.addOffset(invaxis);
            preview.rotatePreview(direction, additional);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, true, null));
        }
        defaultpreviews.add(new PlacePreviewTileAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), null, this.axis, additional));
        LittleTileVec internalOffset = absoluteAxis.copy();
        internalOffset.sub((Vec3i)pos);
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        for (int i = 0; i < defaultpreviews.size(); ++i) {
            PlacePreviewTile box = (PlacePreviewTile)defaultpreviews.get(i);
            box.box.addOffset(internalOffset);
            previews.add(box);
        }
        LittleDoor structure = new LittleDoor();
        structure.doubledRelativeAxis = new LittleTileVec(0, 0, 0);
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        structure.axis = this.axis;
        structure.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (Rotation)direction);
        structure.duration = this.duration;
        return this.place(world, structure, player, previews, pos, new OrdinaryDoorTransformation(direction), uuid, absoluteAxis, additional);
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && this.axis != null && !this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]), true);
                return true;
            }
            Rotation rotation = null;
            double playerRotation = MathHelper.func_76142_g((float)player.field_70177_z);
            boolean rotX = playerRotation <= -90.0 || playerRotation >= 90.0;
            boolean rotY = player.field_70125_A > 0.0f;
            boolean rotZ = playerRotation > 0.0 && playerRotation <= 180.0;
            boolean inverse = false;
            switch (this.axis) {
                case X: {
                    rotation = Rotation.X_CLOCKWISE;
                    switch (this.normalDirection) {
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.X_COUNTER_CLOCKWISE;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.X_COUNTER_CLOCKWISE;
                            break;
                        }
                        case SOUTH: {
                            if (rotX) break;
                            rotation = Rotation.X_COUNTER_CLOCKWISE;
                            break;
                        }
                        case NORTH: {
                            if (!rotX) break;
                            rotation = Rotation.X_COUNTER_CLOCKWISE;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.X_CLOCKWISE;
                    break;
                }
                case Y: {
                    rotation = Rotation.Y_CLOCKWISE;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotX) break;
                            rotation = Rotation.Y_COUNTER_CLOCKWISE;
                            break;
                        }
                        case WEST: {
                            if (rotX) break;
                            rotation = Rotation.Y_COUNTER_CLOCKWISE;
                            break;
                        }
                        case SOUTH: {
                            if (rotZ) break;
                            rotation = Rotation.Y_COUNTER_CLOCKWISE;
                            break;
                        }
                        case NORTH: {
                            if (!rotZ) break;
                            rotation = Rotation.Y_COUNTER_CLOCKWISE;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.Y_CLOCKWISE;
                    break;
                }
                case Z: {
                    rotation = Rotation.Z_CLOCKWISE;
                    switch (this.normalDirection) {
                        case EAST: {
                            if (!rotZ) break;
                            rotation = Rotation.Z_COUNTER_CLOCKWISE;
                            break;
                        }
                        case WEST: {
                            if (rotZ) break;
                            rotation = Rotation.Z_COUNTER_CLOCKWISE;
                            break;
                        }
                        case UP: {
                            if (rotY) break;
                            rotation = Rotation.Z_COUNTER_CLOCKWISE;
                            break;
                        }
                        case DOWN: {
                            if (!rotY) break;
                            rotation = Rotation.Z_COUNTER_CLOCKWISE;
                            break;
                        }
                    }
                    inverse = rotation == Rotation.Z_CLOCKWISE;
                    break;
                }
            }
            UUID uuid = UUID.randomUUID();
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleDoorInteractPacket(pos, player, rotation, inverse, uuid));
            this.interactWithDoor(world, player, rotation, inverse, uuid);
        }
        return true;
    }

    public boolean interactWithDoor(World world, EntityPlayer player, Rotation rotation, boolean inverse, UUID uuid) {
        this.LoadList();
        LittleTileVec axisPoint = this.getAbsoluteAxisVec();
        LittleTileVec additional = this.getAdditionalAxisVec();
        BlockPos main = axisPoint.getBlockPos();
        HashMapList tempTiles = new HashMapList(this.tiles);
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = true;
            ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = false;
        }
        if (this.tryToPlacePreviews(world, player, main, rotation, !inverse, uuid, axisPoint, additional) || this.tryToPlacePreviews(world, player, main, rotation.getOpposite(), inverse, uuid, axisPoint, additional)) {
            for (Map.Entry entry : tempTiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).updateTiles();
            }
            return true;
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).addTiles((Collection)entry.getValue());
        }
        return false;
    }

    public void updateNormalDirection() {
        switch (this.axis) {
            case X: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.Z);
                break;
            }
            case Y: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.X);
                break;
            }
            case Z: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.Y);
                break;
            }
        }
    }

    @Override
    public void writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        LittleTileVec axisPointBackup = this.doubledRelativeAxis.copy();
        LittleTileVec vec = new LittleTileVec((Vec3i)newCenter);
        vec.scale(2);
        this.doubledRelativeAxis.sub(vec);
        vec = new LittleTileVec((Vec3i)this.getMainTile().te.func_174877_v());
        vec.scale(2);
        this.doubledRelativeAxis.add(vec);
        vec = this.getMainTile().getMinVec();
        vec.scale(2);
        this.doubledRelativeAxis.add(vec);
        super.writeToNBTPreview(nbt, newCenter);
        this.doubledRelativeAxis = axisPointBackup;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleDoorBase parseStructure(SubGui gui, int duration) {
        LittleDoor door = new LittleDoor();
        GuiTileViewer viewer = (GuiTileViewer)gui.get("tileviewer");
        door.doubledRelativeAxis = new LittleTileVec(viewer.axisX, viewer.axisY, viewer.axisZ);
        door.axis = viewer.axisDirection;
        door.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)viewer.normalAxis);
        door.duration = duration;
        return door;
    }

    @Override
    public LittleDoorBase copyToPlaceDoor() {
        LittleDoor structure = new LittleDoor();
        structure.doubledRelativeAxis = new LittleTileVec(0, 0, 0);
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        structure.axis = this.axis;
        structure.normalDirection = this.normalDirection;
        structure.duration = this.duration;
        return structure;
    }

    @Override
    public ArrayList<PlacePreviewTile> getAdditionalPreviews() {
        ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
        previews.add(new PlacePreviewTileAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), null, this.axis, this.getAdditionalAxisVec()));
        return previews;
    }
}

