/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.world.WorldFake;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceRelative;
import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.rotation.DoorTransformation;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleDoorBase
extends LittleStructure {
    public boolean isWaitingForApprove = false;
    public int duration = 50;

    @Override
    public void onUpdatePacketReceived() {
        this.isWaitingForApprove = false;
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.duration = nbt.func_74764_b("duration") ? nbt.func_74762_e("duration") : 50;
        this.isWaitingForApprove = false;
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        nbt.func_74768_a("duration", this.duration);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createControls(SubGui gui, LittleStructure structure) {
        gui.controls.add(new GuiLabel("Duration:", 0, 141));
        gui.controls.add(new GuiSteppedSlider("duration_s", 50, 140, 50, 12, structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).duration : 50, 1, 500));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public LittleStructure parseStructure(SubGui gui) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("duration_s");
        return this.parseStructure(gui, (int)slider.value);
    }

    public boolean place(World world, LittleDoorBase structure, EntityPlayer player, ArrayList<PlacePreviewTile> previews, BlockPos pos, DoorTransformation transformation, UUID uuid, LittleTileVec absolute, LittleTileVec additional) {
        HashMapList<BlockPos, PlacePreviewTile> splitted = LittleActionPlaceRelative.getSplittedTiles(previews, pos);
        if (LittleActionPlaceRelative.canPlaceTiles(player, world, splitted, new ArrayList<BlockPos>(splitted.getKeys()), false)) {
            ArrayList<TileEntityLittleTiles> blocks = new ArrayList<TileEntityLittleTiles>();
            WorldFake fakeWorld = WorldFake.createFakeWorld((World)world);
            LittleActionPlaceRelative.placeTiles((World)fakeWorld, player, previews, structure, false, pos, null, null, false, EnumFacing.EAST);
            for (TileEntity te : fakeWorld.field_147482_g) {
                if (!(te instanceof TileEntityLittleTiles)) continue;
                blocks.add((TileEntityLittleTiles)te);
            }
            EntityDoorAnimation animation = new EntityDoorAnimation(world, pos, structure, blocks, previews, absolute, transformation, uuid, player, additional);
            world.func_72838_d((Entity)animation);
            return true;
        }
        return false;
    }

    public abstract LittleTileVec getAbsoluteAxisVec();

    public abstract LittleTileVec getAdditionalAxisVec();

    public abstract ArrayList<PlacePreviewTile> getAdditionalPreviews();

    @SideOnly(value=Side.CLIENT)
    public abstract LittleDoorBase parseStructure(SubGui var1, int var2);

    public abstract LittleDoorBase copyToPlaceDoor();
}

