/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.InventoryUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.BlockStorageTile;
import com.creativemd.littletiles.common.gui.SubGuiStructure;
import com.creativemd.littletiles.common.gui.handler.LittleGuiHandler;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittleStorage
extends LittleStructure {
    public static int slotsPerTileSize = 1;
    public static int maxSlotStackSize = 64;
    public int inventorySize = 0;
    public int stackSizeLimit = 0;
    public int numberOfSlots = 0;
    public int lastSlotStackSize = 0;
    public IInventory inventory = null;
    public boolean invisibleStorageTiles = false;

    public void updateNumberOfSlots() {
        float slots = (float)this.inventorySize / (float)this.stackSizeLimit;
        this.numberOfSlots = (int)Math.ceil(slots);
        this.lastSlotStackSize = (int)(slots % 1.0f * (float)this.stackSizeLimit);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        this.inventorySize = nbt.func_74762_e("inventorySize");
        this.stackSizeLimit = nbt.func_74762_e("stackSizeLimit");
        this.numberOfSlots = nbt.func_74762_e("numberOfSlots");
        this.lastSlotStackSize = nbt.func_74762_e("lastSlot");
        if (nbt.func_74764_b("inventory")) {
            this.inventory = InventoryUtils.loadInventoryBasic((NBTTagCompound)nbt.func_74775_l("inventory"));
        }
        this.invisibleStorageTiles = nbt.func_74767_n("invisibleStorage");
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        if (this.inventory != null) {
            nbt.func_74768_a("inventorySize", this.inventorySize);
            nbt.func_74768_a("stackSizeLimit", this.stackSizeLimit);
            nbt.func_74768_a("numberOfSlots", this.numberOfSlots);
            nbt.func_74768_a("lastSlot", this.lastSlotStackSize);
            nbt.func_74782_a("inventory", (NBTBase)InventoryUtils.saveInventoryBasic((IInventory)this.inventory));
        }
        nbt.func_74757_a("invisibleStorage", this.invisibleStorageTiles);
    }

    @Override
    public ItemStack getStructureDrop() {
        ItemStack stack = super.getStructureDrop();
        this.writeToNBTExtra(stack.func_77978_p().func_74775_l("structure"));
        return stack;
    }

    public static int getSizeOfInventory(List<LittleTilePreview> previews) {
        int size = 0;
        String name = LittleTiles.storageBlock.getRegistryName().toString();
        for (int i = 0; i < previews.size(); ++i) {
            if (!previews.get(i).getPreviewBlockName().equals(name)) continue;
            size += previews.get((int)i).box.getSize().getVolume() * slotsPerTileSize;
        }
        return size;
    }

    @Override
    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            LittleGuiHandler.openGui("littleStorageStructure", new NBTTagCompound(), playerIn, this.getMainTile());
        }
        return true;
    }

    @Override
    public void createControls(SubGui gui, LittleStructure structure) {
        gui.controls.add(new GuiLabel("space: " + LittleStorage.getSizeOfInventory(LittleTilePreview.getPreview(((SubGuiStructure)gui).stack)), 5, 30));
        boolean invisible = false;
        if (structure instanceof LittleStorage) {
            invisible = ((LittleStorage)structure).invisibleStorageTiles;
        }
        gui.controls.add(new GuiCheckBox("invisible", "invisible storage tiles", 5, 45, invisible));
    }

    @Override
    public LittleStructure parseStructure(SubGui gui) {
        LittleStorage storage = new LittleStorage();
        storage.invisibleStorageTiles = ((GuiCheckBox)gui.get((String)"invisible")).value;
        List<LittleTilePreview> previews = LittleTilePreview.getPreview(((SubGuiStructure)gui).stack);
        for (int i = 0; i < previews.size(); ++i) {
            if (!(previews.get(i).getPreviewBlock() instanceof BlockStorageTile)) continue;
            previews.get(i).setInvisibile(storage.invisibleStorageTiles);
        }
        LittleTilePreview.savePreviewTiles(previews, ((SubGuiStructure)gui).stack);
        storage.inventorySize = LittleStorage.getSizeOfInventory(previews);
        storage.stackSizeLimit = maxSlotStackSize;
        storage.updateNumberOfSlots();
        storage.inventory = new InventoryBasic("basic", false, storage.numberOfSlots);
        return storage;
    }
}

