/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.structure.LittleChair;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleFixedStructure;
import com.creativemd.littletiles.common.structure.LittleLadder;
import com.creativemd.littletiles.common.structure.LittleNoClipStructure;
import com.creativemd.littletiles.common.structure.LittleSlidingDoor;
import com.creativemd.littletiles.common.structure.LittleStorage;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileRelativeCoord;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleStructure {
    private static HashMap<String, LittleStructureEntry> structures = new HashMap();
    private LittleTile mainTile;
    protected HashMapList<TileEntityLittleTiles, LittleTile> tiles = null;
    public HashMap<BlockPos, Integer> tilesToLoad = null;

    public static ArrayList<String> getStructureNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : structures.keySet()) {
            result.add(id);
        }
        return result;
    }

    public static void registerLittleStructure(String id, LittleStructure structure) {
        LittleStructure.registerLittleStructure(id, new LittleStructureEntry(structure.getClass(), structure));
    }

    public static void registerLittleStructure(String id, LittleStructureEntry entry) {
        if (structures.containsKey(id)) {
            System.out.println("ID is already taken! id=" + id);
        } else if (structures.containsValue(entry)) {
            System.out.println("Already registered class=" + entry);
        } else {
            structures.put(id, entry);
        }
    }

    public static String getIDByClass(Class<? extends LittleStructure> classStructure) {
        for (String id : structures.keySet()) {
            if (!classStructure.equals(LittleStructure.structures.get((Object)id).structureClass)) continue;
            return id;
        }
        return "";
    }

    public static Class<? extends LittleStructure> getClassByID(String id) {
        LittleStructureEntry entry = structures.get(id);
        if (entry != null) {
            return entry.structureClass;
        }
        return null;
    }

    public static LittleStructureEntry getEntryByID(String id) {
        return structures.get(id);
    }

    public static void initStructures() {
        LittleStructure.registerLittleStructure("fixed", new LittleFixedStructure());
        LittleStructure.registerLittleStructure("chair", new LittleChair());
        LittleStructure.registerLittleStructure("door", new LittleDoor());
        LittleStructure.registerLittleStructure("slidingDoor", new LittleSlidingDoor());
        LittleStructure.registerLittleStructure("ladder", new LittleLadder());
        LittleStructure.registerLittleStructure("bed", new LittleBed());
        LittleStructure.registerLittleStructure("storage", new LittleStorage());
        LittleStructure.registerLittleStructure("noclip", new LittleNoClipStructure());
    }

    public static LittleStructure createAndLoadStructure(NBTTagCompound nbt, LittleTile mainTile) {
        Class<? extends LittleStructure> classStructure;
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureEntry entry = LittleStructure.getEntryByID(id);
        if (entry != null && (classStructure = entry.structureClass) != null) {
            LittleStructure structure = null;
            try {
                structure = classStructure.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Found invalid structureID=" + id);
            }
            structure.mainTile = mainTile;
            structure.loadFromNBT(nbt);
            return structure;
        }
        return null;
    }

    public void updateStructure() {
        this.mainTile.te.updateBlock();
    }

    public void setMainTile(LittleTile tile) {
        this.mainTile = tile;
        this.mainTile.isMainBlock = true;
        this.mainTile.coord = null;
        this.mainTile.te.updateBlock();
        if (!this.containsTile(tile)) {
            this.addTile(tile);
        }
        for (Map.Entry entry : this.tiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).func_145831_w().func_175646_b(((TileEntityLittleTiles)entry.getKey()).func_174877_v(), (TileEntity)entry.getKey());
            for (LittleTile stTile : (ArrayList)entry.getValue()) {
                if (stTile == this.mainTile) continue;
                stTile.isMainBlock = false;
                stTile.coord = this.getMainTileCoord(stTile);
            }
        }
    }

    public LittleTileRelativeCoord getMainTileCoord(LittleTile tile) {
        return new LittleTileRelativeCoord((TileEntity)tile.te, this.mainTile.te.func_174877_v(), this.mainTile.getIdentifier());
    }

    public boolean hasMainTile() {
        return this.mainTile != null;
    }

    public void moveStructure(EnumFacing facing) {
    }

    public void combineTiles() {
        if (!this.hasLoaded()) {
            return;
        }
        Object pos = null;
        Iterator iterator = this.tiles.getKeys().iterator();
        while (iterator.hasNext()) {
            ((TileEntityLittleTiles)iterator.next()).combineTiles(this);
        }
    }

    public void selectMainTile() {
        LittleTile first;
        if (this.hasLoaded() && (first = (LittleTile)this.tiles.getFirst()) != null) {
            this.setMainTile(first);
        }
    }

    public LittleTile getMainTile() {
        return this.mainTile;
    }

    public void setTiles(HashMapList<TileEntityLittleTiles, LittleTile> tiles) {
        this.tiles = tiles;
    }

    public boolean LoadList() {
        if (this.tiles == null) {
            return this.loadTiles();
        }
        return true;
    }

    public boolean containsTile(LittleTile tile) {
        return this.tiles.contains((Object)tile.te, (Object)tile);
    }

    public HashMapList<TileEntityLittleTiles, LittleTile> copyOfTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            return new HashMapList();
        }
        return new HashMapList(this.tiles);
    }

    public Iterator<LittleTile> getTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            return new Iterator<LittleTile>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public LittleTile next() {
                    return null;
                }
            };
        }
        return this.tiles.iterator();
    }

    public void removeTile(LittleTile tile) {
        if (this.tiles != null) {
            this.tiles.removeValue((Object)tile.te, (Object)tile);
        }
    }

    public void addTile(LittleTile tile) {
        this.tiles.add((Object)tile.te, (Object)tile);
    }

    public boolean hasLoaded() {
        this.loadTiles();
        return this.mainTile != null && this.tiles != null && (this.tilesToLoad == null || this.tilesToLoad.size() == 0);
    }

    public boolean loadTiles() {
        if (this.mainTile != null) {
            if (this.tiles == null) {
                this.tiles = new HashMapList();
                this.addTile(this.mainTile);
            }
            if (this.tilesToLoad == null) {
                return true;
            }
            Iterator<Map.Entry<BlockPos, Integer>> iterator = this.tilesToLoad.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Integer> entry = iterator.next();
                if (!this.checkForTiles(this.mainTile.te.func_145831_w(), entry.getKey(), entry.getValue())) continue;
                iterator.remove();
            }
            if (!this.tiles.contains((Object)this.mainTile)) {
                this.addTile(this.mainTile);
            }
            if (this.tilesToLoad.size() == 0) {
                this.tilesToLoad = null;
            }
            return true;
        }
        return false;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        if (this.tiles != null) {
            this.tiles.clear();
        }
        this.tilesToLoad = new HashMap();
        if (nbt.func_74764_b("count")) {
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                LittleTile.LittleTilePosition pos;
                LittleTileRelativeCoord coord = null;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleTileRelativeCoord((TileEntity)this.mainTile.te, pos.coord, new int[]{pos.position.x, pos.position.y, pos.position.z});
                } else {
                    coord = new LittleTileRelativeCoord("i" + i, nbt);
                }
                pos = coord.getAbsolutePosition((TileEntity)this.mainTile.te);
                Integer insideBlock = this.tilesToLoad.get(pos);
                insideBlock = insideBlock == null ? new Integer(1) : Integer.valueOf(insideBlock + 1);
                this.tilesToLoad.put((BlockPos)pos, insideBlock);
            }
        } else if (nbt.func_74764_b("tiles")) {
            NBTTagList list = nbt.func_150295_c("tiles", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                if (array.length == 4) {
                    LittleTilePos pos = new LittleTilePos(array);
                    this.tilesToLoad.put(pos.getAbsolutePos((TileEntity)this.mainTile.te), array[3]);
                    continue;
                }
                System.out.println("Found invalid array! " + nbt);
            }
        }
        this.loadFromNBTExtra(nbt);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public void writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        nbt.func_74778_a("id", this.getIDOfStructure());
        this.writeToNBTExtra(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.getIDOfStructure());
        HashMap<BlockPos, Integer> positions = new HashMap<BlockPos, Integer>();
        if (this.tiles != null) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                if (((ArrayList)entry.getValue()).size() <= 0) continue;
                positions.put(((TileEntityLittleTiles)entry.getKey()).func_174877_v(), ((ArrayList)entry.getValue()).size());
            }
        }
        if (this.tilesToLoad != null) {
            positions.putAll(this.tilesToLoad);
        }
        if (positions.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (Map.Entry entry : positions.entrySet()) {
                LittleTilePos pos = new LittleTilePos((TileEntity)this.mainTile.te, (BlockPos)entry.getKey());
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.getRelativePos().func_177958_n(), pos.getRelativePos().func_177956_o(), pos.getRelativePos().func_177952_p(), (Integer)entry.getValue()}));
            }
            nbt.func_74782_a("tiles", (NBTBase)list);
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public boolean doesLinkToMainTile(LittleTile tile) {
        try {
            return tile == this.getMainTile() || !tile.isMainBlock && tile.coord.getAbsolutePosition((TileEntity)tile.te).equals((Object)this.mainTile.te.func_174877_v()) && this.mainTile.is(tile.coord.identifier);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean checkForTiles(World world, BlockPos pos, Integer expectedCount) {
        TileEntity tileEntity;
        Chunk chunk = world.func_175726_f(pos);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk) && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityLittleTiles) {
            if (!((TileEntityLittleTiles)tileEntity).hasLoaded()) {
                return false;
            }
            int found = 0;
            if (this.tiles.getKeys().contains(tileEntity)) {
                this.tiles.removeKey((Object)((TileEntityLittleTiles)tileEntity));
            }
            for (LittleTile tile : ((TileEntityLittleTiles)tileEntity).getTiles()) {
                if (!tile.isStructureBlock || tile.structure != this && !this.doesLinkToMainTile(tile)) continue;
                this.tiles.add((Object)((TileEntityLittleTiles)tileEntity), (Object)tile);
                tile.structure = this;
                ++found;
            }
            if (found == expectedCount) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldPlaceTile(LittleTile tile) {
        return true;
    }

    public ArrayList<PlacePreviewTile> getSpecialTiles() {
        return new ArrayList<PlacePreviewTile>();
    }

    public void onLittleTileDestroy() {
        if (this.hasLoaded()) {
            for (Map.Entry entry : this.tiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            }
        }
    }

    public ItemStack getStructureDrop() {
        if (this.hasLoaded()) {
            BlockPos pos = this.getMainTile().te.func_174877_v();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (TileEntityLittleTiles te : this.tiles.getKeys()) {
                x = Math.min(x, te.func_174877_v().func_177958_n());
                y = Math.min(y, te.func_174877_v().func_177956_o());
                z = Math.min(z, te.func_174877_v().func_177952_p());
            }
            pos = new BlockPos(x, y, z);
            ItemStack stack = new ItemStack(LittleTiles.multiTiles);
            ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
            Iterator<LittleTile> iterator = this.getTiles();
            while (iterator.hasNext()) {
                LittleTile tile = iterator.next();
                LittleTilePreview preview = tile.getPreviewTile();
                preview.box.addOffset((Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)pos));
                previews.add(preview);
            }
            LittleTilePreview.savePreviewTiles(previews, stack);
            NBTTagCompound structureNBT = new NBTTagCompound();
            this.writeToNBTPreview(structureNBT, pos);
            stack.func_77978_p().func_74782_a("structure", (NBTBase)structureNBT);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public HashMapList<BlockPos, LittleTile> getTilesSortedPerBlock() {
        HashMapList coords = new HashMapList();
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            coords.add((Object)tile.te.func_174877_v(), (Object)tile);
        }
        return coords;
    }

    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
    }

    public void onRotate(World world, EntityPlayer player, ItemStack stack, Rotation rotation, LittleTileVec doubledCenter) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void createControls(SubGui var1, LittleStructure var2);

    @SideOnly(value=Side.CLIENT)
    public abstract LittleStructure parseStructure(SubGui var1);

    public LittleTileSize getSize() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        HashMapList<BlockPos, LittleTile> coords = this.getTilesSortedPerBlock();
        if (coords.sizeOfValues() == 0) {
            return null;
        }
        for (BlockPos coord : coords.getKeys()) {
            ArrayList values = coords.getValues((Object)coord);
            for (int j = 0; j < values.size(); ++j) {
                LittleTileBox box = ((LittleTile)values.get(j)).getCompleteBox();
                minX = Math.min(minX, coord.func_177958_n() * LittleTile.gridSize + box.minX);
                minY = Math.min(minY, coord.func_177956_o() * LittleTile.gridSize + box.minY);
                minZ = Math.min(minZ, coord.func_177952_p() * LittleTile.gridSize + box.minZ);
                maxX = Math.max(maxX, coord.func_177958_n() * LittleTile.gridSize + box.maxX);
                maxY = Math.max(maxY, coord.func_177956_o() * LittleTile.gridSize + box.maxY);
                maxZ = Math.max(maxZ, coord.func_177952_p() * LittleTile.gridSize + box.maxZ);
            }
        }
        return new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ).getSize();
    }

    public LittleTileVec getHighestCenterPoint() {
        int minYPos = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxYPos = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        HashMapList<BlockPos, LittleTile> coords = this.getTilesSortedPerBlock();
        if (coords.sizeOfValues() == 0) {
            return null;
        }
        for (BlockPos coord : coords.getKeys()) {
            ArrayList values = coords.getValues((Object)coord);
            for (int j = 0; j < values.size(); ++j) {
                LittleTileBox box = ((LittleTile)values.get(j)).getCompleteBox();
                minX = Math.min(minX, coord.func_177958_n() * LittleTile.gridSize + box.minX);
                minY = Math.min(minY, coord.func_177956_o() * LittleTile.gridSize + box.minY);
                minZ = Math.min(minZ, coord.func_177952_p() * LittleTile.gridSize + box.minZ);
                maxX = Math.max(maxX, coord.func_177958_n() * LittleTile.gridSize + box.maxX);
                maxY = Math.max(maxY, coord.func_177956_o() * LittleTile.gridSize + box.maxY);
                maxZ = Math.max(maxZ, coord.func_177952_p() * LittleTile.gridSize + box.maxZ);
                minYPos = Math.min(minYPos, coord.func_177956_o());
                maxYPos = Math.max(maxYPos, coord.func_177956_o());
            }
        }
        int centerX = (int)Math.floor((double)(minX + maxX) / (double)LittleTile.gridSize / 2.0);
        int centerY = (int)Math.floor((double)(minY + maxY) / (double)LittleTile.gridSize / 2.0);
        int centerZ = (int)Math.floor((double)(minZ + maxZ) / (double)LittleTile.gridSize / 2.0);
        int centerTileX = (int)(Math.floor(minX + maxX) / 2.0) - centerX * LittleTile.gridSize;
        int centerTileY = (int)(Math.floor(minY + maxY) / 2.0) - centerY * LittleTile.gridSize;
        int centerTileZ = (int)(Math.floor(minZ + maxZ) / 2.0) - centerZ * LittleTile.gridSize;
        LittleTileVec position = new LittleTileVec((minX + maxX) / 2, minYPos * LittleTile.gridSize, (minZ + maxZ) / 2);
        for (int y = minYPos; y <= maxYPos; ++y) {
            ArrayList tilesInCenter = coords.getValues((Object)new BlockPos(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            LittleTileBox box = new LittleTileBox(centerTileX, LittleTile.minPos, centerTileZ, centerTileX + 1, LittleTile.maxPos, centerTileZ + 1);
            for (int i = 0; i < tilesInCenter.size(); ++i) {
                List<LittleTileBox> collision = ((LittleTile)tilesInCenter.get(i)).getCollisionBoxes();
                for (int j = 0; j < collision.size(); ++j) {
                    LittleTileBox littleBox = collision.get(j);
                    if (!LittleTileBox.intersectsWith(box, littleBox)) continue;
                    position.y = Math.max(y * LittleTile.gridSize + littleBox.maxY, position.y);
                }
            }
        }
        return position;
    }

    public String getIDOfStructure() {
        return LittleStructure.getIDByClass(this.getClass());
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return false;
    }

    public boolean isLadder() {
        return false;
    }

    public boolean noCollisionBoxes() {
        return false;
    }

    public boolean shouldCheckForCollision() {
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public void onUpdatePacketReceived() {
    }

    public void removeWorldProperties() {
        this.mainTile = null;
        this.tiles = new HashMapList();
        this.tilesToLoad = null;
    }

    public static class LittleStructureEntry {
        public Class<? extends LittleStructure> structureClass;
        public LittleStructure parser;

        public LittleStructureEntry(Class<? extends LittleStructure> structureClass, LittleStructure parser) {
            this.structureClass = structureClass;
            this.parser = parser;
        }

        public boolean equals(Object object) {
            return object instanceof LittleStructureEntry && ((LittleStructureEntry)object).structureClass == this.structureClass;
        }

        public String toString() {
            return this.structureClass.toString();
        }
    }
}

