/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PlacePreviewTileAxis
extends PlacePreviewTile {
    public static int red = ColorUtils.VecToInt((Vec3d)new Vec3d(1.0, 0.0, 0.0));
    public EnumFacing.Axis axis;
    public LittleTileVec additionalOffset;

    public PlacePreviewTileAxis(LittleTileBox box, LittleTilePreview preview, EnumFacing.Axis axis, LittleTileVec additionalOffset) {
        super(box, preview);
        this.axis = axis;
        this.additionalOffset = additionalOffset;
    }

    @Override
    public boolean needsCollisionTest() {
        return false;
    }

    @Override
    public PlacePreviewTile copy() {
        return new PlacePreviewTileAxis(this.box.copy(), null, this.axis, this.additionalOffset.copy());
    }

    @Override
    public List<LittleRenderingCube> getPreviews() {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        LittleTileBox preview = this.box.copy();
        int max = 40 * LittleTile.gridSize;
        int min = -max;
        switch (this.axis) {
            case X: {
                preview.minX = min;
                preview.maxX = max;
                break;
            }
            case Y: {
                preview.minY = min;
                preview.maxY = max;
                break;
            }
            case Z: {
                preview.minZ = min;
                preview.maxZ = max;
                break;
            }
        }
        LittleRenderingCube cube = preview.getRenderingCube(null, 0);
        cube.sub(new Vec3d(LittleTile.gridMCLength / 2.0, LittleTile.gridMCLength / 2.0, LittleTile.gridMCLength / 2.0));
        cube.add(this.additionalOffset.getVec().func_186678_a(0.5));
        cube.color = red;
        cubes.add(cube);
        return cubes;
    }

    @Override
    public List<LittleTile> placeTile(EntityPlayer player, ItemStack stack, BlockPos pos, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing, boolean requiresCollisionTest) {
        if (structure instanceof LittleDoor) {
            LittleDoor door = (LittleDoor)structure;
            door.doubledRelativeAxis = this.box.getMinVec();
            door.doubledRelativeAxis.add((Vec3i)pos);
            if (door.getMainTile() == null) {
                door.selectMainTile();
            }
            if (door.getMainTile() != null) {
                door.doubledRelativeAxis.sub(door.getMainTile().getAbsoluteCoordinates());
            }
            door.doubledRelativeAxis.scale(2);
            door.doubledRelativeAxis.add(this.additionalOffset);
        }
        return Collections.EMPTY_LIST;
    }
}

