/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.BlockLayerRenderBuffer;
import com.creativemd.littletiles.client.render.LittleChunkDispatcher;
import com.creativemd.littletiles.client.render.RenderCubeLayerCache;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.common.api.te.ILittleTileTE;
import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.utils.nbt.LittleNBTCompressionTools;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLittleTiles
extends TileEntityCreative
implements ITickable,
ILittleTileTE {
    private CopyOnWriteArrayList<LittleTile> tiles = TileEntityLittleTiles.createTileList();
    private CopyOnWriteArrayList<LittleTile> updateTiles = TileEntityLittleTiles.createTileList();
    @SideOnly(value=Side.CLIENT)
    private CopyOnWriteArrayList<LittleTile> renderTiles;
    private boolean hasLoaded = false;
    @SideOnly(value=Side.CLIENT)
    public int renderIndex;
    @SideOnly(value=Side.CLIENT)
    public boolean hasLightChanged;
    @SideOnly(value=Side.CLIENT)
    public boolean hasNeighborChanged;
    public int collisionChecks = 0;
    @SideOnly(value=Side.CLIENT)
    public EntityDoorAnimation waitingAnimation;
    @SideOnly(value=Side.CLIENT)
    public RenderChunk lastRenderedChunk;
    @SideOnly(value=Side.CLIENT)
    private AtomicReference<BlockLayerRenderBuffer> buffer;
    @SideOnly(value=Side.CLIENT)
    private RenderCubeLayerCache cubeCache;
    private static Field processingLoadedTiles = ReflectionHelper.findField(World.class, (String[])new String[]{"processingLoadedTiles", "field_147481_N"});
    @SideOnly(value=Side.CLIENT)
    public AtomicBoolean rendering;
    @SideOnly(value=Side.CLIENT)
    private double cachedRenderDistance;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB cachedRenderBoundingBox;
    @SideOnly(value=Side.CLIENT)
    private boolean requireRenderingBoundingBoxUpdate;
    public boolean preventUpdate = false;
    public boolean ticking = true;

    public static CopyOnWriteArrayList<LittleTile> createTileList() {
        return new CopyOnWriteArrayList<LittleTile>();
    }

    @SideOnly(value=Side.CLIENT)
    public CopyOnWriteArrayList<LittleTile> getRenderTiles() {
        if (this.renderTiles == null) {
            this.renderTiles = TileEntityLittleTiles.createTileList();
        }
        return this.renderTiles;
    }

    public CopyOnWriteArrayList<LittleTile> getTiles() {
        return this.tiles;
    }

    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    public void setLoaded() {
        this.hasLoaded = true;
    }

    public boolean shouldCheckForCollision() {
        return this.collisionChecks > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateQuadCache(RenderChunk chunk) {
        this.lastRenderedChunk = chunk;
        if (this.renderIndex != LittleChunkDispatcher.currentRenderIndex.get()) {
            this.getCubeCache().clearCache();
        }
        if (this.waitingAnimation != null && !this.getCubeCache().doesNeedUpdate()) {
            this.waitingAnimation.removeWaitingTe(this);
            this.waitingAnimation = null;
        }
        boolean doesNeedUpdate = this.getCubeCache().doesNeedUpdate() || this.hasNeighborChanged || this.hasLightChanged;
        this.hasLightChanged = false;
        this.hasNeighborChanged = false;
        if (doesNeedUpdate) {
            this.addToRenderUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setBuffer(BlockLayerRenderBuffer buffer) {
        if (this.buffer == null) {
            this.buffer = new AtomicReference<BlockLayerRenderBuffer>(buffer);
        } else {
            this.buffer.set(buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockLayerRenderBuffer getBuffer() {
        if (this.buffer == null) {
            this.buffer = new AtomicReference<Object>(null);
        }
        return this.buffer.get();
    }

    public RenderCubeLayerCache getCubeCache() {
        if (this.cubeCache == null) {
            this.cubeCache = new RenderCubeLayerCache();
        }
        return this.cubeCache;
    }

    private boolean removeLittleTile(LittleTile tile) {
        boolean result = this.tiles.remove(tile);
        this.updateTiles.remove(tile);
        if (this.isClientSide()) {
            this.removeLittleTileClient(tile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void removeLittleTileClient(LittleTile tile) {
        CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.getRenderTiles();
        synchronized (copyOnWriteArrayList) {
            this.getRenderTiles().remove(tile);
        }
    }

    public void removeTiles(Collection<LittleTile> tiles) {
        for (LittleTile tile : tiles) {
            this.removeLittleTile(tile);
        }
        this.updateTiles();
    }

    public boolean removeTile(LittleTile tile) {
        boolean result = this.removeLittleTile(tile);
        this.updateTiles();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void addLittleTileClient(LittleTile tile) {
        if (tile.needCustomRendering()) {
            CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.getRenderTiles();
            synchronized (copyOnWriteArrayList) {
                this.getRenderTiles().add(tile);
            }
        }
    }

    private boolean addLittleTile(LittleTile tile) {
        if (this.isClientSide()) {
            this.addLittleTileClient(tile);
        }
        if (tile.shouldTick()) {
            this.updateTiles.add(tile);
        }
        return this.tiles.add(tile);
    }

    public void addTiles(Collection<LittleTile> tiles) {
        for (LittleTile tile : tiles) {
            this.addLittleTile(tile);
        }
        this.updateTiles();
    }

    public boolean addTile(LittleTile tile) {
        boolean result = this.addLittleTile(tile);
        this.updateTiles();
        return result;
    }

    public void updateLighting() {
        this.field_145850_b.func_175664_x(this.func_174877_v());
    }

    @SideOnly(value=Side.CLIENT)
    private void clientCustomUpdate(Runnable run) {
        Minecraft.func_71410_x().func_152344_a(run);
    }

    private void customTilesUpdate() {
        if (this.updateTiles.isEmpty() == this.ticking) {
            try {
                if (!processingLoadedTiles.getBoolean(this.field_145850_b)) {
                    if (!WorldUtils.isMainThread((World)this.field_145850_b)) {
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                if (TileEntityLittleTiles.this.updateTiles.isEmpty()) {
                                    ((TileEntityLittleTiles)TileEntityLittleTiles.this).field_145850_b.field_175730_i.remove(TileEntityLittleTiles.this);
                                } else {
                                    ((TileEntityLittleTiles)TileEntityLittleTiles.this).field_145850_b.field_175730_i.add(TileEntityLittleTiles.this);
                                }
                            }
                        };
                        if (this.field_145850_b.field_72995_K) {
                            this.clientCustomUpdate(run);
                        } else {
                            this.field_145850_b.func_73046_m().func_152344_a(run);
                        }
                    } else if (this.updateTiles.isEmpty()) {
                        this.field_145850_b.field_175730_i.remove(this);
                    } else {
                        this.field_145850_b.field_175730_i.add(this);
                    }
                    this.ticking = !this.updateTiles.isEmpty();
                } else {
                    System.out.println("Could not remove/add ticking tileentity.");
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateTiles() {
        if (this.preventUpdate) {
            return;
        }
        this.updateCollisionCache();
        if (this.field_145850_b != null) {
            this.updateBlock();
            this.updateNeighbor();
            this.updateLighting();
        }
        if (this.isClientSide()) {
            this.updateCustomRenderer();
        }
        this.customTilesUpdate();
        if (!this.field_145850_b.field_72995_K && this.tiles.size() == 0) {
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateCustomRenderer() {
        this.updateRenderBoundingBox();
        this.updateRenderDistance();
        this.getCubeCache().clearCache();
        this.addToRenderUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public void onNeighBorChangedClient() {
        this.addToRenderUpdate();
        this.hasNeighborChanged = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addToRenderUpdate() {
        if (this.rendering == null) {
            this.rendering = new AtomicBoolean(false);
        }
        if (!this.rendering.get()) {
            RenderingThread.addCoordToUpdate(this);
        }
    }

    public boolean convertBlockToVanilla() {
        LittleTile firstTile = null;
        if (this.tiles.isEmpty()) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
            return true;
        }
        if (this.tiles.size() == 1) {
            if (this.tiles.get(0).canBeConvertedToVanilla() && !this.tiles.get(0).doesFillEntireBlock()) {
                return false;
            }
            firstTile = this.tiles.get(0);
        } else {
            boolean[][][] filled = new boolean[LittleTile.gridSize][LittleTile.gridSize][LittleTile.gridSize];
            for (LittleTile tile : this.tiles) {
                if (firstTile == null) {
                    if (tile.getClass() != LittleTileBlock.class) {
                        return false;
                    }
                    firstTile = tile;
                } else if (!firstTile.canBeCombined(tile) || !tile.canBeCombined(firstTile)) {
                    return false;
                }
                tile.fillInSpace(filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, ((LittleTileBlock)firstTile).getBlockState());
        return true;
    }

    public boolean isBoxFilled(LittleTileBox box) {
        LittleTileSize size = box.getSize();
        boolean[][][] filled = new boolean[size.sizeX][size.sizeY][size.sizeZ];
        for (LittleTile tile : this.tiles) {
            tile.fillInSpace(box, filled);
        }
        for (int x = 0; x < filled.length; ++x) {
            for (int y = 0; y < filled[x].length; ++y) {
                for (int z = 0; z < filled[x][y].length; ++z) {
                    if (filled[x][y][z]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void updateNeighbor() {
        for (LittleTile tile : this.updateTiles) {
            tile.onNeighborChangeInside();
        }
        if (this.isClientSide()) {
            this.hasNeighborChanged = true;
        }
        this.field_145850_b.func_175685_c(this.func_174877_v(), (Block)LittleTiles.blockTile, true);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 && this.getRenderTiles().size() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderDistance() {
        this.cachedRenderDistance = 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        if (this.cachedRenderDistance == 0.0) {
            double renderDistance = 262144.0;
            for (LittleTile tile : this.getRenderTiles()) {
                renderDistance = Math.max(renderDistance, tile.getMaxRenderDistanceSquared());
            }
            this.cachedRenderDistance = renderDistance;
        }
        return this.cachedRenderDistance;
    }

    public boolean hasFastRenderer() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateRenderBoundingBox() {
        this.requireRenderingBoundingBoxUpdate = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.requireRenderingBoundingBoxUpdate || this.cachedRenderBoundingBox == null) {
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = Double.MIN_VALUE;
            double maxY = Double.MIN_VALUE;
            double maxZ = Double.MIN_VALUE;
            boolean found = false;
            for (LittleTile tile : this.tiles) {
                if (!tile.needCustomRendering()) continue;
                AxisAlignedBB box = tile.getRenderBoundingBox().func_186670_a(this.field_174879_c);
                minX = Math.min(box.field_72340_a, minX);
                minY = Math.min(box.field_72338_b, minY);
                minZ = Math.min(box.field_72339_c, minZ);
                maxX = Math.max(box.field_72336_d, maxX);
                maxY = Math.max(box.field_72337_e, maxY);
                maxZ = Math.max(box.field_72334_f, maxZ);
                found = true;
            }
            this.cachedRenderBoundingBox = found ? new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ) : new AxisAlignedBB(this.field_174879_c);
            this.requireRenderingBoundingBoxUpdate = false;
        }
        return this.cachedRenderBoundingBox;
    }

    public AxisAlignedBB getSelectionBox() {
        int minX = LittleTile.gridSize;
        int minY = LittleTile.gridSize;
        int minZ = LittleTile.gridSize;
        int maxX = LittleTile.minPos;
        int maxY = LittleTile.minPos;
        int maxZ = LittleTile.minPos;
        for (LittleTile tile : this.tiles) {
            LittleTileBox box = tile.getCompleteBox();
            minX = Math.min(box.minX, minX);
            minY = Math.min(box.minY, minY);
            minZ = Math.min(box.minZ, minZ);
            maxX = Math.max(box.maxX, maxX);
            maxY = Math.max(box.maxY, maxY);
            maxZ = Math.max(box.maxZ, maxZ);
        }
        return new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ).getBox(this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing facing, LittleTileBox.LittleTileFace face, LittleTile rendered) {
        for (LittleTile tile : this.tiles) {
            if (tile == rendered || !tile.doesProvideSolidFace(facing) && !tile.canBeRenderCombined(rendered)) continue;
            tile.fillFace(face);
        }
        return !face.isFilled();
    }

    public boolean isSpaceForLittleTile(LittleTileBox box) {
        for (LittleTile tile : this.tiles) {
            if (!tile.intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public boolean isSpaceForLittleTile(LittleTileBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            if (ignoreTile == tile || !tile.intersectsWith(box)) continue;
            return false;
        }
        return true;
    }

    public LittleTile getIntersectingTile(LittleTileBox box, LittleTile ignoreTile) {
        for (LittleTile tile : this.tiles) {
            if (ignoreTile == tile || !tile.intersectsWith(box)) continue;
            return tile;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.tiles != null) {
            this.tiles.clear();
        }
        if (this.updateTiles != null) {
            this.updateTiles.clear();
        }
        this.collisionChecks = 0;
        this.preventUpdate = true;
        if (nbt.func_74764_b("tilesCount")) {
            int count = nbt.func_74762_e("tilesCount");
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tileNBT = new NBTTagCompound();
                tileNBT = nbt.func_74775_l("t" + i);
                LittleTile tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT);
                if (tile == null) continue;
                this.addLittleTile(tile);
            }
        } else {
            List<LittleTile> tiles = LittleNBTCompressionTools.readTiles(nbt.func_150295_c("tiles", 10), this);
            for (int i = 0; i < tiles.size(); ++i) {
                this.addLittleTile(tiles.get(i));
            }
        }
        this.preventUpdate = false;
        if (this.field_145850_b != null) {
            this.updateBlock();
            this.customTilesUpdate();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("tiles", (NBTBase)LittleNBTCompressionTools.writeTiles(this.tiles));
        return nbt;
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        int i = 0;
        for (LittleTile tile : this.tiles) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            NBTTagCompound packet = new NBTTagCompound();
            tile.saveTile(tileNBT);
            if (tile.supportsUpdatePacket()) {
                if (tile.needsFullUpdate) {
                    tile.needsFullUpdate = false;
                } else {
                    tileNBT.func_74782_a("update", (NBTBase)tile.getUpdateNBT());
                }
            }
            nbt.func_74782_a("t" + i, (NBTBase)tileNBT);
            ++i;
        }
        nbt.func_74768_a("tilesCount", this.tiles.size());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdatePacket(net, pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdatePacket(NetworkManager net, NBTTagCompound nbt) {
        ArrayList<LittleTile> exstingTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> tilesToAdd = new ArrayList<LittleTile>();
        exstingTiles.addAll(this.tiles);
        int count = nbt.func_74762_e("tilesCount");
        for (int i = 0; i < count; ++i) {
            boolean isIdentical;
            NBTTagCompound tileNBT = new NBTTagCompound();
            tileNBT = nbt.func_74775_l("t" + i);
            NBTTagList list = tileNBT.func_150295_c("boxes", 11);
            LittleTile tile = null;
            if (list.func_74745_c() > 0) {
                tile = this.getTile(LittleTileBox.createBox(list.func_150306_c(0)).getIdentifier());
            }
            if (!exstingTiles.contains(tile)) {
                tile = null;
            }
            boolean bl = isIdentical = tile != null ? tile.isIdenticalToNBT(tileNBT) : false;
            if (isIdentical) {
                if (tile.supportsUpdatePacket() && tileNBT.func_74764_b("update")) {
                    tile.receivePacket(tileNBT.func_74775_l("update"), net);
                } else {
                    tile.loadTile(this, tileNBT);
                }
                exstingTiles.remove(tile);
                continue;
            }
            if (tile != null && tile.isLoaded()) {
                tile.structure.removeTile(tile);
            }
            if ((tile = LittleTile.CreateandLoadTile(this, this.field_145850_b, tileNBT)) == null) continue;
            tilesToAdd.add(tile);
        }
        CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList = this.tiles;
        synchronized (copyOnWriteArrayList) {
            CopyOnWriteArrayList<LittleTile> copyOnWriteArrayList2 = this.updateTiles;
            synchronized (copyOnWriteArrayList2) {
                int i;
                for (i = 0; i < exstingTiles.size(); ++i) {
                    if (((LittleTile)exstingTiles.get((int)i)).isStructureBlock && ((LittleTile)exstingTiles.get(i)).isLoaded()) {
                        ((LittleTile)exstingTiles.get((int)i)).structure.removeTile((LittleTile)exstingTiles.get(i));
                    }
                    this.removeLittleTile((LittleTile)exstingTiles.get(i));
                }
                for (i = 0; i < tilesToAdd.size(); ++i) {
                    this.addLittleTile((LittleTile)tilesToAdd.get(i));
                    if (!((LittleTile)tilesToAdd.get((int)i)).isStructureBlock) continue;
                    ((LittleTile)tilesToAdd.get(i)).checkForStructure();
                }
            }
        }
        this.updateTiles();
    }

    @SideOnly(value=Side.CLIENT)
    public void handleUpdateTag(NBTTagCompound nbt) {
        this.handleUpdatePacket(Minecraft.func_71410_x().func_147114_u().func_147298_b(), nbt);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.getDescriptionNBT(nbt);
        return nbt;
    }

    public LittleTile getTile(int[] identifier) {
        for (LittleTile tile : this.tiles) {
            if (!tile.is(identifier)) continue;
            return tile;
        }
        return null;
    }

    public RayTraceResult rayTrace(EntityPlayer player) {
        Object hit = null;
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.rayTrace(pos, vec32);
    }

    public RayTraceResult rayTrace(Vec3d pos, Vec3d look) {
        RayTraceResult hit = null;
        for (LittleTile tile : this.tiles) {
            RayTraceResult Temphit = tile.rayTrace(pos, look);
            if (Temphit == null || hit != null && !(hit.field_72307_f.func_72438_d(pos) > Temphit.field_72307_f.func_72438_d(pos))) continue;
            hit = Temphit;
        }
        return hit;
    }

    public LittleTile getFocusedTile(EntityPlayer player) {
        if (!this.isClientSide()) {
            return null;
        }
        Vec3d pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        Vec3d vec32 = pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
        return this.getFocusedTile(pos, vec32);
    }

    public LittleTile getFocusedTile(Vec3d pos, Vec3d look) {
        LittleTile tileFocus = null;
        RayTraceResult hit = null;
        double distance = 0.0;
        for (LittleTile tile : this.tiles) {
            RayTraceResult Temphit = tile.rayTrace(pos, look);
            if (Temphit == null || hit != null && !(distance > Temphit.field_72307_f.func_72438_d(pos))) continue;
            distance = Temphit.field_72307_f.func_72438_d(pos);
            hit = Temphit;
            tileFocus = tile;
        }
        return tileFocus;
    }

    public void onLoad() {
        this.setLoaded();
        this.customTilesUpdate();
    }

    public void func_73660_a() {
        if (this.updateTiles.isEmpty()) {
            System.out.println("Ticking tileentity which shouldn't " + this.field_174879_c);
            return;
        }
        for (LittleTile tile : this.updateTiles) {
            tile.updateEntity();
        }
    }

    public void combineTiles(LittleStructure structure) {
        BasicCombiner.combineTiles(this.tiles, structure);
        this.updateTiles();
    }

    public void updateCollisionCache() {
        this.collisionChecks = 0;
        for (LittleTile tile : this.tiles) {
            if (!tile.shouldCheckForCollision()) continue;
            ++this.collisionChecks;
        }
    }

    public void combineTiles() {
        TileEntityLittleTiles.combineTilesList(this.tiles);
        this.updateBlock();
        this.updateCollisionCache();
    }

    public static void combineTilesList(List<LittleTile> tiles) {
        BasicCombiner.combineTiles(tiles);
    }

    public boolean shouldTick() {
        return !this.updateTiles.isEmpty();
    }

    @Override
    @Optional.Method(modid="chiselsandbits")
    public Object getVoxelBlob(boolean force) throws Exception {
        return ChiselsAndBitsManager.getVoxelBlob(this, force);
    }
}

