/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.packet.LittleTileUpdatePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreviewHandler;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileRelativeCoord;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleTile {
    private static HashMap<Class<? extends LittleTile>, String> tileIDs = new HashMap();
    private static HashMap<String, Class<? extends LittleTile>> invTileIDs = new HashMap();
    private static HashMap<String, LittleTilePreviewHandler> previewHandlers = new HashMap();
    public static int gridSize = 16;
    public static int halfGridSize = gridSize / 2;
    public static double gridMCLength = 1.0 / (double)gridSize;
    public static int minPos = 0;
    public static int maxPos = gridSize;
    public static int maxTilesPerBlock = gridSize * gridSize * gridSize;
    public static double minimumTileSize = 1.0 / (double)maxTilesPerBlock;
    public boolean invisible = false;
    public boolean glowing = false;
    public TileEntityLittleTiles te;
    public LittleTileBox box;
    protected static Field playerInChunkMapEntry = ReflectionHelper.findField(PlayerChunkMapEntry.class, (String[])new String[]{"players", "field_187283_c"});
    public boolean needsFullUpdate = false;
    public boolean isStructureBlock = false;
    public LittleStructure structure;
    public LittleTileRelativeCoord coord;
    public boolean isMainBlock = false;
    protected boolean loadingStructure = false;
    public boolean isAllowedToSearchForStructure = true;

    public static void setGridSize(int size) {
        gridSize = size;
        halfGridSize = gridSize / 2;
        gridMCLength = 1.0 / (double)gridSize;
        minPos = 0;
        maxPos = gridSize;
        maxTilesPerBlock = gridSize * gridSize * gridSize;
        minimumTileSize = 1.0 / (double)maxTilesPerBlock;
    }

    public static Class<? extends LittleTile> getClassByID(String id) {
        return invTileIDs.get(id);
    }

    public static String getIDByClass(Class<? extends LittleTile> LittleClass) {
        return tileIDs.get(LittleClass);
    }

    public static LittleTilePreviewHandler getPreviewHandler(LittleTile tile) {
        return LittleTile.getPreviewHandler(tile.getID());
    }

    public static LittleTilePreviewHandler getPreviewHandler(String id) {
        return previewHandlers.get(id);
    }

    public static void registerLittleTile(Class<? extends LittleTile> LittleClass, String id, LittleTilePreviewHandler handler) {
        tileIDs.put(LittleClass, id);
        invTileIDs.put(id, LittleClass);
        previewHandlers.put(id, handler);
    }

    public static LittleTile CreateEmptyTile(String id) {
        Class<? extends LittleTile> TileClass = LittleTile.getClassByID(id);
        if (TileClass != null) {
            try {
                return TileClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Found invalid tileID=" + id);
            }
        }
        return null;
    }

    public static LittleTile CreateandLoadTile(TileEntityLittleTiles te, World world, NBTTagCompound nbt) {
        if (nbt.func_74764_b("tileID")) {
            if (nbt.func_74764_b("block")) {
                Block block = Block.func_149684_b((String)nbt.func_74779_i("block"));
                int meta = nbt.func_74762_e("meta");
                LittleTileBox box = new LittleTileBox(new LittleTileVec("i", nbt), new LittleTileVec("a", nbt));
                box.addOffset(new LittleTileVec(halfGridSize, halfGridSize, halfGridSize));
                LittleTileBlock tile = new LittleTileBlock(block, meta);
                tile.box = box;
                return tile;
            }
        } else {
            LittleTile tile = LittleTile.CreateEmptyTile(nbt.func_74779_i("tID"));
            if (tile != null) {
                try {
                    tile.loadTile(te, nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return tile;
        }
        return null;
    }

    public String getID() {
        return LittleTile.getIDByClass(this.getClass());
    }

    public abstract boolean canBeConvertedToVanilla();

    public LittleTileVec getAbsoluteCoordinates() {
        LittleTileVec coord = new LittleTileVec((Vec3i)this.te.func_174877_v());
        coord.add(this.box.getMinVec());
        return coord;
    }

    public LittleTileVec getMinVec() {
        return this.box.getMinVec();
    }

    public AxisAlignedBB getSelectedBox(BlockPos pos) {
        return this.box.getSelectionBox(pos);
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public double getPercentVolume() {
        return this.box.getPercentVolume();
    }

    public LittleTileSize getSize() {
        return this.box.getSize();
    }

    public boolean doesFillEntireBlock() {
        return this.box.doesFillEntireBlock();
    }

    public void fillFace(LittleTileBox.LittleTileFace face) {
        this.box.fill(face);
    }

    public void fillInSpace(boolean[][][] filled) {
        if (!this.box.isCompletelyFilled()) {
            return;
        }
        for (int x = this.box.minX; x < this.box.maxX; ++x) {
            for (int y = this.box.minY; y < this.box.maxY; ++y) {
                for (int z = this.box.minZ; z < this.box.maxZ; ++z) {
                    filled[x][y][z] = true;
                }
            }
        }
    }

    public void fillInSpace(LittleTileBox otherBox, boolean[][][] filled) {
        int minX = Math.max(this.box.minX, otherBox.minX);
        int maxX = Math.min(this.box.maxX, otherBox.maxX);
        int minY = Math.max(this.box.minY, otherBox.minY);
        int maxY = Math.min(this.box.maxY, otherBox.maxY);
        int minZ = Math.max(this.box.minZ, otherBox.minZ);
        int maxZ = Math.min(this.box.maxZ, otherBox.maxZ);
        if (this.box.isCompletelyFilled()) {
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                    }
                }
            }
        } else {
            LittleTileVec vec = new LittleTileVec(0, 0, 0);
            for (int x = minX; x < maxX; ++x) {
                for (int y = minY; y < maxY; ++y) {
                    for (int z = minZ; z < maxZ; ++z) {
                        vec.set(x, y, z);
                        if (!this.box.isVecInsideBox(vec)) continue;
                        filled[x - otherBox.minX][y - otherBox.minY][z - otherBox.minZ] = true;
                    }
                }
            }
        }
    }

    public final int[] getIdentifier() {
        return this.box.getIdentifier();
    }

    public boolean is(int[] identifier) {
        return this.box.is(identifier);
    }

    public boolean isAt(int x, int y, int z) {
        return this.box.isVecInsideBox(x, y, z);
    }

    public boolean intersectsWith(LittleTileBox box) {
        return LittleTileBox.intersectsWith(this.box, box);
    }

    public List<LittleTileBox> cutOut(LittleTileBox box) {
        return this.box.cutOut(box);
    }

    public List<LittleTileBox> cutOut(List<LittleTileBox> boxes, List<LittleTileBox> cutout) {
        return this.box.cutOut(boxes, cutout);
    }

    public LittleTileBox getCompleteBox() {
        return this.box;
    }

    public LittleTileVec getCenter() {
        return this.box.getCenter();
    }

    public RayTraceResult rayTrace(Vec3d pos, Vec3d look) {
        return this.box.calculateIntercept(this.te.func_174877_v(), pos, look);
    }

    public boolean canBeCombined(LittleTile tile) {
        if (this.isStructureBlock != tile.isStructureBlock) {
            return false;
        }
        if (this.isStructureBlock && this.structure != tile.structure) {
            return false;
        }
        if (this.invisible != tile.invisible) {
            return false;
        }
        return this.glowing == tile.glowing;
    }

    public boolean canBeSplitted() {
        return true;
    }

    public void combineTiles(LittleTile tile) {
        if (this.isLoaded()) {
            this.structure.removeTile(tile);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return !this.invisible;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        return this.invisible == tile.invisible;
    }

    public boolean sendUpdatePacketToClient() {
        if (this.supportsUpdatePacket()) {
            if (!this.te.func_145831_w().field_72995_K && this.te.func_145831_w() instanceof WorldServer) {
                PlayerChunkMap map = ((WorldServer)this.te.func_145831_w()).func_184164_w();
                ChunkPos pos = new ChunkPos(this.te.func_174877_v());
                PlayerChunkMapEntry entry = map.func_187301_b(pos.field_77276_a, pos.field_77275_b);
                try {
                    List players = (List)playerInChunkMapEntry.get(entry);
                    PacketHandler.sendPacketToPlayers((CreativeCorePacket)new LittleTileUpdatePacket(this, this.getUpdateNBT()), (List)players);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public boolean supportsUpdatePacket() {
        return false;
    }

    public NBTTagCompound getUpdateNBT() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
    }

    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return this.getID().equals(nbt.func_74779_i("tID")) && this.glowing == nbt.func_74767_n("glowing") && this.invisible == nbt.func_74767_n("invisible") && this.box.getArray().equals(nbt.func_74759_k("box"));
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTile(nbt);
        nbt.func_82580_o("box");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public boolean canBeNBTGrouped(LittleTile tile) {
        if (tile.canBeCombined(this) && this.canBeCombined(tile) && !tile.isMainBlock && !this.isMainBlock && this.coord != null && tile.coord != null) {
            return this.coord.identifier.equals(tile.coord.identifier);
        }
        return false;
    }

    public void groupNBTTile(NBTTagCompound nbt, LittleTile tile) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)tile.box.getNBTIntArray());
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            NBTTagList small = new NBTTagList();
            small.func_74742_a(list.func_179238_g(i));
            copy.func_74782_a("boxes", (NBTBase)small);
            tags.add(copy);
        }
        return tags;
    }

    public void saveTile(NBTTagCompound nbt) {
        this.saveTileCore(nbt);
        this.saveTileExtra(nbt);
    }

    public void saveTileExtra(NBTTagCompound nbt) {
        if (this.invisible) {
            nbt.func_74757_a("invisible", this.invisible);
        }
        if (this.glowing) {
            nbt.func_74757_a("glowing", this.glowing);
        }
    }

    public void saveTileCore(NBTTagCompound nbt) {
        nbt.func_74778_a("tID", this.getID());
        nbt.func_74783_a("box", this.box.getArray());
        if (this.isStructureBlock) {
            nbt.func_74757_a("isStructure", true);
            if (this.isMainBlock) {
                nbt.func_74757_a("main", true);
                this.structure.writeToNBT(nbt);
            } else {
                this.coord.writeToNBT(nbt);
            }
        }
    }

    public void loadTile(TileEntityLittleTiles te, NBTTagCompound nbt) {
        this.te = te;
        this.loadTileCore(nbt);
        this.loadTileExtra(nbt);
    }

    public void loadTileExtra(NBTTagCompound nbt) {
        this.invisible = nbt.func_74767_n("invisible");
        this.glowing = nbt.func_74767_n("glowing");
    }

    public void loadTileCore(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bSize")) {
            int count = nbt.func_74762_e("bSize");
            this.box = LittleTileBox.loadBox("bBox0", nbt);
        } else if (nbt.func_74764_b("boxes")) {
            NBTTagList list = nbt.func_150295_c("boxes", 11);
            this.box = LittleTileBox.createBox(list.func_150306_c(0));
        } else if (nbt.func_74764_b("box")) {
            this.box = LittleTileBox.createBox(nbt.func_74759_k("box"));
        }
        this.isStructureBlock = nbt.func_74767_n("isStructure");
        if (this.isStructureBlock) {
            if (nbt.func_74767_n("main")) {
                this.isMainBlock = true;
                if (this.structure == null) {
                    this.structure = LittleStructure.createAndLoadStructure(nbt, this);
                } else {
                    this.structure.setMainTile(this);
                    Iterator<LittleTile> iterator = this.structure.getTiles();
                    while (iterator.hasNext()) {
                        LittleTile tile = iterator.next();
                        if (tile == this || !tile.isLoaded()) continue;
                        tile.structure = null;
                    }
                    this.structure.loadFromNBT(nbt);
                }
            } else if (nbt.func_74764_b("coX")) {
                LittleTilePosition pos = new LittleTilePosition(nbt);
                this.coord = new LittleTileRelativeCoord((TileEntity)this.te, pos.coord, new int[]{pos.position.x, pos.position.y, pos.position.z});
                System.out.println("Converting old positioning to new relative coordinates " + pos + " to " + this.coord);
            } else {
                this.coord = new LittleTileRelativeCoord(nbt);
            }
        }
    }

    public void markForUpdate() {
        if (!this.te.func_145831_w().field_72995_K) {
            this.te.updateBlock();
        } else {
            this.te.updateRender();
        }
    }

    public void onPlaced(@Nullable EntityPlayer player, ItemStack stack, EnumFacing facing) {
        this.onNeighborChangeInside();
    }

    public void place() {
        this.te.addTile(this);
    }

    public void destroy() {
        if (this.isStructureBlock) {
            if (!this.te.func_145831_w().field_72995_K && this.isLoaded()) {
                this.structure.onLittleTileDestroy();
            }
        } else {
            this.te.removeTile(this);
        }
    }

    public LittleTile copy() {
        LittleTile tile = null;
        try {
            tile = (LittleTile)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Invalid LittleTile class=" + this.getClass().getName());
            tile = null;
        }
        if (tile != null) {
            this.copyCore(tile);
            this.copyExtra(tile);
        }
        return tile;
    }

    public void assignTo(LittleTile target) {
        this.copyCore(target);
        this.copyExtra(target);
    }

    public void copyExtra(LittleTile tile) {
        tile.invisible = this.invisible;
        tile.glowing = this.glowing;
    }

    public void copyCore(LittleTile tile) {
        tile.box = this.box != null ? this.box.copy() : null;
        tile.te = this.te;
        tile.isStructureBlock = this.isStructureBlock;
        tile.structure = this.structure;
        if (this.coord != null) {
            tile.coord = this.coord.copy();
        }
    }

    public ArrayList<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = null;
        if (this.isStructureBlock) {
            if (this.isLoaded()) {
                stack = this.structure.getStructureDrop();
            }
        } else {
            stack = this.getDrop();
        }
        if (stack != null) {
            drops.add(stack);
        }
        return drops;
    }

    public abstract ItemStack getDrop();

    public abstract BlockIngredient getIngredient();

    public LittleTilePreview getPreviewTile() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveTileExtra(nbt);
        nbt.func_74778_a("tID", this.getID());
        return new LittleTilePreview(this.box.copy(), nbt);
    }

    public void onNeighborChangeOutside() {
        this.onNeighborChange();
    }

    public void onNeighborChangeInside() {
        this.onNeighborChange();
    }

    public void onNeighborChange() {
    }

    public boolean needCustomRendering() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public final List<LittleRenderingCube> getRenderingCubes() {
        if (this.invisible) {
            return new ArrayList<LittleRenderingCube>();
        }
        return this.getInternalRenderingCubes();
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract List<LittleRenderingCube> getInternalRenderingCubes();

    @SideOnly(value=Side.CLIENT)
    public void renderTick(double x, double y, double z, float partialTickTime) {
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return 4096.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public abstract SoundType getSound();

    public void updateEntity() {
    }

    public boolean shouldTick() {
        return false;
    }

    protected abstract boolean canSawResize(EnumFacing var1, EntityPlayer var2);

    public boolean canSawResizeTile(EnumFacing facing, EntityPlayer player) {
        return !this.isStructureBlock && this.canSawResize(facing, player);
    }

    public boolean canBeMoved(EnumFacing facing) {
        return true;
    }

    public abstract float getExplosionResistance();

    public void onTileExplodes(Explosion explosion) {
    }

    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.isLoaded()) {
            return this.structure.onBlockActivated(worldIn, this, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.glowing ? 14 : 0;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    public boolean isLadder() {
        if (this.isLoaded()) {
            return this.structure.isLadder();
        }
        return false;
    }

    public Vec3d getFogColor(World world, BlockPos pos, IBlockState state, Entity entity, Vec3d originalColor, float partialTicks) {
        return originalColor;
    }

    public boolean isMaterial(Material material) {
        return false;
    }

    public List<LittleTileBox> getCollisionBoxes() {
        if (this.shouldCheckForCollision()) {
            return new ArrayList<LittleTileBox>();
        }
        if (this.isLoaded() && this.structure.noCollisionBoxes()) {
            return new ArrayList<LittleTileBox>();
        }
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        boxes.add(this.box);
        return boxes;
    }

    public boolean shouldCheckForCollision() {
        if (this.isLoaded()) {
            return this.structure.shouldCheckForCollision();
        }
        return false;
    }

    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.isLoaded()) {
            this.structure.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
        }
    }

    public boolean checkForStructure() {
        BlockPos absoluteCoord;
        Chunk chunk;
        if (this.loadingStructure) {
            return false;
        }
        if (this.structure != null) {
            return true;
        }
        this.loadingStructure = true;
        World world = this.te.func_145831_w();
        if (world != null && WorldUtils.checkIfChunkExists((Chunk)(chunk = world.func_175726_f(absoluteCoord = this.coord.getAbsolutePosition((TileEntity)this.te))))) {
            LittleTile tile;
            TileEntity tileEntity = world.func_175625_s(absoluteCoord);
            if (tileEntity instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)tileEntity).getTile(this.coord.identifier)) != null && tile.isStructureBlock && tile.isMainBlock) {
                this.structure = tile.structure;
                if (this.structure != null && this.structure.LoadList() && !this.structure.containsTile(this)) {
                    this.structure.addTile(this);
                } else if (!this.structure.LoadList()) {
                    System.out.println("Something went wrong");
                }
            }
            if (this.structure == null && !world.field_72995_K) {
                this.te.removeTile(this);
                this.te.updateBlock();
            }
            this.loadingStructure = false;
            return this.structure != null;
        }
        this.loadingStructure = false;
        return false;
    }

    public boolean isLoaded() {
        return this.isAllowedToSearchForStructure && this.isStructureBlock && this.checkForStructure();
    }

    @Deprecated
    public static class LittleTilePosition {
        public BlockPos coord;
        public LittleTileVec position;

        public LittleTilePosition(BlockPos coord, LittleTileVec position) {
            this.coord = coord;
            this.position = position;
        }

        public LittleTilePosition(String id, NBTTagCompound nbt) {
            this.coord = new BlockPos(nbt.func_74762_e(id + "coX"), nbt.func_74762_e(id + "coY"), nbt.func_74762_e(id + "coZ"));
            this.position = new LittleTileVec(id + "po", nbt);
        }

        public LittleTilePosition(NBTTagCompound nbt) {
            this("", nbt);
        }

        public void writeToNBT(String id, NBTTagCompound nbt) {
            nbt.func_74768_a(id + "coX", this.coord.func_177958_n());
            nbt.func_74768_a(id + "coY", this.coord.func_177956_o());
            nbt.func_74768_a(id + "coZ", this.coord.func_177952_p());
            this.position.writeToNBT(id + "po", nbt);
        }

        public void writeToNBT(NBTTagCompound nbt) {
            this.writeToNBT("", nbt);
        }

        public String toString() {
            return "coord:" + this.coord + "|position:" + this.position;
        }

        public LittleTilePosition copy() {
            return new LittleTilePosition(new BlockPos((Vec3i)this.coord), this.position.copy());
        }
    }
}

