/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.combine;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import java.util.ArrayList;
import java.util.List;

public class BasicCombiner {
    protected List<LittleTileBox> boxes;
    protected List<LittleTile> tiles;
    protected int i;
    protected int j;
    protected boolean modified;
    protected LittleStructure structure;
    protected LittleTile currentTile;

    public static void combineBoxes(List<LittleTileBox> boxes) {
        new BasicCombiner().combineBox(boxes);
    }

    public static void combineTiles(List<LittleTile> tiles) {
        new BasicCombiner().combineTile(tiles);
    }

    public static void combineTiles(List<LittleTile> tiles, LittleStructure structure) {
        new BasicCombiner().combineTile(tiles, structure);
    }

    public List<LittleTileBox> getBoxes() {
        return this.boxes;
    }

    public List<LittleTile> getTiles() {
        return this.tiles;
    }

    public void combineTile(List<LittleTile> tiles) {
        this.boxes = new ArrayList<LittleTileBox>();
        for (LittleTile tile : tiles) {
            this.boxes.add(tile.box);
        }
        this.tiles = tiles;
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < tiles.size()) {
                this.j = 0;
                while (this.j < tiles.size()) {
                    if (this.i != this.j && !tiles.get((int)this.i).isStructureBlock && !tiles.get((int)this.j).isStructureBlock && tiles.get(this.i).canBeSplitted() && tiles.get(this.j).canBeSplitted() && tiles.get(this.i).canBeCombined(tiles.get(this.j)) && tiles.get(this.j).canBeCombined(tiles.get(this.i))) {
                        this.currentTile = tiles.get(this.i);
                        LittleTileBox box = tiles.get((int)this.i).box.combineBoxes(tiles.get((int)this.j).box, this);
                        if (box != null) {
                            tiles.get((int)this.i).box = box;
                            tiles.get(this.i).combineTiles(tiles.get(this.j));
                            tiles.remove(this.j);
                            this.boxes.set(this.i, box);
                            this.boxes.remove(this.j);
                            if (this.i > this.j) {
                                --this.i;
                            }
                            this.modified = true;
                            continue;
                        }
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        this.tiles = null;
        this.boxes = null;
        this.currentTile = null;
    }

    public void combineTile(List<LittleTile> tiles, LittleStructure structure) {
        this.structure = structure;
        if (!structure.hasLoaded()) {
            return;
        }
        this.boxes = new ArrayList<LittleTileBox>();
        for (LittleTile tile : tiles) {
            this.boxes.add(tile.box);
        }
        this.tiles = tiles;
        boolean isMainTile = false;
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < tiles.size()) {
                if (tiles.get((int)this.i).structure != structure) {
                    ++this.i;
                    continue;
                }
                this.j = 0;
                while (this.j < tiles.size()) {
                    if (tiles.get((int)this.j).structure != structure) {
                        ++this.j;
                        continue;
                    }
                    if (this.i != this.j && tiles.get(this.i).canBeSplitted() && tiles.get(this.j).canBeSplitted() && tiles.get(this.i).canBeCombined(tiles.get(this.j)) && tiles.get(this.j).canBeCombined(tiles.get(this.i))) {
                        LittleTileBox box;
                        this.currentTile = tiles.get(this.i);
                        if (tiles.get((int)this.i).isMainBlock || tiles.get((int)this.j).isMainBlock) {
                            isMainTile = true;
                        }
                        if ((box = tiles.get((int)this.i).box.combineBoxes(tiles.get((int)this.j).box, this)) != null) {
                            tiles.get((int)this.i).box = box;
                            tiles.get(this.i).combineTiles(tiles.get(this.j));
                            tiles.remove(this.j);
                            this.boxes.set(this.i, box);
                            this.boxes.remove(this.j);
                            if (this.i > this.j) {
                                --this.i;
                            }
                            this.modified = true;
                            continue;
                        }
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        if (isMainTile) {
            structure.selectMainTile();
        }
        this.tiles = null;
        this.boxes = null;
        this.structure = null;
        this.currentTile = null;
    }

    public void combineBox(List<LittleTileBox> boxes) {
        this.boxes = boxes;
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < boxes.size()) {
                this.j = 0;
                while (this.j < boxes.size()) {
                    LittleTileBox box;
                    if (this.i != this.j && (box = boxes.get(this.i).combineBoxes(boxes.get(this.j), this)) != null) {
                        boxes.set(this.i, box);
                        boxes.remove(this.j);
                        this.modified = true;
                        if (this.i <= this.j) continue;
                        --this.i;
                        continue;
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        this.boxes = null;
    }

    public boolean cutOut(LittleTileBox searching, LittleTile toCombine) {
        for (LittleTile tile : this.tiles) {
            boolean canBeCombined;
            boolean bl = canBeCombined = tile.canBeSplitted() && tile.canBeSplitted() && tile.canBeCombined(toCombine) && toCombine.canBeCombined(tile);
            if (!(this.structure == null || toCombine.structure == this.structure && tile.structure == this.structure && this.structure.hasLoaded())) {
                canBeCombined = false;
            } else if (this.structure == null && tile.isStructureBlock) {
                canBeCombined = false;
            }
            if (!canBeCombined || searching.getClass() != tile.box.getClass() || !tile.box.containsBox(searching)) continue;
            List<LittleTileBox> cutOut = tile.box.cutOut(searching);
            if (cutOut != null) {
                this.boxes.addAll(cutOut);
                for (LittleTileBox cutBox : cutOut) {
                    LittleTile cutTile = toCombine.copy();
                    cutTile.box = cutBox;
                    this.tiles.add(cutTile);
                    if (this.structure == null) continue;
                    this.structure.addTile(cutTile);
                }
            }
            this.removeBox(tile.box);
            return true;
        }
        return false;
    }

    public boolean cutOut(LittleTileBox searching) {
        if (this.currentTile != null) {
            return this.cutOut(searching, this.currentTile);
        }
        for (LittleTileBox box : this.boxes) {
            if (searching.getClass() != box.getClass() || !box.containsBox(searching)) continue;
            List<LittleTileBox> cutOut = box.cutOut(searching);
            if (cutOut != null) {
                this.boxes.addAll(cutOut);
            }
            this.removeBox(box);
            return true;
        }
        return false;
    }

    public void removeBox(LittleTileBox box) {
        int index = this.boxes.indexOf(box);
        if (index != -1) {
            if (this.i > index) {
                --this.i;
            }
            if (this.j > index) {
                --this.j;
            }
            this.modified = true;
            this.boxes.remove(index);
            if (this.tiles != null) {
                if (this.structure != null) {
                    this.structure.removeTile(this.tiles.get(index));
                }
                this.tiles.remove(index);
            }
        }
    }
}

