/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.place;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class PlacePreviewTile {
    public static final Vec3d white = new Vec3d(1.0, 1.0, 1.0);
    public LittleTileBox box;
    public LittleTilePreview preview;

    public PlacePreviewTile(LittleTileBox box, LittleTilePreview preview) {
        this.box = box;
        this.preview = preview;
    }

    public PlacePreviewTile copy() {
        return new PlacePreviewTile(this.box.copy(), this.preview.copy());
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public List<LittleRenderingCube> getPreviews() {
        ArrayList<LittleRenderingCube> previews = new ArrayList<LittleRenderingCube>();
        previews.add(this.box.getRenderingCube(null, 0));
        return previews;
    }

    public List<LittleTile> placeTile(@Nullable EntityPlayer player, @Nullable ItemStack stack, BlockPos pos, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing, boolean requiresCollisionTest) {
        LittleTile LT = this.preview.getLittleTile(teLT);
        if (LT == null) {
            return Collections.EMPTY_LIST;
        }
        LT.box = this.box.copy();
        if (structure != null) {
            LT.isStructureBlock = true;
            LT.structure = structure;
            structure.addTile(LT);
        }
        if (!requiresCollisionTest || teLT.isSpaceForLittleTile(this.box)) {
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            LT.place();
            LT.onPlaced(player, stack, facing);
            tiles.add(LT);
            return tiles;
        }
        if (forced) {
            int i;
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            ArrayList<LittleTileBox> newBoxes = new ArrayList<LittleTileBox>();
            ArrayList<LittleTileBox> unplaceableBoxes = new ArrayList<LittleTileBox>();
            for (int littleX = this.box.minX; littleX < this.box.maxX; ++littleX) {
                for (int littleY = this.box.minY; littleY < this.box.maxY; ++littleY) {
                    for (int littleZ = this.box.minZ; littleZ < this.box.maxZ; ++littleZ) {
                        LittleTileBox newBox = this.box.extractBox(littleX, littleY, littleZ);
                        if (newBox == null) continue;
                        if (teLT.isSpaceForLittleTile(newBox)) {
                            newBoxes.add(newBox);
                            continue;
                        }
                        unplaceableBoxes.add(newBox);
                    }
                }
            }
            BasicCombiner.combineBoxes(newBoxes);
            for (i = 0; i < newBoxes.size(); ++i) {
                LittleTile newTile = LT.copy();
                newTile.box = newBoxes.get(i);
                newTile.place();
                newTile.onPlaced(player, stack, facing);
                tiles.add(newTile);
            }
            BasicCombiner.combineBoxes(unplaceableBoxes);
            for (i = 0; i < unplaceableBoxes.size(); ++i) {
                LittleTile newTile = LT.copy();
                newTile.box = unplaceableBoxes.get(i);
                unplaceableTiles.add(newTile);
            }
            return tiles;
        }
        if (unplaceableTiles != null) {
            unplaceableTiles.add(LT);
        }
        return Collections.EMPTY_LIST;
    }

    public boolean split(HashMapList<BlockPos, PlacePreviewTile> tiles, BlockPos pos) {
        if (this.preview != null && !this.preview.canSplit && this.box.needsMultipleBlocks()) {
            return false;
        }
        HashMapList boxes = new HashMapList();
        this.box.split((HashMapList<BlockPos, LittleTileBox>)boxes);
        for (Map.Entry entry : boxes.entrySet()) {
            for (LittleTileBox box : (ArrayList)entry.getValue()) {
                PlacePreviewTile tile = this.copy();
                tile.box = box;
                tiles.add((Object)((BlockPos)entry.getKey()).func_177971_a((Vec3i)pos), (Object)tile);
            }
        }
        return true;
    }
}

