/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.ingredients.BlockIngredient;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.place.FixedHandler;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreviewHandler;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.nbt.LittleNBTCompressionTools;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTilePreview {
    private static HashMap<String, Class<? extends LittleTilePreview>> previewTypes = new HashMap();
    public boolean canSplit = true;
    protected NBTTagCompound tileData;
    public LittleTileBox box;
    public List<FixedHandler> fixedhandlers = new ArrayList<FixedHandler>();
    public final LittleTilePreviewHandler handler;
    public static int lowResolutionMode = 2000;

    public static void registerPreviewType(String id, Class<? extends LittleTilePreview> type) {
        previewTypes.put(id, type);
    }

    public String getTypeID() {
        if (!this.isCustomPreview()) {
            return "";
        }
        for (Map.Entry<String, Class<? extends LittleTilePreview>> type : previewTypes.entrySet()) {
            if (type.getValue() != this.getClass()) continue;
            return type.getKey();
        }
        return "";
    }

    public boolean isCustomPreview() {
        return this.getClass() != LittleTilePreview.class;
    }

    public LittleTilePreview(NBTTagCompound nbt) {
        if (nbt.func_74764_b("bBoxminX") || nbt.func_74764_b("bBox")) {
            this.box = LittleTileBox.loadBox("bBox", nbt);
        } else if (nbt.func_74764_b("sizex") || nbt.func_74764_b("size")) {
            LittleTileSize size = new LittleTileSize("size", nbt);
            this.box = new LittleTileBox(0, 0, 0, size.sizeX, size.sizeY, size.sizeZ);
        } else {
            this.box = new LittleTileBox(0, 0, 0, 1, 1, 1);
        }
        if (nbt.func_74764_b("tile")) {
            this.tileData = nbt.func_74775_l("tile");
        } else {
            this.tileData = nbt.func_74737_b();
            this.tileData.func_82580_o("bBox");
            this.tileData.func_82580_o("size");
        }
        this.handler = LittleTile.getPreviewHandler(this.tileData.func_74779_i("tID"));
    }

    public LittleTilePreview(LittleTileBox box, NBTTagCompound tileData) {
        this.box = box;
        this.tileData = tileData;
        this.handler = LittleTile.getPreviewHandler(tileData.func_74779_i("tID"));
    }

    public boolean canBeConvertedToBlockEntry() {
        return this.handler.canBeConvertedToBlockEntry(this);
    }

    public String getPreviewBlockName() {
        return this.handler.getPreviewBlockName(this);
    }

    public Block getPreviewBlock() {
        return this.handler.getPreviewBlock(this);
    }

    public int getPreviewBlockMeta() {
        return this.handler.getPreviewBlockMeta(this);
    }

    public boolean hasColor() {
        return this.handler.hasColor(this);
    }

    public int getColor() {
        return this.handler.getColor(this);
    }

    public void setColor(int color) {
        this.handler.setColor(this, color);
    }

    @SideOnly(value=Side.CLIENT)
    public RenderCubeObject getCubeBlock() {
        return this.handler.getCubeBlock(this);
    }

    public boolean isInvisible() {
        return this.tileData.func_74767_n("invisible");
    }

    public void setInvisibile(boolean invisible) {
        this.tileData.func_74757_a("invisible", invisible);
    }

    public NBTTagCompound getTileData() {
        return this.tileData;
    }

    public BlockIngredient getBlockIngredient() {
        return this.handler.getBlockIngredient(this);
    }

    public double getPercentVolume() {
        return this.box.getPercentVolume();
    }

    public double getVolume() {
        return this.box.getVolume();
    }

    public LittleTilePreview copy() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(nbt);
        if (preview == null) {
            preview = new LittleTilePreview(this.box.copy(), this.tileData.func_74737_b());
        }
        preview.canSplit = this.canSplit;
        preview.fixedhandlers = new ArrayList<FixedHandler>(this.fixedhandlers);
        return preview;
    }

    public LittleTile getLittleTile(TileEntityLittleTiles te) {
        return LittleTile.CreateandLoadTile(te, te.func_145831_w(), this.tileData);
    }

    public PlacePreviewTile getPlaceableTile(LittleTileBox box, boolean fixed, LittleTileVec offset) {
        LittleTileBox newBox = this.box.copy();
        if (!fixed) {
            newBox.addOffset(offset);
        }
        return new PlacePreviewTile(newBox, this);
    }

    public void flipPreview(EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (this.box != null) {
            this.box.flipBox(axis, doubledCenter);
        }
        this.handler.flipPreview(axis, this, doubledCenter);
    }

    public void rotatePreview(Rotation rotation, LittleTileVec doubledCenter) {
        this.box.rotateBox(rotation, doubledCenter);
        this.handler.rotatePreview(rotation, this, doubledCenter);
    }

    public static LittleTilePreview loadPreviewFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt.func_74764_b("type")) {
            Class<? extends LittleTilePreview> type = previewTypes.get(nbt.func_74779_i("type"));
            if (type != null) {
                LittleTilePreview preview = null;
                try {
                    preview = type.getConstructor(NBTTagCompound.class).newInstance(nbt);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return preview;
            }
        } else {
            return new LittleTilePreview(nbt);
        }
        return null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.box.writeToNBT("bBox", nbt);
        nbt.func_74782_a("tile", (NBTBase)this.tileData);
        if (this.isCustomPreview() && !this.getTypeID().equals("")) {
            nbt.func_74778_a("type", this.getTypeID());
        }
    }

    public List<NBTTagCompound> extractNBTFromGroup(NBTTagCompound nbt) {
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound copy = nbt.func_74737_b();
            copy.func_82580_o("boxes");
            copy.func_74783_a("bBox", list.func_150306_c(i));
            tags.add(copy);
        }
        return tags;
    }

    public boolean canBeNBTGrouped(LittleTilePreview preview) {
        return this.handler.canBeNBTGrouped() && this.box != null && preview.box != null && preview.canSplit == preview.canSplit && preview.getTileData().equals((Object)this.getTileData());
    }

    public NBTTagCompound startNBTGrouping() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        nbt.func_82580_o("bBox");
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)this.box.getNBTIntArray());
        nbt.func_74782_a("boxes", (NBTBase)list);
        return nbt;
    }

    public void groupNBTTile(NBTTagCompound nbt, LittleTilePreview preview) {
        NBTTagList list = nbt.func_150295_c("boxes", 11);
        list.func_74742_a((NBTBase)preview.box.getNBTIntArray());
    }

    public static List<LittleTilePreview> getPreview(ItemStack stack) {
        return LittleTilePreview.getPreview(stack, false);
    }

    public static List<LittleTilePreview> getPreview(ItemStack stack, boolean allowLowResolution) {
        if (!stack.func_77942_o()) {
            return Collections.emptyList();
        }
        if (stack.func_77978_p().func_74781_a("tiles") instanceof NBTTagInt) {
            ArrayList<LittleTilePreview> result = new ArrayList<LittleTilePreview>();
            int tiles = stack.func_77978_p().func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("tile" + i);
                LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(nbt);
                if (preview == null) continue;
                result.add(preview);
            }
            return result;
        }
        if (allowLowResolution && stack.func_77978_p().func_74764_b("pos")) {
            ArrayList<LittleTilePreview> result = new ArrayList<LittleTilePreview>();
            NBTTagCompound tileData = new NBTTagCompound();
            LittleTileBlock tile = new LittleTileBlock(LittleTiles.coloredBlock);
            ((LittleTile)tile).saveTileExtra(tileData);
            tileData.func_74778_a("tID", tile.getID());
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                BlockPos pos = new BlockPos(array[0], array[1], array[2]);
                LittleTileVec max = new LittleTileVec((Vec3i)pos);
                max.add(new LittleTileVec(LittleTile.gridSize, LittleTile.gridSize, LittleTile.gridSize));
                result.add(new LittleTilePreview(new LittleTileBox(new LittleTileVec((Vec3i)pos), max), tileData));
            }
            return result;
        }
        return LittleNBTCompressionTools.readPreviews(stack.func_77978_p().func_150295_c("tiles", 10));
    }

    public static LittleTileSize getSize(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            return new LittleTileSize("size", stack.func_77978_p());
        }
        return new LittleTileSize(1, 1, 1);
    }

    public static void savePreviewTiles(List<LittleTilePreview> previews, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (int i = 0; i < previews.size(); ++i) {
            LittleTilePreview preview = previews.get(i);
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).writeToNBT("size", stack.func_77978_p());
        if (previews.size() >= lowResolutionMode) {
            NBTTagList list = new NBTTagList();
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            for (int i = 0; i < previews.size(); ++i) {
                BlockPos pos = previews.get((int)i).box.getMinVec().getBlockPos();
                if (positions.contains(pos)) continue;
                positions.add(pos);
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}));
            }
            stack.func_77978_p().func_74782_a("pos", (NBTBase)list);
        } else {
            stack.func_77978_p().func_82580_o("pos");
        }
        NBTTagList list = LittleNBTCompressionTools.writePreviews(previews);
        stack.func_77978_p().func_74782_a("tiles", (NBTBase)list);
        stack.func_77978_p().func_74768_a("count", previews.size());
    }

    public static void saveTiles(World world, List<LittleTile> tiles, ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview preview = tiles.get(i).getPreviewTile();
            previews.add(preview);
        }
        LittleTilePreview.savePreviewTiles(previews, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderCubeObject> getCubes(List<LittleTilePreview> previews) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        for (int i = 0; i < previews.size(); ++i) {
            cubes.add(previews.get(i).getCubeBlock());
        }
        return cubes;
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<RenderCubeObject> getCubes(ItemStack stack) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        if (stack.func_77942_o() && stack.func_77978_p().func_74762_e("count") >= lowResolutionMode) {
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                cubes.add(new RenderCubeObject((float)array[0], (float)array[1], (float)array[2], (float)(array[0] + 1), (float)(array[1] + 1), (float)(array[2] + 1), LittleTiles.coloredBlock));
            }
        } else {
            List<LittleTilePreview> previews = LittleTilePreview.getPreview(stack);
            for (int i = 0; i < previews.size(); ++i) {
                cubes.add(previews.get(i).getCubeBlock());
            }
        }
        return cubes;
    }
}

