/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.client.tiles.LittleCorner;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.combine.BasicCombiner;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleUtils;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedBox;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedOrdinaryBox;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public LittleTileBox(LittleTileVec center, LittleTileSize size) {
        LittleTileVec offset = size.calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + size.sizeX;
        this.maxY = this.minY + size.sizeY;
        this.maxZ = this.minZ + size.sizeZ;
    }

    public LittleTileBox(CubeObject cube) {
        this((int)Math.ceil(cube.minX * (float)LittleTile.gridSize), (int)Math.ceil(cube.minY * (float)LittleTile.gridSize), (int)Math.ceil(cube.minZ * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxX * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxY * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxZ * (float)LittleTile.gridSize));
    }

    public LittleTileBox(AxisAlignedBB box) {
        this((int)(box.field_72340_a * (double)LittleTile.gridSize), (int)(box.field_72338_b * (double)LittleTile.gridSize), (int)(box.field_72339_c * (double)LittleTile.gridSize), (int)(box.field_72336_d * (double)LittleTile.gridSize), (int)(box.field_72337_e * (double)LittleTile.gridSize), (int)(box.field_72334_f * (double)LittleTile.gridSize));
    }

    public LittleTileBox(LittleTileBox ... boxes) {
        this(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (int i = 0; i < boxes.length; ++i) {
            this.minX = Math.min(boxes[i].minX, this.minX);
            this.minY = Math.min(boxes[i].minY, this.minY);
            this.minZ = Math.min(boxes[i].minZ, this.minZ);
            this.maxX = Math.max(boxes[i].maxX, this.maxX);
            this.maxY = Math.max(boxes[i].maxY, this.maxY);
            this.maxZ = Math.max(boxes[i].maxZ, this.maxZ);
        }
    }

    public LittleTileBox(LittleTileVec min, LittleTileVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleTileBox(LittleTileVec min) {
        this(min.x, min.y, min.z, min.x + 1, min.y + 1, min.z + 1);
    }

    public LittleTileBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void addCollisionBoxes(AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, BlockPos offset) {
        AxisAlignedBB axisalignedbb = this.getBox(offset);
        if (entityBox.func_72326_a(axisalignedbb)) {
            collidingBoxes.add(axisalignedbb);
        }
    }

    public AxisAlignedBB getSelectionBox(BlockPos pos) {
        return this.getBox(pos);
    }

    public AxisAlignedBB getBox(BlockPos offset) {
        return new AxisAlignedBB((double)this.minX / (double)LittleTile.gridSize + (double)offset.func_177958_n(), (double)this.minY / (double)LittleTile.gridSize + (double)offset.func_177956_o(), (double)this.minZ / (double)LittleTile.gridSize + (double)offset.func_177952_p(), (double)this.maxX / (double)LittleTile.gridSize + (double)offset.func_177958_n(), (double)this.maxY / (double)LittleTile.gridSize + (double)offset.func_177956_o(), (double)this.maxZ / (double)LittleTile.gridSize + (double)offset.func_177952_p());
    }

    public AxisAlignedBB getBox() {
        return new AxisAlignedBB((double)this.minX / (double)LittleTile.gridSize, (double)this.minY / (double)LittleTile.gridSize, (double)this.minZ / (double)LittleTile.gridSize, (double)this.maxX / (double)LittleTile.gridSize, (double)this.maxY / (double)LittleTile.gridSize, (double)this.maxZ / (double)LittleTile.gridSize);
    }

    public CubeObject getCube() {
        return new CubeObject((float)this.minX / (float)LittleTile.gridSize, (float)this.minY / (float)LittleTile.gridSize, (float)this.minZ / (float)LittleTile.gridSize, (float)this.maxX / (float)LittleTile.gridSize, (float)this.maxY / (float)LittleTile.gridSize, (float)this.maxZ / (float)LittleTile.gridSize);
    }

    public int[] getArray() {
        return new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }

    public NBTTagIntArray getNBTIntArray() {
        return new NBTTagIntArray(this.getArray());
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, this.getArray());
    }

    public boolean isCompletelyFilled() {
        return true;
    }

    public Vec3d getSizeVec() {
        return new Vec3d((double)(this.maxX - this.minX) * LittleTile.gridMCLength, (double)(this.maxY - this.minY) * LittleTile.gridMCLength, (double)(this.maxZ - this.minZ) * LittleTile.gridMCLength);
    }

    public LittleTileSize getSize() {
        return new LittleTileSize(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public double getVolume() {
        return (this.maxX - this.minX) * (this.maxY - this.minY) * (this.maxZ - this.minZ);
    }

    public double getPercentVolume() {
        return this.getVolume() / (double)LittleTile.maxTilesPerBlock;
    }

    public int getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.maxX;
            }
            case WEST: {
                return this.minX;
            }
            case UP: {
                return this.maxY;
            }
            case DOWN: {
                return this.minY;
            }
            case SOUTH: {
                return this.maxZ;
            }
            case NORTH: {
                return this.minZ;
            }
        }
        return 0;
    }

    public LittleTileVec getCorner(LittleCorner corner) {
        return new LittleTileVec(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public Vec3d getExactCorner(LittleCorner corner) {
        return new Vec3d((double)this.getCornerX(corner), (double)this.getCornerY(corner), (double)this.getCornerZ(corner));
    }

    public int getCornerValue(LittleCorner corner, EnumFacing.Axis axis) {
        return this.getValueOfFacing(corner.getFacing(axis));
    }

    public int getCornerX(LittleCorner corner) {
        return this.getValueOfFacing(corner.x);
    }

    public int getCornerY(LittleCorner corner) {
        return this.getValueOfFacing(corner.y);
    }

    public int getCornerZ(LittleCorner corner) {
        return this.getValueOfFacing(corner.z);
    }

    public int getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX - this.minX;
            }
            case Y: {
                return this.maxY - this.minY;
            }
            case Z: {
                return this.maxZ - this.minZ;
            }
        }
        return 0;
    }

    public void setMin(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.minX = value;
                break;
            }
            case Y: {
                this.minY = value;
                break;
            }
            case Z: {
                this.minZ = value;
            }
        }
    }

    public int getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.minX;
            }
            case Y: {
                return this.minY;
            }
            case Z: {
                return this.minZ;
            }
        }
        return 0;
    }

    public void setMax(EnumFacing.Axis axis, int value) {
        switch (axis) {
            case X: {
                this.maxX = value;
                break;
            }
            case Y: {
                this.maxY = value;
                break;
            }
            case Z: {
                this.maxZ = value;
            }
        }
    }

    public int getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.maxX;
            }
            case Y: {
                return this.maxY;
            }
            case Z: {
                return this.maxZ;
            }
        }
        return 0;
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public boolean needsMultipleBlocks() {
        int x = this.minX / LittleTile.gridSize;
        int y = this.minY / LittleTile.gridSize;
        int z = this.minZ / LittleTile.gridSize;
        return this.maxX - x * LittleTile.gridSize <= LittleTile.maxPos && this.maxY - y * LittleTile.gridSize <= LittleTile.maxPos && this.maxZ - z * LittleTile.gridSize <= LittleTile.maxPos;
    }

    public boolean isBoxInsideBlock() {
        return this.minX >= LittleTile.minPos && this.maxX <= LittleTile.maxPos && this.minY >= LittleTile.minPos && this.maxY <= LittleTile.maxPos && this.minZ >= LittleTile.minPos && this.maxZ <= LittleTile.maxPos;
    }

    public void split(HashMapList<BlockPos, LittleTileBox> boxes) {
        LittleTileSize size = this.getSize();
        int minOffX = LittleUtils.toBlockOffset(this.minX);
        int minOffY = LittleUtils.toBlockOffset(this.minY);
        int minOffZ = LittleUtils.toBlockOffset(this.minZ);
        int maxOffX = LittleUtils.toBlockOffset(this.maxX);
        int maxOffY = LittleUtils.toBlockOffset(this.maxY);
        int maxOffZ = LittleUtils.toBlockOffset(this.maxZ);
        ArrayList<LittleTileBox> tempBoxes = new ArrayList<LittleTileBox>();
        for (int x = minOffX; x <= maxOffX; ++x) {
            for (int y = minOffY; y <= maxOffY; ++y) {
                for (int z = minOffZ; z <= maxOffZ; ++z) {
                    int minX = Math.max(this.minX, x * LittleTile.gridSize);
                    int minY = Math.max(this.minY, y * LittleTile.gridSize);
                    int minZ = Math.max(this.minZ, z * LittleTile.gridSize);
                    int maxX = Math.min(this.maxX, x * LittleTile.gridSize + LittleTile.gridSize);
                    int maxY = Math.min(this.maxY, y * LittleTile.gridSize + LittleTile.gridSize);
                    int maxZ = Math.min(this.maxZ, z * LittleTile.gridSize + LittleTile.gridSize);
                    if (maxX <= minX || maxY <= minY || maxZ <= minZ) continue;
                    tempBoxes.clear();
                    BlockPos pos = new BlockPos(x, y, z);
                    int offsetX = x * LittleTile.gridSize;
                    int offsetY = y * LittleTile.gridSize;
                    int offsetZ = z * LittleTile.gridSize;
                    this.extractBox(minX, minY, minZ, maxX, maxY, maxZ, tempBoxes);
                    for (LittleTileBox box : tempBoxes) {
                        box.minX -= offsetX;
                        box.maxX -= offsetX;
                        box.minY -= offsetY;
                        box.maxY -= offsetY;
                        box.minZ -= offsetZ;
                        box.maxZ -= offsetZ;
                        boxes.add((Object)pos, (Object)box);
                    }
                }
            }
        }
    }

    public boolean doesFillEntireBlock() {
        return this.minX == 0 && this.minY == 0 && this.minZ == 0 && this.maxX == LittleTile.gridSize && this.maxY == LittleTile.gridSize && this.maxZ == LittleTile.gridSize;
    }

    public LittleTileBox createOutsideBlockBox(EnumFacing facing) {
        LittleTileBox box = this.copy();
        switch (facing) {
            case EAST: {
                box.minX = 0;
                box.maxX -= LittleTile.gridSize;
                break;
            }
            case WEST: {
                box.minX += LittleTile.gridSize;
                box.maxX = LittleTile.gridSize;
                break;
            }
            case UP: {
                box.minY = 0;
                box.maxY -= LittleTile.gridSize;
                break;
            }
            case DOWN: {
                box.minY += LittleTile.gridSize;
                box.maxY = LittleTile.gridSize;
                break;
            }
            case SOUTH: {
                box.minZ = 0;
                box.maxZ -= LittleTile.gridSize;
                break;
            }
            case NORTH: {
                box.minZ += LittleTile.gridSize;
                box.maxZ = LittleTile.gridSize;
            }
        }
        return box;
    }

    public LittleTileBox combineBoxes(LittleTileBox box, BasicCombiner combinator) {
        boolean z;
        if (box.getClass() != LittleTileBox.class) {
            return null;
        }
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleTileBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleTileBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleTileBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    @Nullable
    public EnumFacing sharedBoxFace(LittleTileBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return null;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return EnumFacing.SOUTH;
            }
            if (this.maxZ == box.minZ) {
                return EnumFacing.NORTH;
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return EnumFacing.UP;
            }
            if (this.maxY == box.minY) {
                return EnumFacing.DOWN;
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return EnumFacing.EAST;
            }
            if (this.maxX == box.minX) {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    public List<LittleTileBox> cutOut(List<LittleTileBox> boxes, List<LittleTileBox> cutout) {
        ArrayList<LittleTileBox> newBoxes = new ArrayList<LittleTileBox>();
        for (int littleX = this.minX; littleX < this.maxX; ++littleX) {
            for (int littleY = this.minY; littleY < this.maxY; ++littleY) {
                for (int littleZ = this.minZ; littleZ < this.maxZ; ++littleZ) {
                    LittleTileBox box;
                    boolean isInside = false;
                    for (int i = 0; i < boxes.size(); ++i) {
                        if (!boxes.get(i).isVecInsideBox(littleX, littleY, littleZ)) continue;
                        isInside = true;
                        break;
                    }
                    if ((box = this.extractBox(littleX, littleY, littleZ)) == null) continue;
                    if (isInside) {
                        cutout.add(box);
                        continue;
                    }
                    newBoxes.add(box);
                }
            }
        }
        BasicCombiner.combineBoxes(newBoxes);
        if (newBoxes.size() == 1 && newBoxes.get(0).equals(this)) {
            return null;
        }
        BasicCombiner.combineBoxes(cutout);
        return newBoxes;
    }

    public List<LittleTileBox> cutOut(LittleTileBox box) {
        if (this.intersectsWith(box)) {
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            for (int littleX = this.minX; littleX < this.maxX; ++littleX) {
                for (int littleY = this.minY; littleY < this.maxY; ++littleY) {
                    for (int littleZ = this.minZ; littleZ < this.maxZ; ++littleZ) {
                        if (box.isVecInsideBox(littleX, littleY, littleZ)) continue;
                        this.extractBox(littleX, littleY, littleZ, littleX + 1, littleY + 1, littleZ + 1, boxes);
                    }
                }
            }
            BasicCombiner.combineBoxes(boxes);
            return boxes;
        }
        return null;
    }

    protected boolean intersectsWith(LittleTileBox box) {
        return box.maxX > this.minX && box.minX < this.maxX && box.maxY > this.minY && box.minY < this.maxY && box.maxZ > this.minZ && box.minZ < this.maxZ;
    }

    public boolean containsBox(LittleTileBox box) {
        return this.minX <= box.minX && this.maxX >= box.maxX && this.minY <= box.minY && this.maxY >= box.maxY && this.minZ <= box.minZ && this.maxZ >= box.maxZ;
    }

    public void addOffset(Vec3i vec) {
        this.minX += vec.func_177958_n() * LittleTile.gridSize;
        this.minY += vec.func_177956_o() * LittleTile.gridSize;
        this.minZ += vec.func_177952_p() * LittleTile.gridSize;
        this.maxX += vec.func_177958_n() * LittleTile.gridSize;
        this.maxY += vec.func_177956_o() * LittleTile.gridSize;
        this.maxZ += vec.func_177952_p() * LittleTile.gridSize;
    }

    public void addOffset(LittleTileVec vec) {
        this.minX += vec.x;
        this.minY += vec.y;
        this.minZ += vec.z;
        this.maxX += vec.x;
        this.maxY += vec.y;
        this.maxZ += vec.z;
    }

    public void subOffset(Vec3i vec) {
        this.minX -= vec.func_177958_n() * LittleTile.gridSize;
        this.minY -= vec.func_177956_o() * LittleTile.gridSize;
        this.minZ -= vec.func_177952_p() * LittleTile.gridSize;
        this.maxX -= vec.func_177958_n() * LittleTile.gridSize;
        this.maxY -= vec.func_177956_o() * LittleTile.gridSize;
        this.maxZ -= vec.func_177952_p() * LittleTile.gridSize;
    }

    public void subOffset(LittleTileVec vec) {
        this.minX -= vec.x;
        this.minY -= vec.y;
        this.minZ -= vec.z;
        this.maxX -= vec.x;
        this.maxY -= vec.y;
        this.maxZ -= vec.z;
    }

    public LittleTileVec getMinVec() {
        return new LittleTileVec(this.minX, this.minY, this.minZ);
    }

    public LittleTileVec getMaxVec() {
        return new LittleTileVec(this.maxX, this.maxY, this.maxZ);
    }

    public LittleTileVec getNearstedPointTo(LittleTileVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleTileVec(x, y, z);
    }

    public LittleTileVec getNearstedPointTo(LittleTileBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleTileVec(x, y, z);
    }

    public double distanceTo(LittleTileBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleTileVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean isVecInsideBox(int x, int y, int z) {
        return x >= this.minX && x < this.maxX && y >= this.minY && y < this.maxY && z >= this.minZ && z < this.maxZ;
    }

    public boolean isVecInsideBox(LittleTileVec vec) {
        return vec.x >= this.minX && vec.x < this.maxX && vec.y >= this.minY && vec.y < this.maxY && vec.z >= this.minZ && vec.z < this.maxZ;
    }

    public boolean intersectsWithFace(EnumFacing facing, LittleTileVec vec, boolean completely) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        return vec.getAxis(one) >= this.getMin(one) && vec.getAxis(one) <= this.getMax(one) && vec.getAxis(two) >= this.getMin(two) && vec.getAxis(two) <= this.getMax(two);
    }

    public boolean intersectsWithAxis(EnumFacing.Axis axis, Vec3d vec) {
        switch (axis) {
            case X: {
                return this.intersectsWithYZ(vec);
            }
            case Y: {
                return this.intersectsWithXZ(vec);
            }
            case Z: {
                return this.intersectsWithXY(vec);
            }
        }
        return false;
    }

    public boolean intersectsWithYZ(Vec3d vec) {
        return vec.field_72448_b >= LittleUtils.toVanillaGrid(this.minY) && vec.field_72448_b < LittleUtils.toVanillaGrid(this.maxY) && vec.field_72449_c >= LittleUtils.toVanillaGrid(this.minZ) && vec.field_72449_c < LittleUtils.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXZ(Vec3d vec) {
        return vec.field_72450_a >= LittleUtils.toVanillaGrid(this.minX) && vec.field_72450_a < LittleUtils.toVanillaGrid(this.maxX) && vec.field_72449_c >= LittleUtils.toVanillaGrid(this.minZ) && vec.field_72449_c < LittleUtils.toVanillaGrid(this.maxZ);
    }

    public boolean intersectsWithXY(Vec3d vec) {
        return vec.field_72450_a >= LittleUtils.toVanillaGrid(this.minX) && vec.field_72450_a < LittleUtils.toVanillaGrid(this.maxX) && vec.field_72448_b >= LittleUtils.toVanillaGrid(this.minY) && vec.field_72448_b < LittleUtils.toVanillaGrid(this.maxY);
    }

    public LittleTileVec getCenter() {
        return new LittleTileVec((this.maxX + this.minX) / 2, (this.maxY + this.minY) / 2, (this.maxZ + this.minZ) / 2);
    }

    @Nullable
    protected Vec3d collideWithPlane(EnumFacing.Axis axis, double value, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithAxis(axis, vec3d) ? vec3d : null;
    }

    @Nullable
    public RayTraceResult calculateIntercept(BlockPos pos, Vec3d vecA, Vec3d vecB) {
        vecA = vecA.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        vecB = vecB.func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp = this.collideWithPlane(facing.func_176740_k(), (double)this.getValueOfFacing(facing) / (double)LittleTile.gridSize, vecA, vecB);
            if (temp == null || !LittleTileBox.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), collided, pos);
    }

    public void rotateBox(Rotation rotation, LittleTileVec doubledCenter) {
        long tempMinX = this.minX * 2 - doubledCenter.x;
        long tempMinY = this.minY * 2 - doubledCenter.y;
        long tempMinZ = this.minZ * 2 - doubledCenter.z;
        long tempMaxX = this.maxX * 2 - doubledCenter.x;
        long tempMaxY = this.maxY * 2 - doubledCenter.y;
        long tempMaxZ = this.maxZ * 2 - doubledCenter.z;
        this.resort((int)((rotation.getMatrix().getX(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMinX, tempMinY, tempMinZ) + (long)doubledCenter.z) / 2L), (int)((rotation.getMatrix().getX(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.x) / 2L), (int)((rotation.getMatrix().getY(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.y) / 2L), (int)((rotation.getMatrix().getZ(tempMaxX, tempMaxY, tempMaxZ) + (long)doubledCenter.z) / 2L));
    }

    public void flipBox(EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        long tempMin = this.getMin(axis) * 2 - doubledCenter.getAxis(axis);
        long tempMax = this.getMax(axis) * 2 - doubledCenter.getAxis(axis);
        int min = (int)(((long)doubledCenter.getAxis(axis) - tempMin) / 2L);
        int max = (int)(((long)doubledCenter.getAxis(axis) - tempMax) / 2L);
        this.setMin(axis, Math.min(min, max));
        this.setMax(axis, Math.max(min, max));
    }

    public int hashCode() {
        return this.minX + this.minY + this.minZ + this.maxX + this.maxY + this.maxZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileBox) {
            return this.minX == ((LittleTileBox)object).minX && this.minY == ((LittleTileBox)object).minY && this.minZ == ((LittleTileBox)object).minZ && this.maxX == ((LittleTileBox)object).maxX && this.maxY == ((LittleTileBox)object).maxY && this.maxZ == ((LittleTileBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleTileBox extractBox(int x, int y, int z) {
        return new LittleTileBox(x, y, z, x + 1, y + 1, z + 1);
    }

    public List<LittleTileBox> extractBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, List<LittleTileBox> boxes) {
        boxes.add(new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ));
        return boxes;
    }

    public LittleTileBox copy() {
        return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isFaceAtEdge(EnumFacing facing) {
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return this.getMax(facing.func_176740_k()) == LittleTile.gridSize;
        }
        return this.getMin(facing.func_176740_k()) == LittleTile.minPos;
    }

    public LittleTileBox grow(EnumFacing facing) {
        EnumFacing.Axis axis = facing.func_176740_k();
        LittleTileBox result = this.copy();
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            result.setMax(axis, this.getMax(axis) + 1);
        } else {
            result.setMin(axis, this.getMin(axis) - 1);
        }
        return result;
    }

    public LittleTileBox shrink(EnumFacing facing, boolean toLimit) {
        EnumFacing.Axis axis = facing.func_176740_k();
        if (this.getSize(axis) > 1) {
            LittleTileBox result = this.copy();
            if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                result.setMax(axis, toLimit ? this.getMin(axis) + 1 : this.getMax(axis) - 1);
            } else {
                result.setMin(axis, toLimit ? this.getMax(axis) - 1 : this.getMin(axis) + 1);
            }
            return result;
        }
        return null;
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }

    public void resort(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ), Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void assignCube(CubeObject cube) {
        this.minX = (int)(cube.minX * (float)LittleTile.gridSize);
        this.minY = (int)(cube.minY * (float)LittleTile.gridSize);
        this.minZ = (int)(cube.minZ * (float)LittleTile.gridSize);
        this.maxX = (int)(cube.maxX * (float)LittleTile.gridSize);
        this.maxY = (int)(cube.maxY * (float)LittleTile.gridSize);
        this.maxZ = (int)(cube.maxZ * (float)LittleTile.gridSize);
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(Block block, int meta) {
        return this.getRenderingCube(this.getCube(), block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public LittleRenderingCube getRenderingCube(CubeObject cube, Block block, int meta) {
        return new LittleRenderingCube(cube, this, block, meta);
    }

    @Nullable
    public LittleTileFace getFace(EnumFacing facing) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)facing.func_176740_k());
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)facing.func_176740_k());
        return new LittleTileFace(facing, this.getMin(one), this.getMin(two), this.getMax(one), this.getMax(two), facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMax(facing.func_176740_k()) : this.getMin(facing.func_176740_k()));
    }

    public boolean intersectsWith(LittleTileFace face) {
        return (face.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.getMin(face.face.func_176740_k()) : this.getMax(face.face.func_176740_k())) == face.origin && face.maxOne > this.getMin(face.one) && face.minOne < this.getMax(face.one) && face.maxTwo > this.getMin(face.two) && face.minTwo < this.getMax(face.two);
    }

    public boolean canFaceBeCombined(LittleTileBox other) {
        return true;
    }

    public void fill(LittleTileFace face) {
        block7: {
            if (!this.intersectsWith(face)) break block7;
            int minOne = Math.max(this.getMin(face.one), face.minOne);
            int maxOne = Math.min(this.getMax(face.one), face.maxOne);
            int minTwo = Math.max(this.getMin(face.two), face.minTwo);
            int maxTwo = Math.min(this.getMax(face.two), face.maxTwo);
            if (this.isCompletelyFilled()) {
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        face.filled[one - face.minOne][two - face.minTwo] = true;
                    }
                }
            } else {
                boolean completely = !this.canFaceBeCombined(face.getBox());
                int min = this.getValueOfFacing(face.face.func_176734_d());
                if (face.face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                    --min;
                }
                LittleTileVec vec = new LittleTileVec(min, min, min);
                for (int one = minOne; one < maxOne; ++one) {
                    for (int two = minTwo; two < maxTwo; ++two) {
                        vec.setAxis(face.one, one);
                        vec.setAxis(face.two, two);
                        if (!this.intersectsWithFace(face.face.func_176734_d(), vec, completely)) continue;
                        face.filled[one - face.minOne][two - face.minTwo] = true;
                    }
                }
            }
        }
    }

    public int[] getIdentifier() {
        return new int[]{this.minX, this.minY, this.minZ};
    }

    public boolean is(int[] identifier) {
        if (identifier.length == 3) {
            return identifier[0] == this.minX && identifier[1] == this.minY && identifier[2] == this.minZ;
        }
        return false;
    }

    public static LittleTileBox loadBox(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagByte) {
            LittleTileBox box = new LittleTileBox(nbt.func_74771_c(name + "minX"), nbt.func_74771_c(name + "minY"), nbt.func_74771_c(name + "minZ"), nbt.func_74771_c(name + "maxX"), nbt.func_74771_c(name + "maxY"), nbt.func_74771_c(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            box.writeToNBT(name, nbt);
            return box;
        }
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagInt) {
            LittleTileBox box = new LittleTileBox(nbt.func_74762_e(name + "minX"), nbt.func_74762_e(name + "minY"), nbt.func_74762_e(name + "minZ"), nbt.func_74762_e(name + "maxX"), nbt.func_74762_e(name + "maxY"), nbt.func_74762_e(name + "maxZ"));
            nbt.func_82580_o(name + "minX");
            nbt.func_82580_o(name + "minY");
            nbt.func_82580_o(name + "minZ");
            nbt.func_82580_o(name + "maxX");
            nbt.func_82580_o(name + "maxY");
            nbt.func_82580_o(name + "maxZ");
            box.writeToNBT(name, nbt);
            return box;
        }
        if (nbt.func_74781_a(name) instanceof NBTTagIntArray) {
            return LittleTileBox.createBox(nbt.func_74759_k(name));
        }
        if (nbt.func_74781_a(name) instanceof NBTTagString) {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                return new LittleTileBox(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), Integer.parseInt(coords[3]), Integer.parseInt(coords[4]), Integer.parseInt(coords[5]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LittleTileBox(0, 0, 0, 0, 0, 0);
    }

    public static LittleTileBox createBox(int[] array) {
        switch (array.length) {
            case 6: {
                return new LittleTileBox(array[0], array[1], array[2], array[3], array[4], array[5]);
            }
            case 7: {
                return new LittleTileSlicedOrdinaryBox(array[0], array[1], array[2], array[3], array[4], array[5], LittleSlice.getSliceByID(array[6]));
            }
            case 11: {
                return new LittleTileSlicedBox(array[0], array[1], array[2], array[3], array[4], array[5], LittleSlice.getSliceByID(array[6]), Float.intBitsToFloat(array[7]), Float.intBitsToFloat(array[8]), Float.intBitsToFloat(array[9]), Float.intBitsToFloat(array[10]));
            }
        }
        throw new InvalidParameterException("No valid coords given " + array);
    }

    public static void combineBoxesBlocks(List<LittleTileBox> boxes) {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < boxes.size(); ++i) {
            chunked.add((Object)boxes.get(i).getMinVec().getBlockPos(), (Object)boxes.get(i));
        }
        boxes.clear();
        for (ArrayList list : chunked.getValues()) {
            BasicCombiner.combineBoxes(list);
            boxes.addAll(list);
        }
    }

    public static boolean isClosest(Vec3d from, @Nullable Vec3d optional, Vec3d toCheck) {
        return optional == null || from.func_72436_e(toCheck) < from.func_72436_e(optional);
    }

    public static boolean intersectsWith(LittleTileBox box, LittleTileBox box2) {
        if (box.getClass() == LittleTileBox.class) {
            return box2.intersectsWith(box);
        }
        return box.intersectsWith(box2);
    }

    public class LittleTileFace {
        public EnumFacing.Axis one;
        public EnumFacing.Axis two;
        public EnumFacing face;
        public int minOne;
        public int minTwo;
        public int maxOne;
        public int maxTwo;
        public int origin;
        public int oldOrigin;
        public boolean[][] filled;

        public LittleTileFace(EnumFacing face, int minOne, int minTwo, int maxOne, int maxTwo, int origin) {
            this.face = face;
            this.one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)face.func_176740_k());
            this.two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)face.func_176740_k());
            this.minOne = minOne;
            this.minTwo = minTwo;
            this.maxOne = maxOne;
            this.maxTwo = maxTwo;
            this.origin = origin;
            this.oldOrigin = origin;
            this.filled = new boolean[maxOne - minOne][maxTwo - minTwo];
        }

        public boolean isFilled() {
            int min = this.oldOrigin;
            if (this.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                --min;
            }
            LittleTileVec vec = new LittleTileVec(min, min, min);
            for (int one = 0; one < this.filled.length; ++one) {
                for (int two = 0; two < this.filled[one].length; ++two) {
                    vec.setAxis(this.one, this.minOne + one);
                    vec.setAxis(this.two, this.minTwo + two);
                    if (this.filled[one][two] || !LittleTileBox.this.intersectsWithFace(this.face, vec, false)) continue;
                    return false;
                }
            }
            return true;
        }

        public LittleTileBox getBox() {
            return LittleTileBox.this;
        }

        public boolean isFaceInsideBlock() {
            return this.origin > LittleTile.minPos && this.origin < LittleTile.maxPos;
        }

        public void move(EnumFacing facing) {
            this.origin = this.face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? LittleTile.minPos : LittleTile.maxPos;
        }
    }
}

