/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.security.InvalidParameterException;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class LittleTileRelativeCoord {
    private BlockPos coord;
    public int[] identifier;

    public LittleTileRelativeCoord(TileEntity te, BlockPos coord, int[] identifier) {
        this(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), coord, identifier);
    }

    public LittleTileRelativeCoord(BlockPos origin, BlockPos coord, int[] identifier) {
        this(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), coord, identifier);
    }

    public LittleTileRelativeCoord(int baseX, int baseY, int baseZ, BlockPos coord, int[] identifier) {
        this(coord.func_177958_n() - baseX, coord.func_177956_o() - baseY, coord.func_177952_p() - baseZ, identifier);
    }

    protected LittleTileRelativeCoord(int relativeX, int relativeY, int relativeZ, int[] identifier) {
        this.coord = new BlockPos(relativeX, relativeY, relativeZ);
        this.identifier = identifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LittleTileRelativeCoord(String id, NBTTagCompound nbt) {
        if (nbt.func_74764_b(id + "coord")) {
            int[] array = nbt.func_74759_k(id + "coord");
            if (array.length != 3) throw new InvalidParameterException("No valid coord given " + nbt);
            this.coord = new BlockPos(array[0], array[1], array[2]);
        } else if (nbt.func_74764_b(id + "coordX")) {
            this.coord = new BlockPos(nbt.func_74762_e(id + "coordX"), nbt.func_74762_e(id + "coordY"), nbt.func_74762_e(id + "coordZ"));
        }
        if (nbt.func_74764_b(id + "pos")) {
            LittleTileVec position = new LittleTileVec(id + "pos", nbt);
            this.identifier = new int[]{position.x, position.y, position.z};
            return;
        } else {
            this.identifier = nbt.func_74759_k("id");
        }
    }

    public LittleTileRelativeCoord(NBTTagCompound nbt) {
        this("", nbt);
    }

    public BlockPos getAbsolutePosition(TileEntity te) {
        return this.getAbsolutePosition(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    public BlockPos getAbsolutePosition(BlockPos origin) {
        return this.getAbsolutePosition(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public BlockPos getAbsolutePosition(int x, int y, int z) {
        return new BlockPos(this.coord.func_177958_n() + x, this.coord.func_177956_o() + y, this.coord.func_177952_p() + z);
    }

    public void writeToNBT(String id, NBTTagCompound nbt) {
        nbt.func_74783_a(id + "coord", new int[]{this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p()});
        nbt.func_74783_a("id", this.identifier);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.writeToNBT("", nbt);
    }

    public String toString() {
        return "coord:[" + this.coord.func_177958_n() + "," + this.coord.func_177956_o() + "," + this.coord.func_177952_p() + "]|position:" + Arrays.toString(this.identifier);
    }

    public LittleTileRelativeCoord copy() {
        return new LittleTileRelativeCoord(this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p(), (int[])this.identifier.clone());
    }
}

