/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import java.security.InvalidParameterException;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;

public class LittleTileSize {
    public int sizeX;
    public int sizeY;
    public int sizeZ;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LittleTileSize(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "x") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
            return;
        }
        if (nbt.func_74781_a(name + "x") instanceof NBTTagInt) {
            this.set(nbt.func_74762_e(name + "x"), nbt.func_74762_e(name + "y"), nbt.func_74762_e(name + "z"));
            return;
        }
        if (nbt.func_74781_a(name) instanceof NBTTagIntArray) {
            int[] array = nbt.func_74759_k(name);
            if (array.length != 3) throw new InvalidParameterException("No valid coords given " + nbt);
            this.set(array[0], array[1], array[2]);
            return;
        }
        if (!(nbt.func_74781_a(name) instanceof NBTTagString)) return;
        String[] coords = nbt.func_74779_i(name).split("\\.");
        try {
            this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            return;
        }
        catch (Exception e) {
            this.set(0, 0, 0);
        }
    }

    public LittleTileSize(String data) {
        String[] coords = data.split("\\.");
        try {
            this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        }
        catch (Exception e) {
            this.set(0, 0, 0);
        }
    }

    public LittleTileSize(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public void set(int sizeX, int sizeY, int sizeZ) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileSize) {
            return this.sizeX == ((LittleTileSize)object).sizeX && this.sizeY == ((LittleTileSize)object).sizeY && this.sizeZ == ((LittleTileSize)object).sizeZ;
        }
        return super.equals(object);
    }

    public int getVolume() {
        return this.sizeX * this.sizeY * this.sizeZ;
    }

    public double getPercentVolume() {
        return (double)this.getVolume() / (double)LittleTile.maxTilesPerBlock;
    }

    public LittleTileVec calculateInvertedCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((int)Math.ceil(x), (int)Math.ceil(y), (int)Math.ceil(z));
    }

    public LittleTileVec calculateCenter() {
        double x = (double)this.sizeX / 2.0;
        double y = (double)this.sizeY / 2.0;
        double z = (double)this.sizeZ / 2.0;
        return new LittleTileVec((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public double getPosX() {
        return (double)this.sizeX / (double)LittleTile.gridSize;
    }

    public double getPosY() {
        return (double)this.sizeY / (double)LittleTile.gridSize;
    }

    public double getPosZ() {
        return (double)this.sizeZ / (double)LittleTile.gridSize;
    }

    public int get(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.sizeX;
            }
            case Y: {
                return this.sizeY;
            }
            case Z: {
                return this.sizeZ;
            }
        }
        return 0;
    }

    public LittleTileSize copy() {
        return new LittleTileSize(this.sizeX, this.sizeY, this.sizeZ);
    }

    public void rotateSize(Rotation rotation) {
        int tempX = this.sizeX;
        int tempY = this.sizeY;
        int tempZ = this.sizeZ;
        this.sizeX = rotation.getMatrix().getX(tempX, tempY, tempZ);
        this.sizeY = rotation.getMatrix().getY(tempX, tempY, tempZ);
        this.sizeZ = rotation.getMatrix().getZ(tempX, tempY, tempZ);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name, new int[]{this.sizeX, this.sizeY, this.sizeZ});
    }

    public String toString() {
        return this.sizeX + "." + this.sizeY + "." + this.sizeZ;
    }

    public LittleTileSize max(LittleTileSize size) {
        this.sizeX = Math.max(this.sizeX, size.sizeX);
        this.sizeY = Math.max(this.sizeY, size.sizeY);
        this.sizeZ = Math.max(this.sizeZ, size.sizeZ);
        return this;
    }

    public int getSizeOfAxis(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.sizeX;
            }
            case Y: {
                return this.sizeY;
            }
            case Z: {
                return this.sizeZ;
            }
        }
        return 0;
    }
}

