/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec;

import com.creativemd.littletiles.common.tiles.LittleTile;

public class LittleUtils {
    public static final float EPSILON = 0.01f;
    public static final int scale = 5;

    public static float toVanillaGrid(float grid) {
        return grid / (float)LittleTile.gridSize;
    }

    public static double toVanillaGrid(int grid) {
        return (double)grid / (double)LittleTile.gridSize;
    }

    public static int toBlockOffset(int grid) {
        if (grid > 0) {
            return grid / LittleTile.gridSize;
        }
        return (int)Math.floor((double)grid / (double)LittleTile.gridSize);
    }

    public static boolean isAtEdge(double pos) {
        return pos % LittleTile.gridMCLength == 0.0;
    }

    public static int toGrid(int pos) {
        return pos * LittleTile.gridSize;
    }

    public static int toGrid(double pos) {
        if ((pos = LittleUtils.round(pos * (double)LittleTile.gridSize)) < 0.0) {
            return (int)Math.floor(pos);
        }
        return (int)pos;
    }

    public static boolean smallerThanAndEquals(double a, double b) {
        return a < b || LittleUtils.equals(a, b);
    }

    public static boolean greaterThanAndEquals(double a, double b) {
        return a > b || LittleUtils.equals(a, b);
    }

    public static boolean equals(double a, double b) {
        return a == b ? true : Math.abs(a - b) < (double)0.01f;
    }

    public static boolean equals(float a, float b) {
        return a == b ? true : Math.abs(a - b) < 0.01f;
    }

    public static double round(double valueToRound, int numberOfDecimalPlaces) {
        double multipicationFactor = Math.pow(10.0, numberOfDecimalPlaces);
        double interestedInZeroDPs = valueToRound * multipicationFactor;
        return (double)Math.round(interestedInZeroDPs) / multipicationFactor;
    }

    public static float round(float valueToRound, int numberOfDecimalPlaces) {
        float multipicationFactor = (float)Math.pow(10.0, numberOfDecimalPlaces);
        float interestedInZeroDPs = valueToRound * multipicationFactor;
        return (float)Math.round(interestedInZeroDPs) / multipicationFactor;
    }

    public static double round(double value) {
        return LittleUtils.round(value, 5);
    }

    public static float round(float value) {
        return LittleUtils.round(value, 5);
    }
}

