/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec.advanced;

import com.creativemd.creativecore.common.collision.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.client.tiles.LittleCorner;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleUtils;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleTileSlicedOrdinaryBox;
import com.creativemd.littletiles.common.tiles.vec.lines.LittleTile2DLine;
import javax.annotation.Nullable;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AxisAlignedBBOrdinarySliced
extends CreativeAxisAlignedBB {
    public final LittleSlice slice;

    public AxisAlignedBBOrdinarySliced(double x1, double y1, double z1, double x2, double y2, double z2, LittleSlice slice) {
        super(x1, y1, z1, x2, y2, z2);
        this.slice = slice;
    }

    public AxisAlignedBBOrdinarySliced setMaxY(double y2) {
        return new AxisAlignedBBOrdinarySliced(this.field_72340_a, this.field_72338_b, this.field_72339_c, this.field_72336_d, y2, this.field_72334_f, this.slice);
    }

    public boolean equals(Object object) {
        if (object.getClass() == AxisAlignedBBOrdinarySliced.class) {
            return ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72340_a == this.field_72340_a && ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72338_b == this.field_72338_b && ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72339_c == this.field_72339_c && ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72336_d == this.field_72336_d && ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72337_e == this.field_72337_e && ((AxisAlignedBBOrdinarySliced)((Object)object)).field_72334_f == this.field_72334_f && ((AxisAlignedBBOrdinarySliced)((Object)object)).slice == this.slice;
        }
        return false;
    }

    public AxisAlignedBBOrdinarySliced contract(double p_191195_1_, double p_191195_3_, double p_191195_5_) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (p_191195_1_ < 0.0) {
            d0 -= p_191195_1_;
        } else if (p_191195_1_ > 0.0) {
            d3 -= p_191195_1_;
        }
        if (p_191195_3_ < 0.0) {
            d1 -= p_191195_3_;
        } else if (p_191195_3_ > 0.0) {
            d4 -= p_191195_3_;
        }
        if (p_191195_5_ < 0.0) {
            d2 -= p_191195_5_;
        } else if (p_191195_5_ > 0.0) {
            d5 -= p_191195_5_;
        }
        return new AxisAlignedBBOrdinarySliced(d0, d1, d2, d3, d4, d5, this.slice);
    }

    public AxisAlignedBBOrdinarySliced addCoord(double x, double y, double z) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new AxisAlignedBBOrdinarySliced(d0, d1, d2, d3, d4, d5, this.slice);
    }

    public AxisAlignedBB func_72314_b(double x, double y, double z) {
        double d0 = this.field_72340_a - x;
        double d1 = this.field_72338_b - y;
        double d2 = this.field_72339_c - z;
        double d3 = this.field_72336_d + x;
        double d4 = this.field_72337_e + y;
        double d5 = this.field_72334_f + z;
        return new AxisAlignedBBOrdinarySliced(d0, d1, d2, d3, d4, d5, this.slice);
    }

    public AxisAlignedBBOrdinarySliced intersect(AxisAlignedBB p_191500_1_) {
        double d0 = Math.max(this.field_72340_a, p_191500_1_.field_72340_a);
        double d1 = Math.max(this.field_72338_b, p_191500_1_.field_72338_b);
        double d2 = Math.max(this.field_72339_c, p_191500_1_.field_72339_c);
        double d3 = Math.min(this.field_72336_d, p_191500_1_.field_72336_d);
        double d4 = Math.min(this.field_72337_e, p_191500_1_.field_72337_e);
        double d5 = Math.min(this.field_72334_f, p_191500_1_.field_72334_f);
        return new AxisAlignedBBOrdinarySliced(d0, d1, d2, d3, d4, d5, this.slice);
    }

    public AxisAlignedBB func_72317_d(double x, double y, double z) {
        return new AxisAlignedBBOrdinarySliced(this.field_72340_a + x, this.field_72338_b + y, this.field_72339_c + z, this.field_72336_d + x, this.field_72337_e + y, this.field_72334_f + z, this.slice);
    }

    public AxisAlignedBB func_186670_a(BlockPos pos) {
        return new AxisAlignedBBOrdinarySliced(this.field_72340_a + (double)pos.func_177958_n(), this.field_72338_b + (double)pos.func_177956_o(), this.field_72339_c + (double)pos.func_177952_p(), this.field_72336_d + (double)pos.func_177958_n(), this.field_72337_e + (double)pos.func_177956_o(), this.field_72334_f + (double)pos.func_177952_p(), this.slice);
    }

    public boolean intersectsTwoSides(EnumFacing.Axis toIgnore, AxisAlignedBB other) {
        if (this.slice.axis != toIgnore) {
            EnumFacing.Axis axisOne = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)toIgnore);
            EnumFacing.Axis axisTwo = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)toIgnore);
            return AxisAlignedBBOrdinarySliced.getMax(other, axisOne) > this.getMin(axisOne) && AxisAlignedBBOrdinarySliced.getMin(other, axisOne) < this.getMax(axisOne) && AxisAlignedBBOrdinarySliced.getMax(other, axisTwo) > this.getMin(axisTwo) && AxisAlignedBBOrdinarySliced.getMin(other, axisTwo) < this.getMax(axisTwo);
        }
        return this.intersectsWithOrdinaryTwoAxis(other);
    }

    public double calculateYOffsetStepUp(AxisAlignedBB other, AxisAlignedBB otherY, double offset) {
        if (!this.slice.isFacingPositive(EnumFacing.Axis.Y)) {
            EnumFacing.Axis axis = EnumFacing.Axis.Y;
            LittleCorner filledCorner = this.slice.getFilledCorner();
            Vec3d otherVec = AxisAlignedBBOrdinarySliced.getCorner(otherY, filledCorner);
            EnumFacing.Axis one = axis;
            EnumFacing.Axis two = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) != axis ? RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) : RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            LittleTile2DLine line = this.getSliceLine();
            double newPos = line.get(two, RotationUtils.get((EnumFacing.Axis)two, (Vec3d)otherVec));
            double d0 = (newPos = MathHelper.func_151237_a((double)newPos, (double)this.getMin(axis), (double)this.getMax(axis))) - AxisAlignedBBOrdinarySliced.getMax(otherY, axis);
            if (d0 < offset && (AxisAlignedBBOrdinarySliced.getMax(otherY, axis) < newPos || LittleUtils.equals(AxisAlignedBBOrdinarySliced.getMax(otherY, axis), newPos))) {
                return d0 / 2.0;
            }
        }
        return this.func_72323_b(other, offset);
    }

    public double calculateAxisOffset(AxisAlignedBB other, EnumFacing.Axis axis, double offset) {
        if (this.intersectsTwoSides(axis, other)) {
            boolean isOrdinary;
            boolean bl = this.slice.axis == axis || this.slice.isFacingPositive(axis) == offset > 0.0 ? true : (isOrdinary = false);
            if (isOrdinary) {
                if (offset > 0.0 && AxisAlignedBBOrdinarySliced.getMax(other, axis) <= this.getMin(axis)) {
                    double d1 = this.getMin(axis) - AxisAlignedBBOrdinarySliced.getMax(other, axis);
                    if (d1 < offset) {
                        return d1;
                    }
                    return offset;
                }
                if (offset < 0.0 && AxisAlignedBBOrdinarySliced.getMin(other, axis) >= this.getMax(axis)) {
                    double d0 = this.getMax(axis) - AxisAlignedBBOrdinarySliced.getMin(other, axis);
                    if (d0 > offset) {
                        return d0;
                    }
                    return offset;
                }
                return offset;
            }
            LittleCorner filledCorner = this.slice.getFilledCorner();
            Vec3d otherVec = AxisAlignedBBOrdinarySliced.getCorner(other, filledCorner);
            EnumFacing.Axis one = axis;
            EnumFacing.Axis two = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) != axis ? RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis) : RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            LittleTile2DLine line = this.getSliceLine();
            double newPos = line.get(two, RotationUtils.get((EnumFacing.Axis)two, (Vec3d)otherVec));
            newPos = MathHelper.func_151237_a((double)newPos, (double)this.getMin(axis), (double)this.getMax(axis));
            if (offset > 0.0 && (AxisAlignedBBOrdinarySliced.getMax(other, axis) < newPos || LittleUtils.equals(AxisAlignedBBOrdinarySliced.getMax(other, axis), newPos))) {
                double d0 = newPos - AxisAlignedBBOrdinarySliced.getMax(other, axis);
                if (d0 < offset) {
                    return d0;
                }
                return offset;
            }
            if (offset < 0.0 && (AxisAlignedBBOrdinarySliced.getMin(other, axis) > newPos || LittleUtils.equals(AxisAlignedBBOrdinarySliced.getMin(other, axis), newPos))) {
                double d0 = newPos - AxisAlignedBBOrdinarySliced.getMin(other, axis);
                if (d0 > offset) {
                    return d0;
                }
                return offset;
            }
            return offset;
        }
        return offset;
    }

    public LittleTile2DLine getSliceLine() {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        Vec3d corner = this.getCorner(this.slice.start);
        return new LittleTile2DLine(one, two, new Vector3d(corner.field_72450_a, corner.field_72448_b, corner.field_72449_c), this.getSize(one) * (double)this.slice.getDirectionScale(one), this.getSize(two) * (double)this.slice.getDirectionScale(two));
    }

    public double func_72316_a(AxisAlignedBB other, double offsetX) {
        return this.calculateAxisOffset(other, EnumFacing.Axis.X, offsetX);
    }

    public double func_72323_b(AxisAlignedBB other, double offsetY) {
        return this.calculateAxisOffset(other, EnumFacing.Axis.Y, offsetY);
    }

    public double func_72322_c(AxisAlignedBB other, double offsetZ) {
        return this.calculateAxisOffset(other, EnumFacing.Axis.Z, offsetZ);
    }

    public boolean isVecInsideBoxEdgeTwoSides(Vec3d vec) {
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        if (RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec) >= this.getMin(one) && RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec) <= this.getMax(one) && RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec) >= this.getMin(two) && RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec) <= this.getMax(two)) {
            LittleCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getCornerValue(corner, one) - RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec));
            double difTwo = Math.abs(this.getCornerValue(corner, two) - RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec));
            double sizeOne = this.getSize(one);
            double sizeTwo = this.getSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && (diff < 1.0 || LittleUtils.equals(diff, 1.0));
        }
        return false;
    }

    private boolean intersectsWithOrdinaryTwoAxis(AxisAlignedBB other) {
        EnumFacing ignoreFace = RotationUtils.getFacing((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisOne = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
        EnumFacing.Axis axisTwo = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
        if (!(AxisAlignedBBOrdinarySliced.getMax(other, axisOne) > this.getMin(axisOne) && AxisAlignedBBOrdinarySliced.getMin(other, axisOne) < this.getMax(axisOne) && AxisAlignedBBOrdinarySliced.getMax(other, axisTwo) > this.getMin(axisTwo) && AxisAlignedBBOrdinarySliced.getMin(other, axisTwo) < this.getMax(axisTwo))) {
            return false;
        }
        LittleCorner cornerMin = LittleCorner.getCornerUnsorted(ignoreFace, this.slice.emptySideOne.func_176734_d(), this.slice.emptySideTwo.func_176734_d());
        LittleCorner cornerMax = LittleCorner.getCornerUnsorted(ignoreFace, this.slice.emptySideOne, this.slice.emptySideTwo);
        double pointOne = this.getValueOfFacing(this.slice.getEmptySide(axisOne).func_176734_d());
        double pointTwo = this.getValueOfFacing(this.slice.getEmptySide(axisTwo).func_176734_d());
        Vec3d minVec = AxisAlignedBBOrdinarySliced.getCorner(other, cornerMin);
        Vec3d maxVec = AxisAlignedBBOrdinarySliced.getCorner(other, cornerMax);
        if (this.isVecInsideBoxEdgeTwoSides(minVec)) {
            return true;
        }
        if (this.isVecInsideBoxEdgeTwoSides(maxVec)) {
            return true;
        }
        if (this.slice.isFacingPositive(axisOne) ? RotationUtils.get((EnumFacing.Axis)axisOne, (Vec3d)minVec) <= pointOne : RotationUtils.get((EnumFacing.Axis)axisOne, (Vec3d)minVec) >= pointOne) {
            return true;
        }
        return this.slice.isFacingPositive(axisTwo) ? RotationUtils.get((EnumFacing.Axis)axisTwo, (Vec3d)minVec) <= pointTwo : RotationUtils.get((EnumFacing.Axis)axisTwo, (Vec3d)minVec) >= pointTwo;
    }

    public boolean func_72326_a(AxisAlignedBB other) {
        if (!super.func_186668_a(other.field_72340_a, other.field_72338_b, other.field_72339_c, other.field_72336_d, other.field_72337_e, other.field_72334_f)) {
            return false;
        }
        if (other.getClass() == AxisAlignedBB.class) {
            return this.intersectsWithOrdinaryTwoAxis(other);
        }
        return false;
    }

    public boolean func_72318_a(Vec3d vec) {
        if (super.func_72318_a(vec)) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            LittleCorner corner = this.slice.getFilledCorner();
            double difOne = Math.abs(this.getCornerValue(corner, one) - RotationUtils.get((EnumFacing.Axis)one, (Vec3d)vec));
            double difTwo = Math.abs(this.getCornerValue(corner, two) - RotationUtils.get((EnumFacing.Axis)two, (Vec3d)vec));
            double sizeOne = this.getSize(one);
            double sizeTwo = this.getSize(two);
            double diff = difOne / sizeOne + difTwo / sizeTwo;
            return sizeOne >= difOne && sizeTwo >= difTwo && (diff < 1.0 || LittleUtils.equals(diff, 1.0));
        }
        return false;
    }

    @Nullable
    protected Vec3d collideWithPlane(EnumFacing.Axis axis, double value, Vec3d vecA, Vec3d vecB) {
        Vec3d vec3d = axis != EnumFacing.Axis.X ? (axis != EnumFacing.Axis.Y ? vecA.func_72434_d(vecB, value) : vecA.func_72435_c(vecB, value)) : vecA.func_72429_b(vecB, value);
        return vec3d != null && this.intersectsWithAxis(axis, vec3d) ? vec3d : null;
    }

    public boolean intersectsWithAxis(EnumFacing.Axis axis, Vec3d vec) {
        switch (axis) {
            case X: {
                return this.func_186660_b(vec);
            }
            case Y: {
                return this.func_186667_c(vec);
            }
            case Z: {
                return this.func_186669_d(vec);
            }
        }
        return false;
    }

    @Nullable
    public RayTraceResult func_72327_a(Vec3d vecA, Vec3d vecB) {
        Vec3d collision = null;
        EnumFacing collided = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Vec3d temp;
            if (this.slice.emptySideOne == facing || this.slice.emptySideTwo == facing || (temp = this.collideWithPlane(facing.func_176740_k(), this.getValueOfFacing(facing) / (double)LittleTile.gridSize, vecA, vecB)) == null || !AxisAlignedBBOrdinarySliced.isClosest(vecA, collision, temp)) continue;
            collided = facing;
            collision = temp;
        }
        EnumFacing diagonal = this.slice.getPreferedSide(this.getSize());
        Vec3d temp = LittleTileSlicedOrdinaryBox.linePlaneIntersection(this.getCorner(LittleCorner.getCornerUnsorted(RotationUtils.getFacing((EnumFacing.Axis)this.slice.axis), this.slice.emptySideOne, this.slice.emptySideTwo.func_176734_d())), this.slice.getNormalVec(), vecA, vecB.func_178788_d(vecA));
        if (temp != null && this.intersectsWithAxis(diagonal.func_176740_k(), temp) && AxisAlignedBBOrdinarySliced.isClosest(vecA, collision, temp)) {
            collision = temp;
            EnumFacing enumFacing = collided = diagonal.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? diagonal.func_176734_d() : diagonal;
        }
        if (collision == null) {
            return null;
        }
        return new RayTraceResult(collision, collided);
    }

    public String toString() {
        return "slicedbox[" + this.field_72340_a + ", " + this.field_72338_b + ", " + this.field_72339_c + " -> " + this.field_72336_d + ", " + this.field_72337_e + ", " + this.field_72334_f + ", " + (Object)((Object)this.slice) + "]";
    }

    protected double getValueOfFacing(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return this.field_72336_d;
            }
            case WEST: {
                return this.field_72340_a;
            }
            case UP: {
                return this.field_72337_e;
            }
            case DOWN: {
                return this.field_72338_b;
            }
            case SOUTH: {
                return this.field_72334_f;
            }
            case NORTH: {
                return this.field_72339_c;
            }
        }
        return 0.0;
    }

    public Vec3d getCorner(LittleCorner corner) {
        return new Vec3d(this.getCornerX(corner), this.getCornerY(corner), this.getCornerZ(corner));
    }

    public double getCornerValue(LittleCorner corner, EnumFacing.Axis axis) {
        return this.getValueOfFacing(corner.getFacing(axis));
    }

    public double getCornerX(LittleCorner corner) {
        return this.getValueOfFacing(corner.x);
    }

    public double getCornerY(LittleCorner corner) {
        return this.getValueOfFacing(corner.y);
    }

    public double getCornerZ(LittleCorner corner) {
        return this.getValueOfFacing(corner.z);
    }

    public Vec3d getSize() {
        return new Vec3d(this.field_72336_d - this.field_72340_a, this.field_72337_e - this.field_72338_b, this.field_72334_f - this.field_72339_c);
    }

    public double getSize(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72336_d - this.field_72340_a;
            }
            case Y: {
                return this.field_72337_e - this.field_72338_b;
            }
            case Z: {
                return this.field_72334_f - this.field_72339_c;
            }
        }
        return 0.0;
    }

    public double getMin(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72340_a;
            }
            case Y: {
                return this.field_72338_b;
            }
            case Z: {
                return this.field_72339_c;
            }
        }
        return 0.0;
    }

    public double getMax(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.field_72336_d;
            }
            case Y: {
                return this.field_72337_e;
            }
            case Z: {
                return this.field_72334_f;
            }
        }
        return 0.0;
    }

    protected static double getValueOfFacing(AxisAlignedBB bb, EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return bb.field_72336_d;
            }
            case WEST: {
                return bb.field_72340_a;
            }
            case UP: {
                return bb.field_72337_e;
            }
            case DOWN: {
                return bb.field_72338_b;
            }
            case SOUTH: {
                return bb.field_72334_f;
            }
            case NORTH: {
                return bb.field_72339_c;
            }
        }
        return 0.0;
    }

    public static double getMin(AxisAlignedBB bb, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_72340_a;
            }
            case Y: {
                return bb.field_72338_b;
            }
            case Z: {
                return bb.field_72339_c;
            }
        }
        return 0.0;
    }

    public static double getMax(AxisAlignedBB bb, EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return bb.field_72336_d;
            }
            case Y: {
                return bb.field_72337_e;
            }
            case Z: {
                return bb.field_72334_f;
            }
        }
        return 0.0;
    }

    public static Vec3d getCorner(AxisAlignedBB bb, LittleCorner corner) {
        return new Vec3d(AxisAlignedBBOrdinarySliced.getCornerX(bb, corner), AxisAlignedBBOrdinarySliced.getCornerY(bb, corner), AxisAlignedBBOrdinarySliced.getCornerZ(bb, corner));
    }

    public static double getCornerValue(AxisAlignedBB bb, LittleCorner corner, EnumFacing.Axis axis) {
        return AxisAlignedBBOrdinarySliced.getValueOfFacing(bb, corner.getFacing(axis));
    }

    public static double getCornerX(AxisAlignedBB bb, LittleCorner corner) {
        return AxisAlignedBBOrdinarySliced.getValueOfFacing(bb, corner.x);
    }

    public static double getCornerY(AxisAlignedBB bb, LittleCorner corner) {
        return AxisAlignedBBOrdinarySliced.getValueOfFacing(bb, corner.y);
    }

    public static double getCornerZ(AxisAlignedBB bb, LittleCorner corner) {
        return AxisAlignedBBOrdinarySliced.getValueOfFacing(bb, corner.z);
    }

    public static boolean isClosest(Vec3d p_186661_1_, @Nullable Vec3d p_186661_2_, Vec3d p_186661_3_) {
        return p_186661_2_ == null || p_186661_1_.func_72436_e(p_186661_3_) < p_186661_1_.func_72436_e(p_186661_2_);
    }
}

