/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.vec.lines;

import com.creativemd.creativecore.common.utils.RotationUtils;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class LittleTile2DLine {
    public double originOne;
    public double originTwo;
    public double directionOne;
    public double directionTwo;
    public EnumFacing.Axis one;
    public EnumFacing.Axis two;

    public LittleTile2DLine(EnumFacing.Axis one, EnumFacing.Axis two, Vector3d origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = RotationUtils.get((EnumFacing.Axis)one, (double)origin.x, (double)origin.y, (double)origin.z);
        this.originTwo = RotationUtils.get((EnumFacing.Axis)two, (double)origin.x, (double)origin.y, (double)origin.z);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public LittleTile2DLine(EnumFacing.Axis one, EnumFacing.Axis two, LittleTileVec origin, double directionOne, double directionTwo) {
        this.one = one;
        this.two = two;
        this.originOne = origin.getAxis(one);
        this.originTwo = origin.getAxis(two);
        this.directionOne = directionOne;
        this.directionTwo = directionTwo;
    }

    public double getOrigin(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.originOne;
        }
        return this.originTwo;
    }

    public double getDirection(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.directionOne;
        }
        return this.directionTwo;
    }

    public EnumFacing.Axis getOther(EnumFacing.Axis axis) {
        if (this.one == axis) {
            return this.two;
        }
        return this.one;
    }

    public double get(EnumFacing.Axis axis, double value) {
        EnumFacing.Axis other = this.getOther(axis);
        return this.getOrigin(other) + this.getDirection(other) * (value - this.getOrigin(axis)) / this.getDirection(axis);
    }

    public boolean isCoordinateOnLine(int one, int two) {
        return this.get(this.one, one) == (double)two;
    }

    public boolean isCoordinateToTheRight(int one, int two) {
        double tempTwo = (double)two - this.originTwo;
        double tempOne = (double)one - this.originOne;
        return this.directionOne * tempTwo - this.directionTwo * tempOne < 0.0;
    }

    public Vec3d intersect(LittleTile2DLine line, int thirdValue) {
        if (this.directionOne * line.directionTwo - this.directionTwo * line.directionOne == 0.0) {
            return null;
        }
        Vec3d vec = new Vec3d((double)thirdValue, (double)thirdValue, (double)thirdValue);
        double t = ((line.originTwo - this.originTwo) * line.directionOne + this.originOne * line.directionTwo - line.originOne * line.directionTwo) / (line.directionOne * this.directionTwo - this.directionOne * line.directionTwo);
        vec = RotationUtils.setValue((Vec3d)vec, (double)(this.originOne + t * this.directionOne), (EnumFacing.Axis)this.one);
        vec = RotationUtils.setValue((Vec3d)vec, (double)(this.originTwo + t * this.directionTwo), (EnumFacing.Axis)this.two);
        return vec;
    }
}

