/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.geo;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShapeBox;
import com.creativemd.littletiles.common.utils.geo.DragShapeCylinder;
import com.creativemd.littletiles.common.utils.geo.DragShapeLine;
import com.creativemd.littletiles.common.utils.geo.DragShapeSliced;
import com.creativemd.littletiles.common.utils.geo.DragShapeSphere;
import com.creativemd.littletiles.common.utils.geo.DragShapeWall;
import com.creativemd.littletiles.common.utils.geo.SelectShape;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DragShape {
    public static LinkedHashMap<String, DragShape> shapes = new LinkedHashMap();
    public static DragShape box = new DragShapeBox();
    public static DragShape sphere = new DragShapeSphere();
    public static DragShape cylinder = new DragShapeCylinder();
    public static DragShape wall = new DragShapeWall();
    public static DragShape line = new DragShapeLine();
    public static DragShape slice = new DragShapeSliced();
    public static DragShape defaultShape = box;
    public final String key;

    public static DragShape getShape(String name) {
        DragShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public DragShape(String name) {
        shapes.put(name, this);
        this.key = name;
        new SelectShape.DragSelectShape(this);
    }

    public abstract List<LittleTileBox> getBoxes(LittleTileVec var1, LittleTileVec var2, EntityPlayer var3, NBTTagCompound var4, boolean var5, LittleTileVec var6, LittleTileVec var7);

    public abstract void addExtraInformation(NBTTagCompound var1, List<String> var2);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2);

    public abstract void rotate(NBTTagCompound var1, Rotation var2);

    public abstract void flip(NBTTagCompound var1, EnumFacing.Axis var2);
}

