/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.geo;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeBox
extends DragShape {
    public DragShapeBox() {
        super("box");
    }

    @Override
    public List<LittleTileBox> getBoxes(LittleTileVec min, LittleTileVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, LittleTileVec originalMin, LittleTileVec originalMax) {
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        LittleTileBox box = new LittleTileBox(min, max);
        if (nbt.func_74767_n("hollow")) {
            int thickness = nbt.func_74762_e("thickness");
            LittleTileSize size = box.getSize();
            if (thickness * 2 >= size.sizeX || thickness * 2 >= size.sizeY || thickness * 2 >= size.sizeZ) {
                boxes.add(box);
            } else {
                boxes.add(new LittleTileBox(min.x, min.y, min.z, max.x, max.y, min.z + thickness));
                boxes.add(new LittleTileBox(min.x, min.y + thickness, min.z + thickness, min.x + thickness, max.y - thickness, max.z - thickness));
                boxes.add(new LittleTileBox(max.x - thickness, min.y + thickness, min.z + thickness, max.x, max.y - thickness, max.z - thickness));
                boxes.add(new LittleTileBox(min.x, min.y, min.z + thickness, max.x, min.y + thickness, max.z - thickness));
                boxes.add(new LittleTileBox(min.x, max.y - thickness, min.z + thickness, max.x, max.y, max.z - thickness));
                boxes.add(new LittleTileBox(min.x, min.y, max.z - thickness, max.x, max.y, max.z));
            }
        } else {
            boxes.add(box);
        }
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        if (nbt.func_74767_n("hollow")) {
            list.add("type: hollow");
            list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        } else {
            list.add("type: solid");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiCheckBox("hollow", 5, 0, nbt.func_74767_n("hollow")));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 20, 100, 14, nbt.func_74762_e("thickness"), 1, LittleTile.gridSize));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
        GuiCheckBox box = (GuiCheckBox)gui.get("hollow");
        nbt.func_74757_a("hollow", box.value);
        if (box.value) {
            GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
            nbt.func_74768_a("thickness", (int)slider.value);
        }
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

