/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.geo;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeCylinder
extends DragShape {
    public DragShapeCylinder() {
        super("cylinder");
    }

    @Override
    public List<LittleTileBox> getBoxes(LittleTileVec min, LittleTileVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, LittleTileVec originalMin, LittleTileVec originalMax) {
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        LittleTileBox box = new LittleTileBox(min, max);
        boolean hollow = nbt.func_74767_n("hollow");
        int direction = nbt.func_74762_e("direction");
        LittleTileSize size = box.getSize();
        int sizeA = size.sizeX;
        int sizeB = size.sizeZ;
        if (direction == 1) {
            sizeA = size.sizeY;
            sizeB = size.sizeZ;
        } else if (direction == 2) {
            sizeA = size.sizeX;
            sizeB = size.sizeY;
        }
        double a = Math.pow(Math.max(1, sizeA / 2), 2.0);
        double b = Math.pow(Math.max(1, sizeB / 2), 2.0);
        double a2 = 1.0;
        double b2 = 1.0;
        double c2 = 1.0;
        int thickness = nbt.func_74762_e("thickness");
        if (hollow && sizeA > thickness * 2 && sizeB > thickness * 2) {
            int all = sizeA + sizeB;
            double sizeAValue = (double)sizeA / (double)all;
            double sizeBValue = (double)sizeB / (double)all;
            if (sizeAValue > 0.5) {
                sizeAValue = 0.5;
            }
            if (sizeBValue > 0.5) {
                sizeBValue = 0.5;
            }
            a2 = Math.pow(Math.max(1.0, (sizeAValue * (double)all - (double)(thickness * 2)) / 2.0), 2.0);
            b2 = Math.pow(Math.max(1.0, (sizeBValue * (double)all - (double)(thickness * 2)) / 2.0), 2.0);
        } else {
            hollow = false;
        }
        boolean stretchedA = sizeA % 2 == 0;
        boolean stretchedB = sizeB % 2 == 0;
        double centerA = sizeA / 2;
        double centerB = sizeB / 2;
        min = box.getMinVec();
        max = box.getMaxVec();
        for (int incA = 0; incA < sizeA; ++incA) {
            for (int incB = 0; incB < sizeB; ++incB) {
                double valueB;
                double posA = (double)incA - centerA + (stretchedA ? 0.5 : 0.0);
                double posB = (double)incB - centerB + (stretchedB ? 0.5 : 0.0);
                double valueA = Math.pow(posA, 2.0) / a;
                if (!(valueA + (valueB = Math.pow(posB, 2.0) / b) <= 1.0)) continue;
                double valueA2 = Math.pow(posA, 2.0) / a2;
                double valueB2 = Math.pow(posB, 2.0) / b2;
                if (hollow && !(valueA2 + valueB2 > 1.0)) continue;
                LittleTileBox toAdd = null;
                switch (direction) {
                    case 0: {
                        toAdd = new LittleTileBox(min.x + incA, min.y, min.z + incB, min.x + incA + 1, max.y, min.z + incB + 1);
                        break;
                    }
                    case 1: {
                        toAdd = new LittleTileBox(min.x, min.y + incA, min.z + incB, max.x, min.y + incA + 1, min.z + incB + 1);
                        break;
                    }
                    case 2: {
                        toAdd = new LittleTileBox(min.x + incA, min.y + incB, min.z, min.x + incA + 1, min.y + incB + 1, max.z);
                    }
                }
                boxes.add(toAdd);
            }
        }
        LittleTileBox.combineBoxesBlocks(boxes);
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        if (nbt.func_74767_n("hollow")) {
            list.add("type: hollow");
            list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        } else {
            list.add("type: solid");
        }
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiCheckBox("hollow", 5, 0, nbt.func_74767_n("hollow")));
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 20, 100, 14, nbt.func_74762_e("thickness"), 1, LittleTile.gridSize));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 42, new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
        GuiCheckBox box = (GuiCheckBox)gui.get("hollow");
        nbt.func_74757_a("hollow", box.value);
        if (box.value) {
            GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
            nbt.func_74768_a("thickness", (int)slider.value);
        }
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

