/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.geo;

import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DragShapeWall
extends DragShape {
    public DragShapeWall() {
        super("wall");
    }

    @Override
    public List<LittleTileBox> getBoxes(LittleTileVec min, LittleTileVec max, EntityPlayer player, NBTTagCompound nbt, boolean preview, LittleTileVec originalMin, LittleTileVec originalMax) {
        ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
        LittleTileBox box = new LittleTileBox(min, max);
        int direction = nbt.func_74762_e("direction");
        LittleTileSize size = box.getSize();
        int thicknessXInv = 0;
        int thicknessX = 0;
        int thicknessYInv = nbt.func_74762_e("thickness") > 1 ? (int)Math.ceil((double)(nbt.func_74762_e("thickness") - 1) / 2.0) : 0;
        int thicknessY = nbt.func_74762_e("thickness") > 1 ? (int)Math.floor((double)(nbt.func_74762_e("thickness") - 1) / 2.0) : 0;
        int w = originalMax.x - originalMin.x;
        int h = originalMax.z - originalMin.z;
        int x = originalMin.x;
        int y = originalMin.z;
        if (direction == 1) {
            w = originalMax.y - originalMin.y;
            h = originalMax.z - originalMin.z;
            x = originalMin.y;
            y = originalMin.z;
        } else if (direction == 2) {
            w = originalMax.x - originalMin.x;
            h = originalMax.y - originalMin.y;
            x = originalMin.x;
            y = originalMin.y;
        }
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
            thicknessX = thicknessY;
            thicknessXInv = thicknessYInv;
            thicknessY = 0;
            thicknessYInv = 0;
        }
        int numerator = longest >> 1;
        for (int i = 0; i <= longest; ++i) {
            LittleTileBox toAdd = null;
            switch (direction) {
                case 0: {
                    toAdd = new LittleTileBox(x - thicknessXInv, box.minY, y - thicknessYInv, x + thicknessX + 1, box.maxY, y + thicknessY + 1);
                    break;
                }
                case 1: {
                    toAdd = new LittleTileBox(box.minX, x - thicknessXInv, y - thicknessYInv, box.maxX, x + thicknessX + 1, y + thicknessY + 1);
                    break;
                }
                case 2: {
                    toAdd = new LittleTileBox(x - thicknessXInv, y - thicknessYInv, box.minZ, x + thicknessX + 1, y + thicknessY + 1, box.maxZ);
                }
            }
            boxes.add(toAdd);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x += dx1;
                y += dy1;
                continue;
            }
            x += dx2;
            y += dy2;
        }
        LittleTileBox.combineBoxesBlocks(boxes);
        return boxes;
    }

    @Override
    public void addExtraInformation(NBTTagCompound nbt, List<String> list) {
        list.add("thickness: " + nbt.func_74762_e("thickness") + " tiles");
        int facing = nbt.func_74762_e("direction");
        String text = "facing: ";
        switch (facing) {
            case 0: {
                text = text + "y";
                break;
            }
            case 1: {
                text = text + "x";
                break;
            }
            case 2: {
                text = text + "z";
            }
        }
        list.add(text);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
        ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
        controls.add((GuiControl)new GuiSteppedSlider("thickness", 5, 5, 100, 14, nbt.func_74762_e("thickness"), 1, LittleTile.gridSize));
        controls.add((GuiControl)new GuiStateButton("direction", nbt.func_74762_e("direction"), 5, 27, new String[]{"facing: y", "facing: x", "facing: z"}));
        return controls;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
        GuiSteppedSlider slider = (GuiSteppedSlider)gui.get("thickness");
        nbt.func_74768_a("thickness", (int)slider.value);
        GuiStateButton state = (GuiStateButton)gui.get("direction");
        nbt.func_74768_a("direction", state.getState());
    }

    @Override
    public void rotate(NBTTagCompound nbt, Rotation rotation) {
        int direction = nbt.func_74762_e("direction");
        direction = rotation.axis != EnumFacing.Axis.Y ? 0 : (direction == 1 ? 2 : 1);
        nbt.func_74768_a("direction", direction);
    }

    @Override
    public void flip(NBTTagCompound nbt, EnumFacing.Axis axis) {
    }
}

