/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.geo;

import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.geo.DragShape;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class SelectShape {
    public static LinkedHashMap<String, SelectShape> shapes = new LinkedHashMap();
    public static SelectShape tileShape = new SelectShape("tile"){

        @Override
        public boolean shouldBeRegistered() {
            return false;
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return true;
        }

        @Override
        public List<LittleTileBox> getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return this.getBoxes(player, nbt, result);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
            return new ArrayList<GuiControl>();
        }

        @Override
        public List<LittleTileBox> getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            BlockTile.TEResult te = BlockTile.loadTeAndTile((IBlockAccess)player.field_70170_p, result.func_178782_a(), player);
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            if (te.isComplete()) {
                LittleTileBox box = te.tile.box.copy();
                box.addOffset((Vec3i)result.func_178782_a());
                boxes.add(box);
            }
            return boxes;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt) {
        }

        @Override
        public void addExtraInformation(EntityPlayer player, NBTTagCompound nbt, List<String> list) {
        }
    };
    public static BasicSelectShape CUBE = new BasicSelectShape("cube"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
            LittleTileVec offset = new LittleTileVec(side);
            offset.scale((thickness - 1) / 2);
            vec.sub(offset);
            if ((thickness & 1) == 0 && side.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE || side.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                vec.sub(side);
            }
            LittleTileBox box = new LittleTileBox(vec, new LittleTileSize(thickness, thickness, thickness));
            return box;
        }
    };
    public static BasicSelectShape BAR = new BasicSelectShape("bar"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
            LittleTileBox box = CUBE.getBox(vec, thickness, side);
            switch (side.func_176740_k()) {
                case X: {
                    box.minX = 0;
                    box.maxX = LittleTile.gridSize;
                    break;
                }
                case Y: {
                    box.minY = 0;
                    box.maxY = LittleTile.gridSize;
                    break;
                }
                case Z: {
                    box.minZ = 0;
                    box.maxZ = LittleTile.gridSize;
                }
            }
            return box;
        }
    };
    public static BasicSelectShape PLANE = new BasicSelectShape("plane"){

        @Override
        public LittleTileBox getBox(LittleTileVec vec, int thickness, EnumFacing side) {
            LittleTileBox box = CUBE.getBox(vec, thickness, side);
            switch (side.func_176740_k()) {
                case X: {
                    box.minY = 0;
                    box.maxY = LittleTile.gridSize;
                    box.minZ = 0;
                    box.maxZ = LittleTile.gridSize;
                    break;
                }
                case Y: {
                    box.minX = 0;
                    box.maxX = LittleTile.gridSize;
                    box.minZ = 0;
                    box.maxZ = LittleTile.gridSize;
                    break;
                }
                case Z: {
                    box.minX = 0;
                    box.maxX = LittleTile.gridSize;
                    box.minY = 0;
                    box.maxY = LittleTile.gridSize;
                }
            }
            return box;
        }
    };
    public static SelectShape defaultShape = CUBE;
    public final String key;

    public static SelectShape getShape(String name) {
        SelectShape shape = shapes.get(name);
        return shape == null ? defaultShape : shape;
    }

    public SelectShape(String name) {
        if (this.shouldBeRegistered()) {
            shapes.put(name, this);
        }
        this.key = name;
    }

    public boolean shouldBeRegistered() {
        return true;
    }

    public abstract List<LittleTileBox> getHighlightBoxes(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3);

    public abstract boolean rightClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3);

    public abstract boolean leftClick(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3);

    public abstract void deselect(EntityPlayer var1, NBTTagCompound var2);

    public abstract List<LittleTileBox> getBoxes(EntityPlayer var1, NBTTagCompound var2, RayTraceResult var3);

    public abstract void addExtraInformation(EntityPlayer var1, NBTTagCompound var2, List<String> var3);

    @SideOnly(value=Side.CLIENT)
    public abstract List<GuiControl> getCustomSettings(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void saveCustomSettings(GuiParent var1, NBTTagCompound var2);

    public static class DragSelectShape
    extends SelectShape {
        private final DragShape shape;
        public LittleTileVec first;

        public DragSelectShape(DragShape shape) {
            super("drag" + shape.key);
            this.shape = shape;
        }

        public List<LittleTileBox> getBoxes(EntityPlayer player, NBTTagCompound nbt, LittleTileVec min, LittleTileVec max, boolean preview) {
            LittleTileBox box = new LittleTileBox(new LittleTileBox(min), new LittleTileBox(max));
            return this.shape.getBoxes(box.getMinVec(), box.getMaxVec(), player, nbt, preview, min, max);
        }

        @Override
        public List<LittleTileBox> getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            LittleTileVec vec = new LittleTileVec(result);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                vec.sub(result.field_178784_b);
            }
            if (this.first == null) {
                ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
                boxes.add(new LittleTileBox(vec));
                return boxes;
            }
            return this.getBoxes(player, nbt, this.first, vec, true);
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            if (this.first != null) {
                return true;
            }
            this.first = new LittleTileVec(result);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                this.first.sub(result.field_178784_b);
            }
            return false;
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt) {
            this.first = null;
        }

        @Override
        public List<LittleTileBox> getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            LittleTileVec vec = new LittleTileVec(result);
            if (result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                vec.sub(result.field_178784_b);
            }
            List<LittleTileBox> boxes = this.getBoxes(player, nbt, this.first, vec, false);
            this.first = null;
            return boxes;
        }

        @Override
        public void addExtraInformation(EntityPlayer player, NBTTagCompound nbt, List<String> list) {
            this.shape.addExtraInformation(nbt, list);
        }

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
            return this.shape.getCustomSettings(nbt);
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
            this.shape.saveCustomSettings(gui, nbt);
        }
    }

    public static abstract class BasicSelectShape
    extends SelectShape {
        public BasicSelectShape(String name) {
            super(name);
        }

        @Override
        public void deselect(EntityPlayer player, NBTTagCompound nbt) {
        }

        @Override
        public boolean rightClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return false;
        }

        @Override
        public boolean leftClick(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            return true;
        }

        @Override
        public List<LittleTileBox> getHighlightBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            LittleTileBox box = this.getBox(new LittleTileVec(result).getRelativeVec(result.func_178782_a()), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b);
            box.addOffset((Vec3i)result.func_178782_a());
            boxes.add(box);
            return boxes;
        }

        @Override
        public List<LittleTileBox> getBoxes(EntityPlayer player, NBTTagCompound nbt, RayTraceResult result) {
            ArrayList<LittleTileBox> boxes = new ArrayList<LittleTileBox>();
            LittleTileBox box = this.getBox(new LittleTileVec(result).getRelativeVec(result.func_178782_a()), Math.max(1, nbt.func_74762_e("thick")), result.field_178784_b);
            box.addOffset((Vec3i)result.func_178782_a());
            boxes.add(box);
            return boxes;
        }

        @Override
        public void addExtraInformation(EntityPlayer player, NBTTagCompound nbt, List<String> list) {
            list.add("thickness: " + Math.max(1, nbt.func_74762_e("thick")));
        }

        public abstract LittleTileBox getBox(LittleTileVec var1, int var2, EnumFacing var3);

        @Override
        public List<GuiControl> getCustomSettings(NBTTagCompound nbt) {
            ArrayList<GuiControl> controls = new ArrayList<GuiControl>();
            controls.add((GuiControl)new GuiLabel("Size:", 0, 6));
            controls.add((GuiControl)new GuiSteppedSlider("thickness", 35, 5, 68, 10, Math.max(1, nbt.func_74762_e("thick")), 1, LittleTile.gridSize));
            return controls;
        }

        @Override
        public void saveCustomSettings(GuiParent gui, NBTTagCompound nbt) {
            GuiSteppedSlider thickness = (GuiSteppedSlider)gui.get("thickness");
            nbt.func_74768_a("thick", (int)thickness.value);
        }
    }
}

