/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.placing;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.mods.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.FixedHandler;
import com.creativemd.littletiles.common.tiles.place.InsideFixedHandler;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlacementHelper {
    private static NBTTagCompound lastCached;
    private static ArrayList<LittleTilePreview> lastPreviews;

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).hasLittlePreview(stack);
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).hasLittlePreview(stack);
        }
        return false;
    }

    public static LittleTileVec getInternalOffset(List<LittleTilePreview> tiles) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileVec(0, 0, 0);
            }
            if (tile.box == null) continue;
            minX = Math.min(minX, tile.box.minX);
            minY = Math.min(minY, tile.box.minY);
            minZ = Math.min(minZ, tile.box.minZ);
        }
        return new LittleTileVec(minX, minY, minZ);
    }

    public static LittleTileSize getSize(List<LittleTilePreview> tiles) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LittleTileSize size = new LittleTileSize(0, 0, 0);
        for (int i = 0; i < tiles.size(); ++i) {
            LittleTilePreview tile = tiles.get(i);
            if (tile == null) {
                return new LittleTileSize(0, 0, 0);
            }
            minX = Math.min(minX, tile.box.minX);
            minY = Math.min(minY, tile.box.minY);
            minZ = Math.min(minZ, tile.box.minZ);
            maxX = Math.max(maxX, tile.box.maxX);
            maxY = Math.max(maxY, tile.box.maxY);
            maxZ = Math.max(maxZ, tile.box.maxZ);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public static void removeCache() {
        lastCached = null;
        lastPreviews = null;
    }

    public static PositionResult getPosition(World world, RayTraceResult moving) {
        PositionResult result = new PositionResult();
        int x = moving.func_178782_a().func_177958_n();
        int y = moving.func_178782_a().func_177956_o();
        int z = moving.func_178782_a().func_177952_p();
        boolean canBePlacedInsideBlock = true;
        if (!PlacementHelper.canBePlacedInside(world, moving.func_178782_a(), moving.field_72307_f, moving.field_178784_b)) {
            switch (moving.field_178784_b) {
                case EAST: {
                    ++x;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    break;
                }
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
            }
            canBePlacedInsideBlock = false;
        }
        result.facing = moving.field_178784_b;
        result.pos = new BlockPos(x, y, z);
        result.hit = PlacementHelper.getHitVec(moving, canBePlacedInsideBlock);
        return result;
    }

    public static PreviewResult getPreviews(World world, ItemStack stack, PositionResult position, boolean centered, boolean fixed, boolean allowLowResolution, boolean marked) {
        return PlacementHelper.getPreviews(world, stack, position.pos, position.hit, centered, position.facing, fixed, allowLowResolution, marked);
    }

    public static PreviewResult getPreviews(World world, ItemStack stack, BlockPos pos, LittleTileVec hit, boolean centered, @Nullable EnumFacing facing, boolean fixed, boolean allowLowResolution, boolean marked) {
        List<LittleTilePreview> tiles;
        PreviewResult result = new PreviewResult();
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        List<LittleTilePreview> list = tiles = allowLowResolution && iTile.shouldCache() && lastCached != null && lastCached.equals((Object)stack.func_77978_p()) ? new ArrayList<LittleTilePreview>(lastPreviews) : null;
        if (tiles == null && iTile != null) {
            tiles = iTile.getLittlePreview(stack, allowLowResolution, marked);
        }
        if (tiles != null && tiles.size() > 0) {
            result.previews = tiles;
            result.size = PlacementHelper.getSize(tiles);
            ArrayList<FixedHandler> shifthandlers = new ArrayList<FixedHandler>();
            if (tiles.size() == 1) {
                shifthandlers.addAll(tiles.get((int)0).fixedhandlers);
                shifthandlers.add(new InsideFixedHandler());
                result.singleMode = true;
                centered = true;
            }
            result.box = PlacementHelper.getTilesBox(hit, result.size, centered, facing);
            boolean canBePlaceFixed = false;
            if (fixed) {
                int i;
                Block block;
                if (!result.singleMode && ((block = world.func_180495_p(pos).func_177230_c()).func_176200_f((IBlockAccess)world, pos) || block instanceof BlockTile)) {
                    canBePlaceFixed = true;
                    TileEntity te = world.func_175625_s(pos);
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                        for (i = 0; i < tiles.size(); ++i) {
                            LittleTilePreview tile = tiles.get(i);
                            if (teTiles.isSpaceForLittleTile(tile.box)) continue;
                            canBePlaceFixed = false;
                            break;
                        }
                    }
                }
                if (!canBePlaceFixed) {
                    for (int i2 = 0; i2 < shifthandlers.size(); ++i2) {
                        ((FixedHandler)shifthandlers.get(i2)).init(world, pos);
                    }
                    FixedHandler handler = null;
                    double distance = 2.0;
                    for (i = 0; i < shifthandlers.size(); ++i) {
                        double tempDistance = ((FixedHandler)shifthandlers.get(i)).getDistance(hit);
                        if (!(tempDistance < distance)) continue;
                        distance = tempDistance;
                        handler = (FixedHandler)shifthandlers.get(i);
                    }
                    if (handler != null) {
                        result.box = handler.getNewPosition(world, pos, result.box);
                    }
                }
            }
            LittleTileVec offset = result.box.getMinVec();
            LittleTileVec internalOffset = PlacementHelper.getInternalOffset(tiles);
            internalOffset.invert();
            offset.add(internalOffset);
            result.offset = offset;
            result.placedFixed = canBePlaceFixed;
            for (int i = 0; i < tiles.size(); ++i) {
                PlacePreviewTile preview;
                LittleTilePreview tile = tiles.get(i);
                if (tile == null || (preview = tile.getPlaceableTile(result.box, canBePlaceFixed, offset)) == null) continue;
                result.placePreviews.add(preview);
            }
            LittleStructure structure = iTile.getLittleStructure(stack);
            if (structure != null) {
                ArrayList<PlacePreviewTile> newBoxes = structure.getSpecialTiles();
                for (int i = 0; i < newBoxes.size(); ++i) {
                    if (canBePlaceFixed) continue;
                    newBoxes.get((int)i).box.addOffset(offset);
                }
                result.placePreviews.addAll(newBoxes);
            }
            if (allowLowResolution) {
                if (stack.func_77978_p() == null) {
                    lastCached = null;
                    lastPreviews = null;
                } else {
                    lastCached = stack.func_77978_p().func_74737_b();
                    lastPreviews = new ArrayList<LittleTilePreview>(tiles);
                }
            }
            return result;
        }
        return null;
    }

    public static LittleTileBox getTilesBox(LittleTileVec hit, LittleTileSize size, boolean centered, @Nullable EnumFacing facing) {
        LittleTileVec temp = hit.copy();
        if (centered) {
            LittleTileVec center = size.calculateCenter();
            LittleTileVec centerInv = size.calculateInvertedCenter();
            switch (facing) {
                case EAST: {
                    temp.x += center.x;
                    break;
                }
                case WEST: {
                    temp.x -= centerInv.x;
                    break;
                }
                case UP: {
                    temp.y += center.y;
                    break;
                }
                case DOWN: {
                    temp.y -= centerInv.y;
                    break;
                }
                case SOUTH: {
                    temp.z += center.z;
                    break;
                }
                case NORTH: {
                    temp.z -= centerInv.z;
                    break;
                }
            }
        }
        return new LittleTileBox(temp, size);
    }

    public static boolean canBlockBeUsed(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return true;
        }
        return ChiselsAndBitsManager.isChiselsAndBitsStructure(tileEntity);
    }

    public static boolean canBePlacedInside(World world, BlockPos pos, Vec3d hitVec, EnumFacing side) {
        if (PlacementHelper.canBlockBeUsed(world, pos)) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return (double)((int)hitVec.field_72450_a) != hitVec.field_72450_a;
                }
                case UP: 
                case DOWN: {
                    return (double)((int)hitVec.field_72448_b) != hitVec.field_72448_b;
                }
                case SOUTH: 
                case NORTH: {
                    return (double)((int)hitVec.field_72449_c) != hitVec.field_72449_c;
                }
            }
            return false;
        }
        return false;
    }

    public static LittleTileVec getHitVec(RayTraceResult result, boolean isInsideOfBlock) {
        LittleTileVec vec = new LittleTileVec(result);
        vec.sub((Vec3i)result.func_178782_a());
        if (!isInsideOfBlock) {
            vec.setAxis(result.field_178784_b.func_176740_k(), result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : LittleTile.gridSize);
        }
        return vec;
    }

    public static class PreviewResult {
        public List<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        public List<LittleTilePreview> previews = null;
        public LittleTileBox box;
        public LittleTileSize size;
        public boolean singleMode = false;
        public boolean placedFixed = false;
        public LittleTileVec offset;
    }

    public static class PositionResult {
        public BlockPos pos;
        public LittleTileVec hit;
        public EnumFacing facing;

        public static PositionResult readFromBytes(ByteBuf buf) {
            PositionResult result = new PositionResult();
            result.pos = CreativeCorePacket.readPos((ByteBuf)buf);
            result.facing = CreativeCorePacket.readFacing((ByteBuf)buf);
            result.hit = new LittleTileVec(buf.readInt(), buf.readInt(), buf.readInt());
            return result;
        }

        public LittleTileVec getAbsoluteVec() {
            LittleTileVec absolute = new LittleTileVec((Vec3i)this.pos);
            absolute.add(this.hit);
            return absolute;
        }

        public void subVec(LittleTileVec vec) {
            this.hit.add(vec);
            this.updatePos();
        }

        public void addVec(LittleTileVec vec) {
            this.hit.sub(vec);
            this.updatePos();
        }

        public void writeToBytes(ByteBuf buf) {
            CreativeCorePacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
            CreativeCorePacket.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
            buf.writeInt(this.hit.x);
            buf.writeInt(this.hit.y);
            buf.writeInt(this.hit.z);
        }

        private void updatePos() {
            int amount;
            if (this.hit.x >= LittleTile.gridSize) {
                amount = this.hit.x / LittleTile.gridSize;
                this.hit.x -= amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(amount, 0, 0);
            }
            if (this.hit.y >= LittleTile.gridSize) {
                amount = this.hit.y / LittleTile.gridSize;
                this.hit.y -= amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(0, amount, 0);
            }
            if (this.hit.z >= LittleTile.gridSize) {
                amount = this.hit.z / LittleTile.gridSize;
                this.hit.z -= amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(0, 0, amount);
            }
            if (this.hit.x < 0) {
                amount = (int)Math.ceil(Math.abs((double)this.hit.x / (double)LittleTile.gridSize));
                this.hit.x += amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(-amount, 0, 0);
            }
            if (this.hit.y < 0) {
                amount = (int)Math.ceil(Math.abs((double)this.hit.y / (double)LittleTile.gridSize));
                this.hit.y += amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(0, -amount, 0);
            }
            if (this.hit.z < 0) {
                amount = (int)Math.ceil(Math.abs((double)this.hit.z / (double)LittleTile.gridSize));
                this.hit.z += amount * LittleTile.gridSize;
                this.pos = this.pos.func_177982_a(0, 0, -amount);
            }
        }

        public PositionResult copy() {
            PositionResult result = new PositionResult();
            result.facing = this.facing;
            result.pos = this.pos;
            result.hit = this.hit.copy();
            return result;
        }
    }
}

