/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.rotation;

import com.creativemd.littletiles.common.entity.EntityDoorAnimation;
import com.creativemd.littletiles.common.utils.rotation.OrdinaryDoorTransformation;
import com.creativemd.littletiles.common.utils.rotation.SlidingDoorTransformation;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public abstract class DoorTransformation {
    private static HashMap<String, Class<? extends DoorTransformation>> transformationTypes = new HashMap();

    public static void registerTransformationType(String id, Class<? extends DoorTransformation> classType) {
        if (transformationTypes.containsKey(id)) {
            throw new IllegalArgumentException("id '" + id + "' is already taken");
        }
        transformationTypes.put(id, classType);
    }

    public static String getIDFromClass(Class<? extends DoorTransformation> classType) {
        for (Map.Entry<String, Class<? extends DoorTransformation>> type : transformationTypes.entrySet()) {
            if (type.getValue() != classType) continue;
            return type.getKey();
        }
        return "";
    }

    public static DoorTransformation loadFromNBT(NBTTagCompound nbt) {
        Class<? extends DoorTransformation> type = transformationTypes.get(nbt.func_74779_i("id"));
        if (type != null) {
            try {
                DoorTransformation transformation = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                transformation.readFromNBT(nbt);
                return transformation;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(type.getClass() + " does not contain an empty constructor.");
            }
        }
        throw new IllegalArgumentException("id '" + nbt.func_74779_i("id") + "' could not be loaded.");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        this.writeToNBTExtra(nbt);
        nbt.func_74778_a("id", DoorTransformation.getIDFromClass(this.getClass()));
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    protected abstract void readFromNBT(NBTTagCompound var1);

    public abstract void performTransformation(EntityDoorAnimation var1, double var2);

    public abstract boolean equals(Object var1);

    static {
        DoorTransformation.registerTransformationType("ordinary", OrdinaryDoorTransformation.class);
        DoorTransformation.registerTransformationType("sliding", SlidingDoorTransformation.class);
    }
}

