/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.selection;

import com.creativemd.littletiles.common.tiles.LittleTile;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileSelector {
    private static HashMap<String, Class<? extends TileSelector>> selectorTypes = new HashMap();

    public static void registerType(String id, Class<? extends TileSelector> type) {
        selectorTypes.put(id, type);
    }

    public static String getTypeID(Class<? extends TileSelector> type) {
        for (Map.Entry<String, Class<? extends TileSelector>> entry : selectorTypes.entrySet()) {
            if (type != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Class<? extends TileSelector> getType(String id) {
        return selectorTypes.get(id);
    }

    public static TileSelector loadSelector(NBTTagCompound nbt) {
        Class<? extends TileSelector> type = TileSelector.getType(nbt.func_74779_i("type"));
        if (type != null) {
            try {
                TileSelector selector = type.getConstructor(new Class[0]).newInstance(new Object[0]);
                selector.loadNBT(nbt);
                return selector;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Selector type " + nbt.func_74779_i("type") + " is missing an empty constructor!");
            }
        }
        System.out.println("Selector " + nbt.func_74779_i("type") + " could not be found!");
        return null;
    }

    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        this.writeNBT(nbt);
        nbt.func_74778_a("type", TileSelector.getTypeID(this.getClass()));
        return nbt;
    }

    protected abstract void saveNBT(NBTTagCompound var1);

    protected abstract void loadNBT(NBTTagCompound var1);

    public abstract boolean is(LittleTile var1);
}

