/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class DropFuncBlock
extends DropFunction {
    @Override
    public void process(DropProcessData processData) {
        DropProperties drop = processData.getDropProperties();
        IBlockState blockState = drop.getBlockState();
        if (drop.getPropertyBoolean("blockUpdate").booleanValue()) {
            processData.getWorld().func_180501_a(drop.getBlockPos(), blockState, 3);
        } else {
            DropFuncBlock.setBlock(processData.getWorld(), blockState, drop.getBlockPos(), drop.getPropertyNBT("NBTTag"), drop.getPropertyBoolean("blockUpdate"));
        }
        DropFuncBlock.setTileEntity(processData.getWorld(), blockState, drop.getBlockPos(), drop.getPropertyNBT("NBTTag"));
    }

    @Override
    public void registerProperties() {
        DropProperties.setDefaultProperty(this.getType(), "tileEntity", NBTTagCompound.class, null);
        DropProperties.setDefaultProperty(this.getType(), "blockUpdate", Boolean.class, true);
        DropProperties.setReplaceProperty("meta", "damage");
        DropProperties.setReplaceProperty("state", "damage");
        DropProperties.setReplaceProperty("tileEntity", "NBTTag");
    }

    @Override
    public String getType() {
        return "block";
    }

    public static void setBlock(World world, IBlockState state, BlockPos pos, boolean update) {
        DropFuncBlock.setBlock(world, state, pos, null, update);
    }

    public static void setBlock(World world, IBlockState state, BlockPos pos, NBTTagCompound tileEntity, boolean update) {
        Chunk chunk = world.func_175726_f(pos);
        ExtendedBlockStorage storageArray = chunk.func_76587_i()[pos.func_177956_o() >> 4];
        if (storageArray == null) {
            ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
            chunk.func_76587_i()[pos.func_177956_o() >> 4] = extendedBlockStorage;
            storageArray = extendedBlockStorage;
        }
        if (storageArray.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF) != state.func_177230_c()) {
            IBlockState oldState = world.func_180495_p(pos);
            storageArray.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
            chunk.func_177427_f(true);
            world.markAndNotifyBlock(pos, chunk, oldState, state, 3);
            world.func_175664_x(pos);
            if (update) {
                world.markAndNotifyBlock(pos, chunk, state, oldState, 3);
            }
        }
        if (tileEntity != null && state.func_177230_c().hasTileEntity(state)) {
            world.func_175713_t(pos);
            BlockPos chunkPos = new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
            TileEntity blockTileEntity = chunk.func_177424_a(chunkPos, Chunk.EnumCreateEntityType.CHECK);
            blockTileEntity = state.func_177230_c().createTileEntity(world, state);
            blockTileEntity.func_145839_a(tileEntity);
            world.func_175690_a(pos, blockTileEntity);
            blockTileEntity.func_145836_u();
        }
    }

    public static void setTileEntity(World world, IBlockState state, BlockPos pos, NBTTagCompound tileEntity) {
        if (tileEntity != null && state.func_177230_c().hasTileEntity(state)) {
            Chunk chunk = world.func_175726_f(pos);
            ExtendedBlockStorage storageArray = chunk.func_76587_i()[pos.func_177956_o() >> 4];
            if (storageArray == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
                chunk.func_76587_i()[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storageArray = extendedBlockStorage;
            }
            world.func_175713_t(pos);
            BlockPos chunkPos = new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
            TileEntity blockTileEntity = chunk.func_177424_a(chunkPos, Chunk.EnumCreateEntityType.CHECK);
            blockTileEntity = state.func_177230_c().createTileEntity(world, state);
            blockTileEntity.func_145839_a(tileEntity);
            world.func_175690_a(pos, blockTileEntity);
            blockTileEntity.func_145836_u();
        }
    }
}

