/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import mod.lucky.crafting.LuckCraftingModifier;
import mod.lucky.init.SetupCommon;
import mod.lucky.item.ILuckyItemContainer;
import mod.lucky.item.ItemLuckyPotion;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeHidden;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class RecipeLuckCrafting
extends IRecipeHidden {
    private static HashMap<ILuckyItemContainer, ArrayList<LuckCraftingModifier>> LUCK_MODIFIERS = new HashMap();

    public RecipeLuckCrafting(ResourceLocation rl) {
        super(rl);
    }

    public static void addLuckModifier(ILuckyItemContainer forItem, LuckCraftingModifier luckModifier) {
        if (!LUCK_MODIFIERS.containsKey(forItem)) {
            LUCK_MODIFIERS.put(forItem, new ArrayList());
        }
        LUCK_MODIFIERS.get(forItem).add(luckModifier);
    }

    @Nullable
    private ItemStack findLuckyStack(IInventory table) {
        ItemStack luckyStack = null;
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            ItemStack stack = table.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ILuckyItemContainer)) continue;
            if (luckyStack != null) {
                return null;
            }
            luckyStack = stack;
        }
        return luckyStack;
    }

    public boolean func_77569_a(IInventory table, World world) {
        ItemStack luckyStack = this.findLuckyStack(table);
        if (luckyStack == null) {
            return false;
        }
        ArrayList<LuckCraftingModifier> luckModifiers = LUCK_MODIFIERS.get(luckyStack.func_77973_b());
        if (luckModifiers == null) {
            return false;
        }
        boolean foundModifier = false;
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            ItemStack stack = table.func_70301_a(i);
            if (stack.func_190926_b() || stack == luckyStack) continue;
            boolean isModifier = luckModifiers.stream().anyMatch(l -> l.getItem() == stack.func_77973_b());
            if (!isModifier) {
                return false;
            }
            foundModifier = true;
        }
        return foundModifier;
    }

    public ItemStack func_77572_b(IInventory table) {
        int baseLuckLevel = 0;
        int itemLuckLevelTotal = 0;
        ItemStack luckyStack = this.findLuckyStack(table);
        for (int i = 0; i < table.func_70302_i_(); ++i) {
            ItemStack stack = table.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int modifierLuck = 0;
            for (LuckCraftingModifier modifier : LUCK_MODIFIERS.get(luckyStack.func_77973_b())) {
                if (stack.func_77973_b() != modifier.getItem()) continue;
                modifierLuck = modifier.getLuckValue();
                if (!(stack.func_77973_b() instanceof ItemLuckyPotion)) continue;
                modifierLuck *= 4;
            }
            itemLuckLevelTotal += modifierLuck;
        }
        int resultLuckLevel = baseLuckLevel + itemLuckLevelTotal;
        if (resultLuckLevel > 100) {
            resultLuckLevel = 100;
        }
        if (resultLuckLevel < -100) {
            resultLuckLevel = -100;
        }
        ItemStack result = luckyStack.func_77946_l();
        result.func_190920_e(1);
        if (resultLuckLevel != 0) {
            if (result.func_77978_p() == null) {
                result.func_77982_d(new NBTTagCompound());
            }
            result.func_77978_p().func_74768_a("Luck", resultLuckLevel);
        } else {
            result.func_77982_d(null);
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public String func_193358_e() {
        return "lucky";
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SetupCommon.LUCK_CRAFTING;
    }
}

